/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.format;

import java.text.ParseException;
import net.fichotheque.SubsetKey;
import net.fichotheque.include.IncludeKey;
import net.mapeadores.util.text.StringUtils;

public final class SubsetPathKey {
    public static final short PARENTAGE_SUBSETKEY = 1;
    public static final short CROISEMENT_INCLUDEKEY = 2;
    public static final short THESAURUS_TREE = 3;
    public static final String ANCESTORS = "ancestors";
    public static final String DESCENDANTS = "descendants";
    public static final String PARENT = "parent";
    public static final String CHILDREN = "children";
    public static final String SIBLINGS = "siblings";
    private final int length;
    private final String pathString;
    private final short[] typeArray;
    private final Object[] keyObjectArray;

    private SubsetPathKey(short[] typeArray, Object[] keyObjectArray) {
        this.typeArray = typeArray;
        this.keyObjectArray = keyObjectArray;
        this.length = typeArray.length;
        this.pathString = SubsetPathKey.toString(keyObjectArray);
    }

    public int getLength() {
        return this.length;
    }

    public short getKeyType(int i) {
        return this.typeArray[i];
    }

    public Object getKeyObject(int i) {
        return this.keyObjectArray[i];
    }

    public SubsetKey getMatchingSubsetKey(int i) {
        Object obj = this.keyObjectArray[i];
        if (obj instanceof IncludeKey) {
            return ((IncludeKey)obj).getSubsetKey();
        }
        if (obj instanceof SubsetKey) {
            return (SubsetKey)obj;
        }
        if (i > 0) {
            return this.getMatchingSubsetKey(i - 1);
        }
        return null;
    }

    public String toString() {
        return this.pathString;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SubsetPathKey other = (SubsetPathKey)obj;
        return other.pathString.equals(this.pathString);
    }

    public int hashCode() {
        return this.pathString.hashCode();
    }

    public static SubsetPathKey parse(String subsetPathString) throws ParseException {
        if (subsetPathString == null || subsetPathString.isEmpty()) {
            return null;
        }
        String[] tokens = StringUtils.getTokens(subsetPathString, '/', (short)2);
        int length = tokens.length;
        if (length == 0) {
            return null;
        }
        short[] typeArray = new short[length];
        Object[] keyObjectArray = new Object[length];
        for (int i = 0; i < length; ++i) {
            String token = tokens[i];
            String thesaurusTreeToken = SubsetPathKey.testThesaurusTree(token);
            if (thesaurusTreeToken != null) {
                typeArray[i] = 3;
                keyObjectArray[i] = thesaurusTreeToken;
                continue;
            }
            try {
                SubsetKey parentageSubsetKey = SubsetKey.parseParentageSubsetKey(token);
                typeArray[i] = 1;
                keyObjectArray[i] = parentageSubsetKey;
                continue;
            }
            catch (ParseException pe) {
                IncludeKey includeKey = IncludeKey.parse(token);
                SubsetKey subsetKey = includeKey.getSubsetKey();
                if (!subsetKey.isCorpusSubset() && !subsetKey.isThesaurusSubset()) {
                    throw new ParseException("Wrong includeKey: " + includeKey, 0);
                }
                typeArray[i] = 2;
                keyObjectArray[i] = includeKey;
            }
        }
        return new SubsetPathKey(typeArray, keyObjectArray);
    }

    public static SubsetPathKey newParentagePath(SubsetKey parentageSubsetKey) {
        if (parentageSubsetKey == null) {
            throw new IllegalArgumentException("subsetKey is null");
        }
        short[] typeArray = new short[1];
        Object[] keyObjectArray = new Object[1];
        typeArray[0] = 1;
        keyObjectArray[0] = parentageSubsetKey;
        return new SubsetPathKey(typeArray, keyObjectArray);
    }

    private static String toString(Object[] keyObjectArray) {
        int length = keyObjectArray.length;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            Object obj;
            if (i > 0) {
                buf.append('/');
            }
            if ((obj = keyObjectArray[i]) instanceof SubsetKey) {
                buf.append(SubsetKey.toParentageString((SubsetKey)obj));
                continue;
            }
            buf.append(obj.toString());
        }
        return buf.toString();
    }

    private static String testThesaurusTree(String token) {
        switch (token) {
            case "ancestors": {
                return ANCESTORS;
            }
            case "descendants": {
                return DESCENDANTS;
            }
            case "parent": {
                return PARENT;
            }
            case "children": {
                return CHILDREN;
            }
            case "siblings": {
                return SIBLINGS;
            }
        }
        return null;
    }
}

