/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.storage;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.api.storage.EditableResourceStorage;
import fr.exemole.bdfserver.api.storage.StorageContent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.fichotheque.EditOrigin;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.history.HistoryUnit;
import net.fichotheque.tools.history.HistoryUnitBuilder;
import net.fichotheque.utils.EditOriginUtils;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.io.FileUtils;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.io.ResourceStorage;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.text.RelativePath;
import net.mapeadores.util.text.StringUtils;
import org.w3c.dom.Document;

public final class StorageUtils {
    public static final String EXTENSION_RESOURCE_PREFIX = "ext-rsc/";
    public static final RelativePath EXTENSION_RESOURCE_ROOT = RelativePath.build("ext-rsc");
    public static final String APPS_PREFIX = "apps/";
    public static final RelativePath APPS_ROOT = RelativePath.build("apps");
    public static final RelativePath ICON = RelativePath.build("images/icon.png");
    public static final RelativePath ICON32 = RelativePath.build("images/icon32.png");
    public static final RelativePath ICON48 = RelativePath.build("images/icon48.png");
    public static final RelativePath LOGO = RelativePath.build("images/logo.png");
    public static final RelativePath LOGO_ODT_INI = RelativePath.build("images/logo-odt.ini");
    public static final Pattern NAME_PATTERN = Pattern.compile("^[_a-zA-Z][-_.a-zA-Z0-9]*$");
    public static final List<StorageContent> EMPTY_STORAGECONTENTLIST = Collections.emptyList();
    private static final String NULL = "NULL";

    private StorageUtils() {
    }

    public static String getExtensionResourcePath(String registrationName, String relativePath) {
        return EXTENSION_RESOURCE_PREFIX + registrationName + "/" + relativePath;
    }

    public static RelativePath parseExtensionResourcePath(String registrationName, String relativePath) throws ParseException {
        return RelativePath.parse(StorageUtils.getExtensionResourcePath(registrationName, relativePath));
    }

    public static RelativePath buildExtensionResourcePath(String registrationName, String relativePath) {
        try {
            return StorageUtils.parseExtensionResourcePath(registrationName, relativePath);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe.getMessage());
        }
    }

    public static String getAppResourcePath(String appName, String relativePath) {
        return APPS_PREFIX + appName + "/" + relativePath;
    }

    public static RelativePath parseAppResourcePath(String appName, String relativePath) throws ParseException {
        return RelativePath.parse(StorageUtils.getAppResourcePath(appName, relativePath));
    }

    public static RelativePath buildAppResourcePath(String appName, String relativePath) {
        try {
            return StorageUtils.parseAppResourcePath(appName, relativePath);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe.getMessage());
        }
    }

    public static boolean containsDefaultResource(BdfServer bdfServer, RelativePath relativePath) {
        for (ResourceStorage resourceStorage : bdfServer.getResourceStorages()) {
            boolean here;
            if (resourceStorage.getName().equals("var") || !(here = resourceStorage.containsResource(relativePath))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsVarResource(BdfServer bdfServer, RelativePath relativePath) {
        EditableResourceStorage resourceStorage = bdfServer.getVarResourceStorage();
        if (resourceStorage != null) {
            return resourceStorage.containsResource(relativePath);
        }
        return false;
    }

    public static boolean removeResource(BdfServer bdfServer, RelativePath relativePath, EditOrigin editOrigin) {
        EditableResourceStorage resourceStorage = bdfServer.getVarResourceStorage();
        if (resourceStorage != null) {
            return resourceStorage.removeResource(relativePath, editOrigin);
        }
        return false;
    }

    public static void saveResource(BdfServer bdfServer, RelativePath relativePath, InputStream inputStream, EditOrigin editOrigin) throws IOException {
        EditableResourceStorage resourceStorage = bdfServer.getVarResourceStorage();
        if (resourceStorage != null) {
            resourceStorage.saveResource(relativePath, inputStream, editOrigin);
        }
    }

    public static void createDirectory(BdfServer bdfServer, RelativePath relativePath) {
        EditableResourceStorage resourceStorage = bdfServer.getVarResourceStorage();
        if (resourceStorage != null) {
            resourceStorage.createFolder(relativePath);
        }
    }

    public static boolean isValidResourceName(String name) {
        Matcher matcher = NAME_PATTERN.matcher(name);
        if (matcher.matches()) {
            int idx = name.indexOf(46);
            return idx > 0 && idx < name.length() - 1;
        }
        return false;
    }

    public static boolean isValidDirectoryName(String name) {
        Matcher matcher = NAME_PATTERN.matcher(name);
        return matcher.matches();
    }

    public static boolean isValidResourceRelativePath(RelativePath relativePath) {
        String[] array = relativePath.toArray();
        int length = array.length;
        if (length < 2) {
            return false;
        }
        for (int i = 0; i < length - 1; ++i) {
            String name = array[i];
            if (StorageUtils.isValidDirectoryName(name)) continue;
            return false;
        }
        return StorageUtils.isValidResourceName(array[length - 1]);
    }

    public static void writePasswordArray(Writer writer, String[] passwordArray) throws IOException {
        int length = passwordArray.length / 2;
        for (int i = 0; i < length; ++i) {
            writer.write(passwordArray[i * 2]);
            writer.write(":");
            writer.write(passwordArray[i * 2 + 1]);
            writer.write("\n");
        }
    }

    public static void writeExtensionList(Writer writer, List<String> extensionList) throws IOException {
        for (String registrationName : extensionList) {
            writer.append(registrationName);
            writer.write("\n");
        }
    }

    public static void writeChrono(Writer writer, FicheMeta ficheMeta) throws IOException {
        FuzzyDate creationDate = ficheMeta.getCreationDate();
        if (creationDate != null) {
            writer.write(creationDate.toString());
            FuzzyDate modificationDate = ficheMeta.getModificationDate();
            if (!modificationDate.equals(creationDate)) {
                writer.write("\n");
                writer.write(modificationDate.toString());
            }
        }
    }

    public static HistoryUnit getHistoryUnit(File mainFile, File backupFile) {
        File versionsLogFile;
        HistoryUnitBuilder builder = new HistoryUnitBuilder();
        if (mainFile.exists()) {
            StorageUtils.populateLastRevisions(backupFile, builder);
        } else {
            builder.setDeleted(true);
        }
        File archivesDir = StorageUtils.getArchivesDir(backupFile);
        if (archivesDir.exists() && (versionsLogFile = new File(archivesDir, "versions.log")).exists()) {
            LogBlock logBlock = null;
            ArrayList<LogBlock> logBlockList = new ArrayList<LogBlock>();
            try (BufferedReader reader2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(versionsLogFile), "UTF-8"));){
                String line;
                while ((line = reader2.readLine()) != null) {
                    if (line.isEmpty()) {
                        if (logBlock == null) continue;
                        logBlockList.add(logBlock);
                        logBlock = null;
                        continue;
                    }
                    if (logBlock == null) {
                        logBlock = new LogBlock(line);
                        continue;
                    }
                    logBlock.addLine(line);
                }
                if (logBlock != null) {
                    logBlockList.add(logBlock);
                }
            }
            catch (IOException reader2) {
                // empty catch block
            }
            int size = logBlockList.size();
            for (int i = size - 1; i >= 0; --i) {
                ((LogBlock)logBlockList.get(i)).addRevision(builder);
            }
        }
        return builder.toHistoryUnit();
    }

    public static void archive(File mainFile, File backupFile, EditOrigin editOrigin) throws IOException {
        if (backupFile == null) {
            return;
        }
        SessionInfo sessionInfo = StorageUtils.initSessionInfo(backupFile, editOrigin);
        if (mainFile.exists()) {
            byte[] mainArray;
            if (FileUtils.contentEquals(mainFile, backupFile)) {
                mainArray = null;
            } else {
                mainArray = FileUtils.readFileToByteArray(mainFile);
                try (FileOutputStream os = new FileOutputStream(backupFile);){
                    IOUtils.write(mainArray, (OutputStream)os);
                }
            }
            if (sessionInfo.isSameSession()) {
                sessionInfo.appendEditOrigin();
            } else {
                if (!sessionInfo.isFirstSession() && mainArray != null) {
                    ArchivesInfo archivesInfo = new ArchivesInfo(StorageUtils.getArchivesDir(backupFile));
                    archivesInfo.archive(mainArray, sessionInfo, false);
                }
                sessionInfo.saveNewSession();
            }
        } else {
            if (backupFile.exists()) {
                backupFile.delete();
            }
            sessionInfo.saveNewSession();
        }
    }

    public static void archiveBeforeDelete(File mainFile, File backupFile, EditOrigin editOrigin) throws IOException {
        if (backupFile == null) {
            return;
        }
        SessionInfo sessionInfo = StorageUtils.initSessionInfo(backupFile, editOrigin);
        if (mainFile.exists()) {
            ArchivesInfo archivesInfo = new ArchivesInfo(StorageUtils.getArchivesDir(backupFile));
            archivesInfo.archive(FileUtils.readFileToByteArray(mainFile), sessionInfo, true);
        }
        if (backupFile.exists()) {
            backupFile.delete();
        }
        sessionInfo.deleteSessionFile();
    }

    public static Document readDocument(File mainFile, File backupFile, String revisionName) {
        Document document;
        block10: {
            DocumentBuilder docbuilder;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            try {
                docbuilder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException pce) {
                throw new BdfStorageException(pce);
            }
            InputStream is = StorageUtils.getInputStream(mainFile, backupFile, revisionName);
            try {
                document = docbuilder.parse(is);
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return null;
                }
            }
            is.close();
        }
        return document;
    }

    public static void populate(List<StorageContent> storageContentList, File dir, String pathRoot) {
        String path = pathRoot + dir.getName() + "/";
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                StorageUtils.populate(storageContentList, f, path);
                continue;
            }
            String filePath = path + f.getName();
            storageContentList.add(StorageUtils.toStorageContent(filePath, f));
        }
    }

    public static List<StorageContent> wrap(StorageContent[] array) {
        return new StorageContentList(array);
    }

    public static StorageContent toStorageContent(String path, String text) {
        return new StringStorageContent(path, text);
    }

    public static StorageContent toStorageContent(String path, byte[] array) {
        return new ByteStorageContent(path, array);
    }

    public static StorageContent toStorageContent(String path, File file) {
        return new FileStorageContent(path, file);
    }

    private static InputStream getInputStream(File mainFile, File backupFile, String revisionName) throws IOException, MissingRevisionException {
        ZipEntry zipEntry;
        if (revisionName.equals("current")) {
            if (mainFile.exists()) {
                return new FileInputStream(mainFile);
            }
            throw new MissingRevisionException();
        }
        if (revisionName.equals("penultimate")) {
            if (backupFile.exists()) {
                return new FileInputStream(backupFile);
            }
            throw new MissingRevisionException();
        }
        if (!StringUtils.isTechnicalName(revisionName, true)) {
            throw new MissingRevisionException();
        }
        File archivesDir = StorageUtils.getArchivesDir(backupFile);
        File zipFile = new File(archivesDir, revisionName + ".zip");
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(zipFile));
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (!zipEntry.getName().equals(revisionName)) continue;
            return zipInputStream;
        }
        throw new MissingRevisionException();
    }

    private static File getArchivesDir(File backupFile) {
        return new File(backupFile.getAbsolutePath() + ".archives");
    }

    private static void populateLastRevisions(File backupFile, HistoryUnitBuilder historyUnitBuilder) {
        List<String> lignes = StorageUtils.readSessionLines(StorageUtils.getSessionFile(backupFile));
        if (lignes == null) {
            return;
        }
        int size = lignes.size();
        EditOrigin current = StorageUtils.stringToEditOrigin(lignes.get(size - 1), "current");
        if (current != null) {
            historyUnitBuilder.addRevision("current", current);
        }
        if (size > 2) {
            ArrayList<EditOrigin> penultimateList = new ArrayList<EditOrigin>();
            for (int i = size - 2; i >= 1; --i) {
                EditOrigin penultimate = StorageUtils.stringToEditOrigin(lignes.get(i), "penultimate");
                if (penultimate == null) continue;
                penultimateList.add(penultimate);
            }
            if (!penultimateList.isEmpty()) {
                historyUnitBuilder.addRevision("penultimate", penultimateList);
            }
        }
    }

    private static List<String> readSessionLines(File sessionFile) {
        if (sessionFile.exists() && sessionFile.isDirectory()) {
            sessionFile.delete();
            return null;
        }
        if (!sessionFile.exists()) {
            return null;
        }
        ArrayList<String> currentLines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sessionFile), "UTF-8"));){
            String line;
            while ((line = reader.readLine()) != null) {
                currentLines.add(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (currentLines.isEmpty()) {
            return null;
        }
        return currentLines;
    }

    private static File getSessionFile(File backupFile) {
        return new File(backupFile.getAbsolutePath() + ".session");
    }

    private static SessionInfo initSessionInfo(File backupFile, EditOrigin editOrigin) {
        File dir = backupFile.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return new SessionInfo(StorageUtils.getSessionFile(backupFile), editOrigin);
    }

    private static String editOriginToString(EditOrigin editOrigin) {
        StringBuilder buf = new StringBuilder();
        String redacteurGlobalId = editOrigin.getRedacteurGlobalId();
        if (redacteurGlobalId != null) {
            buf.append(redacteurGlobalId);
        } else {
            buf.append(NULL);
        }
        buf.append('|');
        buf.append(editOrigin.getISOTime());
        buf.append('|');
        buf.append(editOrigin.getSource());
        return buf.toString();
    }

    private static EditOrigin stringToEditOrigin(String editOriginString, String sessionId) {
        int idx1 = editOriginString.indexOf(124);
        if (idx1 < 0) {
            return null;
        }
        int idx2 = editOriginString.indexOf(124, idx1 + 1);
        if (idx2 < 0) {
            return null;
        }
        String redacteurGlobalId = editOriginString.substring(0, idx1);
        if (redacteurGlobalId.equals(NULL)) {
            redacteurGlobalId = null;
        }
        String isoTime = editOriginString.substring(idx1 + 1, idx2);
        String source = editOriginString.substring(idx2 + 1);
        return EditOriginUtils.newEditOrigin(source, sessionId, redacteurGlobalId, isoTime);
    }

    private static class LogBlock {
        private final String name;
        private final List<String> editOriginStringList = new ArrayList<String>();

        private LogBlock(String name) {
            this.name = name;
        }

        private void addLine(String line) {
            this.editOriginStringList.add(line);
        }

        private void addRevision(HistoryUnitBuilder historyUnitBuilder) {
            int size = this.editOriginStringList.size();
            if (size == 0) {
                return;
            }
            ArrayList<EditOrigin> editOriginList = new ArrayList<EditOrigin>();
            for (int i = size - 1; i >= 0; --i) {
                EditOrigin editOrigin = StorageUtils.stringToEditOrigin(this.editOriginStringList.get(i), this.name);
                if (editOrigin == null) continue;
                editOriginList.add(editOrigin);
            }
            if (!editOriginList.isEmpty()) {
                historyUnitBuilder.addRevision(this.name, editOriginList);
            }
        }
    }

    private static class SessionInfo {
        private final File sessionFile;
        private final List<String> lignes;
        private final String currentSessionId;
        private final String lastEditOriginString;
        private final String newEditOriginString;
        private final String newSessionId;

        private SessionInfo(File sessionFile, EditOrigin newEditOrigin) {
            this.sessionFile = sessionFile;
            this.lignes = StorageUtils.readSessionLines(sessionFile);
            this.newEditOriginString = StorageUtils.editOriginToString(newEditOrigin);
            this.newSessionId = this.getNewSessionId(newEditOrigin);
            this.currentSessionId = this.getCurrentSessionId();
            this.lastEditOriginString = this.getLastEditOriginString();
        }

        private String getNewSessionId(EditOrigin newEditOrigin) {
            String sessionId = newEditOrigin.getSessionId();
            if (sessionId == null) {
                return StorageUtils.NULL;
            }
            return sessionId;
        }

        private String getCurrentSessionId() {
            if (this.lignes == null) {
                return null;
            }
            return this.lignes.get(0);
        }

        private String getLastEditOriginString() {
            if (this.lignes != null) {
                int size = this.lignes.size();
                if (size > 1) {
                    return this.lignes.get(size - 1);
                }
                return null;
            }
            return null;
        }

        private boolean isFirstSession() {
            return this.currentSessionId == null;
        }

        private boolean isSameSession() {
            if (this.currentSessionId == null) {
                return false;
            }
            if (this.currentSessionId.equals(StorageUtils.NULL)) {
                if (this.lastEditOriginString == null) {
                    return false;
                }
                if (this.newSessionId.equals(StorageUtils.NULL)) {
                    return this.lastEditOriginString.equals(this.newEditOriginString);
                }
                return false;
            }
            return this.currentSessionId.equals(this.newSessionId);
        }

        private void saveNewSession() throws IOException {
            try (BufferedWriter writer = this.getWriter(false);){
                writer.write(this.newSessionId);
                writer.newLine();
                writer.write(this.newEditOriginString);
            }
        }

        private void appendEditOrigin() throws IOException {
            if (this.lastEditOriginString != null && this.lastEditOriginString.equals(this.newEditOriginString)) {
                return;
            }
            try (BufferedWriter writer = this.getWriter(true);){
                writer.newLine();
                writer.write(this.newEditOriginString);
            }
        }

        private BufferedWriter getWriter(boolean append) throws IOException {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.sessionFile, append), "UTF-8"));
        }

        private void writePreviousEditOriginList(BufferedWriter writer) throws IOException {
            if (this.lignes != null) {
                int size = this.lignes.size();
                for (int i = 1; i < size; ++i) {
                    writer.write(this.lignes.get(i));
                    writer.newLine();
                }
            }
        }

        private void writeNewEditOrigin(BufferedWriter writer) throws IOException {
            if (this.lastEditOriginString != null && this.lastEditOriginString.equals(this.newEditOriginString)) {
                return;
            }
            writer.write(this.newEditOriginString);
            writer.newLine();
        }

        private void deleteSessionFile() {
            if (this.sessionFile.exists()) {
                this.sessionFile.delete();
            }
        }
    }

    private static class ArchivesInfo {
        private final File archivesDir;

        private ArchivesInfo(File archivesDir) {
            if (archivesDir.exists() && !archivesDir.isDirectory()) {
                archivesDir.delete();
            }
            archivesDir.mkdir();
            this.archivesDir = archivesDir;
        }

        private int getNewVersionNumber() {
            File[] currentFiles = this.archivesDir.listFiles();
            int versionNumber = 1;
            for (File f : currentFiles) {
                String name = f.getName();
                if (!name.startsWith("v_") || !name.endsWith(".zip")) continue;
                try {
                    int vn = Integer.parseInt(name.substring(2, name.length() - 4));
                    versionNumber = Math.max(versionNumber, vn + 1);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return versionNumber;
        }

        private void archive(byte[] array, SessionInfo sessionInfo, boolean logCurrentSession) throws IOException {
            String vName = this.zip(array);
            this.log(vName, sessionInfo, logCurrentSession);
        }

        private String zip(byte[] array) throws IOException {
            String vName = "v_" + this.getNewVersionNumber();
            File zipFile = new File(this.archivesDir, vName + ".zip");
            try (ZipOutputStream os = new ZipOutputStream(new FileOutputStream(zipFile));){
                os.putNextEntry(new ZipEntry(vName));
                os.write(array, 0, array.length);
            }
            return vName;
        }

        private void log(String vName, SessionInfo sessionInfo, boolean logCurrentSession) throws IOException {
            File versionsLogFile = new File(this.archivesDir, "versions.log");
            boolean append = false;
            if (versionsLogFile.exists()) {
                if (versionsLogFile.isDirectory()) {
                    versionsLogFile.delete();
                } else {
                    append = true;
                }
            }
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(versionsLogFile, append), "UTF-8"));){
                if (append) {
                    writer.newLine();
                }
                writer.write(vName);
                writer.newLine();
                sessionInfo.writePreviousEditOriginList(writer);
                if (logCurrentSession) {
                    sessionInfo.writeNewEditOrigin(writer);
                }
            }
        }
    }

    private static class StorageContentList
    extends AbstractList<StorageContent>
    implements RandomAccess {
        private final StorageContent[] array;

        private StorageContentList(StorageContent[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public StorageContent get(int index) {
            return this.array[index];
        }
    }

    private static class StringStorageContent
    implements StorageContent {
        private final String path;
        private final String text;

        private StringStorageContent(String path, String text) {
            this.path = path;
            this.text = text;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public InputStream getInputStream() {
            try {
                byte[] array = this.text.getBytes("UTF-8");
                return new ByteArrayInputStream(array);
            }
            catch (IOException ioe) {
                throw new ShouldNotOccurException(ioe);
            }
        }
    }

    private static class ByteStorageContent
    implements StorageContent {
        private final String path;
        private final byte[] array;

        private ByteStorageContent(String path, byte[] array) {
            this.path = path;
            this.array = array;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.array);
        }
    }

    private static class FileStorageContent
    implements StorageContent {
        private final String path;
        private final File file;

        private FileStorageContent(String path, File file) {
            this.path = path;
            this.file = file;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new FileInputStream(this.file);
        }
    }

    private static class MissingRevisionException
    extends Exception {
        private MissingRevisionException() {
        }
    }
}

