/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.providers;

import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.api.providers.StreamProducerProvider;
import java.util.ArrayList;
import java.util.List;
import net.mapeadores.util.io.StreamProducer;
import net.mapeadores.util.logging.ErrorMessageException;

public class MultiStreamProducerProviderBuilder {
    private final List<StreamProducerProvider> providerList = new ArrayList<StreamProducerProvider>();

    public void addStreamProducerProvider(StreamProducerProvider streamProducerProvider) {
        if (streamProducerProvider instanceof MultiStreamProducerProvider) {
            StreamProducerProvider[] array = ((MultiStreamProducerProvider)streamProducerProvider).array;
            int length = array.length;
            for (int i = 0; i < length; ++i) {
                this.providerList.add(array[i]);
            }
        } else {
            this.providerList.add(streamProducerProvider);
        }
    }

    public StreamProducerProvider toStreamProducerProvider() {
        int size = this.providerList.size();
        return new MultiStreamProducerProvider(this.providerList.toArray(new StreamProducerProvider[size]));
    }

    private static class MultiStreamProducerProvider
    implements StreamProducerProvider {
        private StreamProducerProvider[] array;

        private MultiStreamProducerProvider(StreamProducerProvider[] array) {
            this.array = array;
        }

        @Override
        public StreamProducer getStreamProducer(OutputParameters parameters) throws ErrorMessageException {
            int length = this.array.length;
            for (int i = 0; i < length; ++i) {
                StreamProducer streamProducer = this.array[i].getStreamProducer(parameters);
                if (streamProducer == null) continue;
                return streamProducer;
            }
            return null;
        }
    }
}

