/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.menu;

import fr.exemole.bdfserver.api.menu.MenuLink;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.localisation.Message;

public class MenuLinkBuilder {
    private final String url;
    private String title;
    private Message titleMessage;
    private String iconPath;
    private String target;
    private String pageName;

    public MenuLinkBuilder(String url) {
        if (url == null) {
            throw new IllegalArgumentException("url is null");
        }
        this.url = url;
    }

    public MenuLinkBuilder setTitle(String title) {
        this.title = title;
        return this;
    }

    public MenuLinkBuilder setTitleMessage(Message titleMessage) {
        this.titleMessage = titleMessage;
        return this;
    }

    public MenuLinkBuilder setTitleMessage(String messageKey, Object ... messageValues) {
        this.titleMessage = LocalisationUtils.toMessage(messageKey, messageValues);
        return this;
    }

    public MenuLinkBuilder setIconPath(String iconPath) {
        this.iconPath = iconPath;
        return this;
    }

    public MenuLinkBuilder setTarget(String target) {
        this.target = target;
        return this;
    }

    public MenuLinkBuilder setPageName(String pageName) {
        this.pageName = pageName;
        return this;
    }

    public MenuLink toMenuLink() {
        String finalTitle = this.title;
        if (finalTitle == null) {
            finalTitle = this.titleMessage != null ? this.titleMessage.getMessageKey() : "";
        }
        return new InternalMenuLink(finalTitle, this.titleMessage, this.iconPath, this.target, this.url, this.pageName);
    }

    private static class InternalMenuLink
    implements MenuLink {
        private final String title;
        private final Message titleMessage;
        private final String iconPath;
        private final String target;
        private final String url;
        private final String pageName;

        private InternalMenuLink(String title, Message titleMessage, String iconPath, String target, String url, String pageName) {
            this.title = title;
            this.titleMessage = titleMessage;
            this.iconPath = iconPath;
            this.target = target;
            this.url = url;
            this.pageName = pageName;
        }

        @Override
        public Message getTitleMessage() {
            return this.titleMessage;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public String getIconPath() {
            return this.iconPath;
        }

        @Override
        public String getTarget() {
            return this.target;
        }

        @Override
        public String getUrl() {
            return this.url;
        }

        @Override
        public String getPageName() {
            return this.pageName;
        }
    }
}

