/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.jslib;

import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.tools.jslib.BdfJsLibBuilder;
import fr.exemole.bdfserver.tools.jslib.JsLibConf;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.BiConsumer;
import net.mapeadores.util.ini.IniParser;
import net.mapeadores.util.io.DocStream;
import net.mapeadores.util.io.ResourceStorages;
import net.mapeadores.util.jslib.TemplateFamily;
import net.mapeadores.util.jslib.TemplateFamilyBuilder;
import net.mapeadores.util.text.RelativePath;
import net.mapeadores.util.text.StringUtils;

public final class JsLibConfFactory {
    private final short PARAMS_SECTION = 1;
    private final short USE_SECTION = (short)2;
    private final short CSS_SECTION = (short)3;
    private final short JAVASCRIPT_SECTION = (short)4;
    private final String name;
    private final ResourceStorages resourceStorages;
    private final RelativePath libDir;
    private short currentSection = 1;
    private final Map<String, String> iniMap = new HashMap<String, String>();
    private final BdfJsLibBuilder jsLibBuilder = new BdfJsLibBuilder();
    private final Set<String> pageSet = new LinkedHashSet<String>();
    private BiConsumer<String, String> consumer;

    private JsLibConfFactory(ResourceStorages resourceStorages, String name, RelativePath libDir) {
        this.resourceStorages = resourceStorages;
        this.name = name;
        this.libDir = libDir;
        this.consumer = (key, value) -> this.iniMap.put((String)key, (String)value);
    }

    public static JsLibConf newInstance(ResourceStorages resourceStorages, String name, RelativePath libDir) {
        JsLibConfFactory factory = new JsLibConfFactory(resourceStorages, name, libDir);
        factory.parseConfFile();
        factory.checkSubfolders();
        return factory.toJsLibConf();
    }

    private void parseConfFile() {
        DocStream docStream = this.resourceStorages.getResourceDocStream(this.libDir.buildChild("jslib.conf"));
        if (docStream != null) {
            try (BufferedReader reader = new BufferedReader(docStream.getReader());){
                String line;
                while ((line = reader.readLine()) != null) {
                    this.parseLine(line);
                }
            }
            catch (IOException ioe) {
                throw new BdfStorageException(ioe);
            }
        }
    }

    private void parseLine(String line) {
        if ((line = line.trim()).length() == 0) {
            return;
        }
        char carac = line.charAt(0);
        switch (carac) {
            case '!': 
            case '#': 
            case ';': {
                return;
            }
            case '[': {
                this.currentSection = this.checkSection(line.substring(1));
                return;
            }
        }
        switch (this.currentSection) {
            case 2: {
                this.parseUse(line);
                break;
            }
            case 3: {
                this.parseCss(line);
                break;
            }
            case 4: {
                this.parseJavascript(line);
                break;
            }
            default: {
                this.parseParam(line);
            }
        }
    }

    private short checkSection(String sectionName) {
        int idx = sectionName.indexOf(93);
        if (idx > -1) {
            sectionName = sectionName.substring(0, idx);
        }
        sectionName = sectionName.trim();
        switch (sectionName = sectionName.toLowerCase()) {
            case "use": {
                return 2;
            }
            case "css": {
                return 3;
            }
            case "js": 
            case "javascript": {
                return 4;
            }
        }
        return 1;
    }

    private void parseParam(String line) {
        IniParser.parseLine(line, this.consumer);
    }

    private void parseUse(String line) {
        this.pageSet.add(line);
    }

    private void parseJavascript(String line) {
        try {
            this.jsLibBuilder.addJsScript(this.convertToRelativePath(line));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private void parseCss(String line) {
        try {
            this.jsLibBuilder.addCssPath(this.convertToRelativePath(line));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private void checkSubfolders() {
        SortedMap<String, RelativePath> subFolders = this.resourceStorages.listSubFolders(this.libDir);
        for (Map.Entry<String, RelativePath> entry : subFolders.entrySet()) {
            RelativePath subfolderPath = entry.getValue();
            switch (entry.getKey()) {
                case "templates": {
                    TemplateFamily jslibTemplateFamily = TemplateFamilyBuilder.init(this.name).setPath(subfolderPath).toTemplateFamily();
                    this.jsLibBuilder.addTemplateFamily(jslibTemplateFamily);
                    break;
                }
                case "js": {
                    this.jsLibBuilder.scanJavascriptFolder(this.resourceStorages, subfolderPath);
                    break;
                }
                case "css": {
                    this.jsLibBuilder.scanCssFolder(this.resourceStorages, subfolderPath);
                }
            }
        }
    }

    private void addJavascriptFiles() {
    }

    private JsLibConf toJsLibConf() {
        return new JsLibConf(this.iniMap, this.jsLibBuilder.toJsLib(), StringUtils.toList(this.pageSet));
    }

    private RelativePath convertToRelativePath(String path) throws ParseException {
        if (path.startsWith("/")) {
            return RelativePath.parse(path.substring(0));
        }
        return this.libDir.parseChild(path);
    }
}

