/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.instruction;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.exportation.table.FicheTableParameters;
import fr.exemole.bdfserver.api.managers.TableExportManager;
import fr.exemole.bdfserver.api.managers.TransformationManager;
import fr.exemole.bdfserver.api.roles.Role;
import fr.exemole.bdfserver.tools.exportation.table.FicheTableParametersBuilder;
import fr.exemole.bdfserver.tools.exportation.transformation.BdfTransformationUtils;
import fr.exemole.bdfserver.tools.instruction.AbstractRequestHandler;
import fr.exemole.bdfserver.tools.instruction.BdfCommandUtils;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import java.util.Comparator;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.addenda.Document;
import net.fichotheque.album.Album;
import net.fichotheque.album.Illustration;
import net.fichotheque.album.metadata.AlbumDim;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.SortConstants;
import net.fichotheque.exportation.access.AccessDef;
import net.fichotheque.exportation.balayage.BalayageContentDescription;
import net.fichotheque.exportation.balayage.BalayageDescription;
import net.fichotheque.exportation.scrutari.ScrutariExportDef;
import net.fichotheque.exportation.sql.SqlExportDef;
import net.fichotheque.exportation.table.TableExportConstants;
import net.fichotheque.exportation.table.TableExportContentDescription;
import net.fichotheque.exportation.table.TableExportDescription;
import net.fichotheque.exportation.transformation.TemplateContentDescription;
import net.fichotheque.exportation.transformation.TemplateDescription;
import net.fichotheque.exportation.transformation.TemplateKey;
import net.fichotheque.exportation.transformation.TransformationDescription;
import net.fichotheque.exportation.transformation.TransformationKey;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.selection.FichothequeQueries;
import net.fichotheque.selection.MotcleQuery;
import net.fichotheque.selection.SelectionDef;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.selection.FichothequeQueriesBuilder;
import net.fichotheque.tools.selection.SelectionDOMUtils;
import net.fichotheque.utils.BalayageUtils;
import net.fichotheque.utils.Comparators;
import net.fichotheque.utils.TableExportUtils;
import net.fichotheque.utils.ThesaurusUtils;
import net.fichotheque.utils.selection.FicheSelectorBuilder;
import net.fichotheque.utils.selection.MotcleSelectorBuilder;
import net.mapeadores.util.io.ResourceUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.LabelChange;
import net.mapeadores.util.text.RelativePath;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.text.tableparser.CsvParameters;
import net.mapeadores.util.text.tableparser.SheetCopyParameters;
import net.mapeadores.util.text.tableparser.TableParser;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class AbstractUtilRequestHandler
extends AbstractRequestHandler {
    public AbstractUtilRequestHandler(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    public Comparator<FicheMeta> getComparator(Lang lang) throws ErrorMessageException {
        String sort = this.getTrimedParameter("sort");
        if (sort.isEmpty()) {
            return Comparators.FICHEID_ASC;
        }
        try {
            sort = SortConstants.checkSortType(sort);
            return Comparators.getComparator(sort, lang);
        }
        catch (IllegalArgumentException iae) {
            throw BdfErrors.unknownParameterValue("sort", sort);
        }
    }

    public FicheTableParameters getFicheTableParameters() throws ErrorMessageException {
        String[] tokens;
        FicheTableParametersBuilder ficheTableParametersBuilder = new FicheTableParametersBuilder();
        for (String token : tokens = this.getTokens("with")) {
            ficheTableParametersBuilder.putWith(token);
        }
        String patternMode = this.getTrimedParameter("patternmode");
        if (!patternMode.isEmpty()) {
            try {
                ficheTableParametersBuilder.setPatternMode(patternMode);
            }
            catch (IllegalArgumentException iae) {
                throw new ErrorMessageException("_ error.unknown.patternmode", patternMode);
            }
        }
        return ficheTableParametersBuilder.toFicheTableParameters();
    }

    public String getHeaderType() throws ErrorMessageException {
        String headerTypeValue = this.getTrimedParameter("headertype");
        if (headerTypeValue.isEmpty()) {
            return "columntitle";
        }
        try {
            return TableExportConstants.checkHeaderType(headerTypeValue);
        }
        catch (IllegalArgumentException iae) {
            throw BdfErrors.unknownParameterValue("headertype", headerTypeValue);
        }
    }

    public LabelChange getLabelChange(String paramPrefix) {
        return BdfCommandUtils.getLabelChange(this.requestMap, paramPrefix, true);
    }

    public LabelChange getLabelChange(String paramPrefix, boolean withTypoParsing) {
        return BdfCommandUtils.getLabelChange(this.requestMap, paramPrefix, withTypoParsing);
    }

    public String getMode() throws ErrorMessageException {
        String mode = this.requestMap.getTrimedParameter("mode");
        if (mode.isEmpty()) {
            return "";
        }
        try {
            StringUtils.checkTechnicalName(mode, false);
        }
        catch (ParseException pe) {
            throw BdfErrors.error("_ error.wrong.mode", mode);
        }
        this.store("mode", mode);
        return mode;
    }

    public TableParser.Parameters getTableParserParameters() throws ErrorMessageException {
        String parseType = this.getMandatoryParameter("parsetype");
        String delimParam = this.getTrimedParameter("csv_delimiter");
        String quoteParam = this.getTrimedParameter("csv_quote");
        boolean escapedCSV = this.isTrue("csv_escaped");
        TableParser.Parameters params = null;
        if (parseType.equals("sheetcopy")) {
            params = new SheetCopyParameters();
        } else if (parseType.equals("csv")) {
            CsvParameters csvParameters = new CsvParameters();
            if (!delimParam.isEmpty()) {
                try {
                    char delim = StringUtils.stringToChar(delimParam);
                    csvParameters.setDelimiter(delim);
                }
                catch (IllegalArgumentException iae) {
                    throw BdfErrors.wrongParameterValue("csv_delimiter", delimParam);
                }
            }
            if (!quoteParam.isEmpty()) {
                try {
                    char quote = StringUtils.stringToChar(quoteParam);
                    csvParameters.setQuote(quote);
                }
                catch (IllegalArgumentException iae) {
                    throw BdfErrors.wrongParameterValue("csv_quote", quoteParam);
                }
            }
            csvParameters.setEscapedCSV(escapedCSV);
            params = csvParameters;
        } else {
            throw BdfErrors.wrongParameterValue("parsetype", parseType);
        }
        return params;
    }

    public AccessDef getMandatoryAccessDef() throws ErrorMessageException {
        String param_access = this.getMandatoryParameter("access");
        AccessDef accessDef = this.bdfServer.getAccessManager().getAccessDef(param_access);
        if (accessDef == null) {
            throw BdfErrors.unknownParameterValue("access", param_access);
        }
        return accessDef;
    }

    public Addenda getMandatoryAddenda() throws ErrorMessageException {
        return (Addenda)this.getMandatorySubset((short)4);
    }

    public Album getMandatoryAlbum() throws ErrorMessageException {
        return (Album)this.getMandatorySubset((short)5);
    }

    public AlbumDim getMandatoryAlbumDim() throws ErrorMessageException {
        Album album = this.getMandatoryAlbum();
        String paramValue = this.getMandatoryParameter("albumdim");
        AlbumDim albumDim = album.getAlbumMetadata().getAlbumDimByName(paramValue);
        if (albumDim == null) {
            throw BdfErrors.unknownParameterValue("albumdim", paramValue);
        }
        return albumDim;
    }

    public BalayageDescription getMandatoryBalayageDescription() throws ErrorMessageException {
        String param_balayage = this.getMandatoryParameter("balayage");
        BalayageDescription balayageDescription = this.bdfServer.getBalayageManager().getBalayage(param_balayage);
        if (balayageDescription == null) {
            throw BdfErrors.unknownParameterValue("balayage", param_balayage);
        }
        return balayageDescription;
    }

    public BalayageContentDescription getMandatoryBalayageContentDescription(BalayageDescription balayageDescription) throws ErrorMessageException {
        String contentPath = this.getMandatoryPath();
        BalayageContentDescription description = BalayageUtils.getBalayageContentDescription(balayageDescription, contentPath);
        if (description == null) {
            throw BdfErrors.unknownParameterValue("path", contentPath);
        }
        return description;
    }

    public Corpus getMandatoryCorpus() throws ErrorMessageException {
        return (Corpus)this.getMandatorySubset((short)1);
    }

    public Document getMandatoryDocument() throws ErrorMessageException {
        return (Document)this.getMandatorySubsetItem((short)4);
    }

    public FicheMeta getMandatoryFicheMeta() throws ErrorMessageException {
        return (FicheMeta)this.getMandatorySubsetItem((short)1);
    }

    public int getMandatoryId() throws ErrorMessageException {
        int id = this.getMandatoryIntegerParameter("id");
        if (id < 1) {
            throw BdfErrors.wrongParameterValue("id", this.requestMap.getParameter("id"));
        }
        return id;
    }

    public Illustration getMandatoryIllustration() throws ErrorMessageException {
        return (Illustration)this.getMandatorySubsetItem((short)5);
    }

    public int getMandatoryIntegerParameter(String paramName) throws ErrorMessageException {
        String paramValue = this.requestMap.getParameter(paramName);
        if (paramValue == null) {
            throw BdfErrors.emptyMandatoryParameter(paramName);
        }
        try {
            int value = Integer.parseInt(paramValue);
            this.store(paramName, String.valueOf(value));
            return value;
        }
        catch (NumberFormatException nfe) {
            throw BdfErrors.wrongParameterValue(paramName, paramValue);
        }
    }

    public Motcle getMandatoryMotcle() throws ErrorMessageException {
        Thesaurus thesaurus;
        String idString = this.requestMap.getParameter("idmtcl");
        if (idString != null) {
            return this.getMandatoryMotcle("idmtcl");
        }
        String idalpha = this.requestMap.getTrimedParameter("idalpha");
        if (!idalpha.isEmpty() && (thesaurus = this.getMandatoryThesaurus()).isIdalphaType()) {
            Motcle motcle = thesaurus.getMotcleByIdalpha(idalpha);
            if (motcle != null) {
                this.store("idalpha", idalpha);
                return motcle;
            }
            throw BdfErrors.wrongParameterValue("idalpha", idalpha);
        }
        return (Motcle)this.getMandatorySubsetItem((short)2);
    }

    public Motcle getMandatoryMotcle(String paramName) throws ErrorMessageException {
        String idString = this.requestMap.getParameter(paramName);
        Thesaurus thesaurus = this.getMandatoryThesaurus();
        Motcle motcle = null;
        try {
            motcle = ThesaurusUtils.getMotcle(thesaurus, idString);
        }
        catch (NumberFormatException nfe) {
            throw BdfErrors.wrongParameterValue(paramName, idString);
        }
        if (motcle == null) {
            throw BdfErrors.unknownParameterValue(paramName, idString);
        }
        this.store(paramName, idString);
        return motcle;
    }

    public String getMandatoryPath() throws ErrorMessageException {
        String path = this.getMandatoryParameter("path").trim();
        if (path.isEmpty()) {
            throw BdfErrors.wrongParameterValue("path", path);
        }
        return path;
    }

    public RelativePath getMandatoryRelativePath() throws ErrorMessageException {
        RelativePath relativePath;
        String path = this.getMandatoryParameter("path");
        try {
            relativePath = RelativePath.parse(path);
            if (!ResourceUtils.isValidResourceRelativePath(relativePath)) {
                relativePath = null;
            }
        }
        catch (ParseException pe) {
            relativePath = null;
        }
        if (relativePath == null) {
            throw BdfErrors.wrongParameterValue("path", path);
        }
        return relativePath;
    }

    public Redacteur getMandatoryRedacteur() throws ErrorMessageException {
        return (Redacteur)this.getMandatorySubsetItem((short)3);
    }

    public Role getMandatoryRole() throws ErrorMessageException {
        String roleString = this.getMandatoryParameter("role");
        Role role = this.bdfServer.getPermissionManager().getRole(roleString);
        if (role == null) {
            throw BdfErrors.unknownParameterValue("role", roleString);
        }
        return role;
    }

    public Sphere getMandatorySphere() throws ErrorMessageException {
        return (Sphere)this.getMandatorySubset((short)3);
    }

    public Subset getMandatorySubset(short subsetCategory) throws ErrorMessageException {
        return this.getMandatorySubset(subsetCategory, SubsetKey.categoryToString(subsetCategory));
    }

    public Subset getMandatorySubset(short subsetCategory, String paramName) throws ErrorMessageException {
        String paramValue = this.getMandatoryParameter(paramName);
        try {
            SubsetKey subsetKey = SubsetKey.parse(subsetCategory, paramValue);
            Subset subset = this.getFichotheque().getSubset(subsetKey);
            if (subset == null) {
                throw BdfErrors.unknownParameterValue(paramName, paramValue);
            }
            return subset;
        }
        catch (ParseException pe) {
            throw BdfErrors.wrongParameterValue(paramName, paramValue);
        }
    }

    public Subset getMandatorySubset() throws ErrorMessageException {
        return this.getMandatorySubset("subset");
    }

    public Subset getMandatorySubset(String paramName) throws ErrorMessageException {
        String paramValue = this.getMandatoryParameter(paramName);
        try {
            SubsetKey subsetKey = SubsetKey.parse(paramValue);
            Subset subset = this.getFichotheque().getSubset(subsetKey);
            if (subset == null) {
                throw BdfErrors.unknownParameterValue(paramName, paramValue);
            }
            return subset;
        }
        catch (ParseException pe) {
            throw BdfErrors.wrongParameterValue(paramName, paramValue);
        }
    }

    public SubsetItem getMandatorySubsetItem(short subsetCategory) throws ErrorMessageException {
        int id = this.getMandatoryId();
        Subset subset = this.getMandatorySubset(subsetCategory);
        SubsetItem subsetItem = subset.getSubsetItemById(id);
        if (subsetItem == null) {
            throw BdfErrors.unknownParameterValue("id", String.valueOf(id));
        }
        return subsetItem;
    }

    public ScrutariExportDef getMandatoryScrutariExportDef() throws ErrorMessageException {
        String scrutariexportString = this.getMandatoryParameter("scrutariexport");
        ScrutariExportDef scrutariExportDef = this.bdfServer.getScrutariExportManager().getScrutariExportDef(scrutariexportString);
        if (scrutariExportDef == null) {
            throw BdfErrors.unknownParameterValue("scrutariexport", scrutariexportString);
        }
        return scrutariExportDef;
    }

    public SelectionDef getMandatorySelectionDef() throws ErrorMessageException {
        String param_selection = this.getMandatoryParameter("selection");
        SelectionDef selectionDef = this.bdfServer.getSelectionManager().getSelectionDef(param_selection);
        if (selectionDef == null) {
            throw BdfErrors.unknownParameterValue("selection", param_selection);
        }
        return selectionDef;
    }

    public SqlExportDef getMandatorySqlExportDef() throws ErrorMessageException {
        String param_sqlexport = this.getMandatoryParameter("sqlexport");
        SqlExportDef sqlExportDef = this.bdfServer.getSqlExportManager().getSqlExportDef(param_sqlexport);
        if (sqlExportDef == null) {
            throw BdfErrors.unknownParameterValue("sqlexport", param_sqlexport);
        }
        return sqlExportDef;
    }

    public SubsetItem getMandatorySubsetItem(Subset subset) throws ErrorMessageException {
        int id = this.getMandatoryId();
        SubsetItem subsetItem = subset.getSubsetItemById(id);
        if (subsetItem == null) {
            throw BdfErrors.unknownParameterValue("id", String.valueOf(id));
        }
        return subsetItem;
    }

    public TableExportDescription getMandatoryTableExportDescription() throws ErrorMessageException {
        TableExportManager tableExportManager = this.bdfServer.getTableExportManager();
        String tableExportName = this.getMandatoryParameter("tableexport");
        for (TableExportDescription tableExportDescription : tableExportManager.getTableExportDescriptionList()) {
            if (!tableExportDescription.getName().equals(tableExportName)) continue;
            return tableExportDescription;
        }
        throw BdfErrors.unknownParameterValue("tableexport", tableExportName);
    }

    public TableExportContentDescription getMandatoryTableExportContentDescription(TableExportDescription tableExportDescription) throws ErrorMessageException {
        String contentPath = this.getMandatoryPath();
        TableExportContentDescription description = TableExportUtils.getTableExportContentDescription(tableExportDescription, contentPath);
        if (description == null) {
            throw BdfErrors.unknownParameterValue("path", contentPath);
        }
        return description;
    }

    public TemplateDescription getMandatoryTemplateDescription() throws ErrorMessageException {
        TemplateKey templateKey;
        TransformationManager transformationManager = this.bdfServer.getTransformationManager();
        String templateKeyString = this.getMandatoryParameter("template");
        try {
            templateKey = TemplateKey.parse(templateKeyString);
        }
        catch (ParseException pe) {
            throw BdfErrors.unknownParameterValue("template", templateKeyString);
        }
        TemplateDescription templateDescription = BdfTransformationUtils.getTemplateDescription(transformationManager, templateKey);
        if (templateDescription == null) {
            throw BdfErrors.unknownParameterValue("template", templateKeyString);
        }
        return templateDescription;
    }

    public TemplateContentDescription getMandatoryTemplateContentDescription(TemplateDescription templateDescription) throws ErrorMessageException {
        String contentPath = this.getMandatoryPath();
        TemplateContentDescription description = templateDescription.getTemplateContentDescription(contentPath);
        if (description == null) {
            throw BdfErrors.unknownParameterValue("path", contentPath);
        }
        return description;
    }

    public Thesaurus getMandatoryThesaurus() throws ErrorMessageException {
        return (Thesaurus)this.getMandatorySubset((short)2);
    }

    public TransformationDescription getMandatoryTransformationDescription() throws ErrorMessageException {
        TransformationManager transformationManager = this.bdfServer.getTransformationManager();
        String s = this.getMandatoryParameter("transformation");
        try {
            TransformationKey transformationKey = TransformationKey.parse(s);
            return transformationManager.getTransformationDescription(transformationKey);
        }
        catch (ParseException pe) {
            throw BdfErrors.wrongParameterValue("transformation", s);
        }
    }

    public Motcle getOptionnalMotcle(Thesaurus thesaurus) throws ErrorMessageException {
        String idmtclValue = this.requestMap.getParameter("idmtcl");
        if (idmtclValue == null) {
            return (Motcle)this.getOptionnalSubsetItem(thesaurus);
        }
        try {
            Motcle motcle = ThesaurusUtils.getMotcle(thesaurus, idmtclValue);
            this.store("idmtcl", idmtclValue);
            return motcle;
        }
        catch (NumberFormatException nfe) {
            throw BdfErrors.wrongParameterValue("idmtcl", idmtclValue);
        }
    }

    public SubsetItem getOptionnalSubsetItem(Subset subset) throws ErrorMessageException {
        return this.getOptionnalSubsetItem(subset, "id");
    }

    public SubsetItem getOptionnalSubsetItem(Subset subset, String paramName) throws ErrorMessageException {
        String idString = this.requestMap.getParameter(paramName);
        if (idString == null) {
            return null;
        }
        int id = 0;
        try {
            id = Integer.parseInt(idString);
        }
        catch (NumberFormatException nfe) {
            throw BdfErrors.wrongParameterValue(paramName, idString);
        }
        if (id < 1) {
            throw BdfErrors.wrongParameterValue(paramName, idString);
        }
        SubsetItem subsetItem = subset.getSubsetItemById(id);
        this.store(paramName, String.valueOf(id));
        return subsetItem;
    }

    public FicheSelectorBuilder populate(FicheSelectorBuilder builder) throws ErrorMessageException {
        if (this.hasParameter("selection")) {
            return this.populateFromSelection(builder);
        }
        return this.populateFromXml(builder);
    }

    public FicheSelectorBuilder populateFromSelection(FicheSelectorBuilder builder) throws ErrorMessageException {
        SelectionDef selectionDef = this.getMandatorySelectionDef();
        for (FicheQuery ficheQuery : selectionDef.getFichothequeQueries().getFicheQueryList()) {
            builder.add(ficheQuery);
        }
        return builder;
    }

    public FicheSelectorBuilder populateFromXml(FicheSelectorBuilder builder) throws ErrorMessageException {
        org.w3c.dom.Document document;
        String xml = this.getMandatoryParameter("xml");
        if ((xml = xml.trim()).length() == 0) {
            throw BdfErrors.wrongParameterValue("xml", "");
        }
        try {
            document = DOMUtils.parseDocument(xml);
        }
        catch (SAXException sae) {
            throw BdfErrors.error("_ error.exception.xml.sax", sae.getMessage());
        }
        Element root = document.getDocumentElement();
        switch (root.getTagName()) {
            case "fiche-query": 
            case "fiche-select": {
                FicheQuery ficheQuery = SelectionDOMUtils.getFicheConditionEntry(this.bdfServer.getFichotheque(), root).getFicheQuery();
                builder.add(ficheQuery);
                break;
            }
            default: {
                FichothequeQueriesBuilder fichothequeQueriesBuilder = new FichothequeQueriesBuilder();
                DOMUtils.readChildren(root, SelectionDOMUtils.getQueryElementConsumer(this.bdfServer.getFichotheque(), fichothequeQueriesBuilder));
                FichothequeQueries fichothequeQueries = fichothequeQueriesBuilder.toFichothequeQueries();
                if (fichothequeQueries.getFicheQueryList().isEmpty()) {
                    throw new ErrorMessageException("_ error.wrong.fql.nofichequery");
                }
                for (FicheQuery fq : fichothequeQueries.getFicheQueryList()) {
                    builder.add(fq);
                }
            }
        }
        return builder;
    }

    public MotcleSelectorBuilder populateFromXml(MotcleSelectorBuilder builder) throws ErrorMessageException {
        org.w3c.dom.Document document;
        String xml = this.getMandatoryParameter("xml");
        try {
            document = DOMUtils.parseDocument(xml);
        }
        catch (SAXException sae) {
            throw BdfErrors.error("_ error.exception.xml.sax", sae.getMessage());
        }
        Element root = document.getDocumentElement();
        switch (root.getTagName()) {
            case "motcle-query": 
            case "motcle-select": {
                MotcleQuery motcleQuery = SelectionDOMUtils.getMotcleConditionEntry(this.bdfServer.getFichotheque(), root).getMotcleQuery();
                builder.add(motcleQuery);
                break;
            }
            default: {
                FichothequeQueriesBuilder fichothequeQueriesBuilder = new FichothequeQueriesBuilder();
                DOMUtils.readChildren(root, SelectionDOMUtils.getQueryElementConsumer(this.bdfServer.getFichotheque(), fichothequeQueriesBuilder));
                FichothequeQueries fichothequeQueries = fichothequeQueriesBuilder.toFichothequeQueries();
                if (fichothequeQueries.getMotcleQueryList().isEmpty()) {
                    throw BdfErrors.unsupportedParameterValue("xml", "Missing fiche-query elements");
                }
                for (MotcleQuery mq : fichothequeQueries.getMotcleQueryList()) {
                    builder.add(mq);
                }
            }
        }
        return builder;
    }
}

