/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.importation.engines;

import java.text.ParseException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import net.fichotheque.ExistingIdException;
import net.fichotheque.Fichotheque;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.croisement.CroisementEditor;
import net.fichotheque.importation.LiensImport;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.fichotheque.tools.croisement.CroisementChangeEngine;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.text.Label;

final class LiensImportEngine {
    private LiensImportEngine() {
    }

    static void run(CroisementEditor croisementEditor, SubsetItem mainSubsetItem, LiensImport liensImport, PermissionSummary permissionSummary) {
        List<LiensImport.LienImport> appendList;
        Predicate<Subset> subsetAccessPredicate = permissionSummary.getSubsetAccessPredicate();
        FichothequeEditor fichothequeEditor = croisementEditor.getFichothequeEditor();
        Fichotheque fichotheque = fichothequeEditor.getFichotheque();
        boolean withLiage = liensImport.isLiageRemoved();
        List<IncludeKey> removedIncludeKeyList = liensImport.getRemovedIncludeKeyList();
        List<LiensImport.LienImport> replaceList = liensImport.getReplaceLienImportList();
        if (!removedIncludeKeyList.isEmpty() || !replaceList.isEmpty() || withLiage) {
            LinkedHashSet<IncludeKey> clearExisting = new LinkedHashSet<IncludeKey>();
            clearExisting.addAll(removedIncludeKeyList);
            for (LiensImport.LienImport lienImport : replaceList) {
                if (!subsetAccessPredicate.test(lienImport.getOtherSubset())) continue;
                if (lienImport.isLiageOrigin()) {
                    withLiage = true;
                    continue;
                }
                clearExisting.add(lienImport.getOriginIncludeKey());
            }
            if (withLiage) {
                for (Corpus corpus : fichotheque.getCorpusList()) {
                    if (!subsetAccessPredicate.test(corpus)) continue;
                    clearExisting.add(IncludeKey.newInstance(corpus.getSubsetKey()));
                }
            }
            CroisementChangeEngine replaceEngine = CroisementChangeEngine.clearExistingEngine(mainSubsetItem, clearExisting);
            for (LiensImport.LienImport lienImport : replaceList) {
                if (!subsetAccessPredicate.test(lienImport.getOtherSubset())) continue;
                LiensImportEngine.addLien(replaceEngine, lienImport, fichothequeEditor);
            }
            croisementEditor.updateCroisements(mainSubsetItem, replaceEngine.toCroisementChanges());
        }
        if (!(appendList = liensImport.getAppendLienImportList()).isEmpty()) {
            CroisementChangeEngine appendEngine = CroisementChangeEngine.appendEngine(mainSubsetItem);
            for (LiensImport.LienImport lienImport : appendList) {
                if (!subsetAccessPredicate.test(lienImport.getOtherSubset())) continue;
                LiensImportEngine.addLien(appendEngine, lienImport, fichothequeEditor);
            }
            croisementEditor.updateCroisements(mainSubsetItem, appendEngine.toCroisementChanges());
        }
    }

    private static void addLien(CroisementChangeEngine engine, LiensImport.LienImport lienImport, FichothequeEditor fichothequeEditor) {
        Subset otherSubset = lienImport.getOtherSubset();
        LiensImport.Other other = lienImport.getOther();
        if (other instanceof LiensImport.IdOther) {
            SubsetItem otherSubsetItem = otherSubset.getSubsetItemById(((LiensImport.IdOther)other).getOtherId());
            if (otherSubsetItem != null) {
                engine.addLien(otherSubsetItem, lienImport.getMode(), lienImport.getWeight());
            }
        } else {
            if (!(otherSubset instanceof Thesaurus)) {
                return;
            }
            Thesaurus thesaurus = (Thesaurus)otherSubset;
            Motcle motcle = null;
            if (other instanceof LiensImport.LabelOther) {
                Label label = ((LiensImport.LabelOther)other).getLabel();
                motcle = thesaurus.seekMotcleByLabel(label.getLabelString(), label.getLang());
                if (motcle == null) {
                    if (thesaurus.isIdalphaType()) {
                        return;
                    }
                    ThesaurusEditor thsedit = fichothequeEditor.getThesaurusEditor(thesaurus);
                    try {
                        motcle = thsedit.createMotcle(-1, null);
                        thsedit.putLabel(motcle, label);
                    }
                    catch (ParseException | ExistingIdException e) {
                        throw new ShouldNotOccurException(e);
                    }
                }
            } else if (other instanceof LiensImport.IdalphaOther) {
                String idalpha = ((LiensImport.IdalphaOther)other).getIdalpha();
                motcle = thesaurus.getMotcleByIdalpha(idalpha);
            }
            if (motcle != null) {
                engine.addLien(motcle, lienImport.getMode(), lienImport.getWeight());
            }
        }
    }
}

