/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.ficheform.builders;

import fr.exemole.bdfserver.api.configuration.LangConfiguration;
import fr.exemole.bdfserver.api.ficheform.FicheFormParameters;
import fr.exemole.bdfserver.api.ficheform.LangFieldElement;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.tools.L10nUtils;
import java.util.LinkedHashSet;
import java.util.Set;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.pointeurs.FichePointeur;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;

public class LangFieldElementBuilder {
    private final CorpusField corpusField;
    private final Set<Lang> langSet = new LinkedHashSet<Lang>();
    private String label = "";
    private boolean mandatory = false;
    private Lang lang;
    private Attributes attributes = AttributeUtils.EMPTY_ATTRIBUTES;

    public LangFieldElementBuilder(CorpusField corpusField) {
        this.corpusField = corpusField;
    }

    public LangFieldElementBuilder setLabel(String label) {
        if (label == null) {
            throw new IllegalArgumentException("label is null");
        }
        this.label = label;
        return this;
    }

    public LangFieldElementBuilder setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
        return this;
    }

    public LangFieldElementBuilder setAttributes(Attributes attributes) {
        this.attributes = attributes == null ? AttributeUtils.EMPTY_ATTRIBUTES : attributes;
        return this;
    }

    public LangFieldElementBuilder setLang(Lang lang) {
        this.lang = lang;
        return this;
    }

    public LangFieldElementBuilder addAvailableLang(Lang lang) {
        if (lang == null) {
            throw new IllegalArgumentException("lang is null");
        }
        this.langSet.add(lang);
        return this;
    }

    public LangFieldElement toLangFieldElement() {
        Lang[] availableLangArray = null;
        int size = this.langSet.size();
        if (size > 0) {
            availableLangArray = this.langSet.toArray(new Lang[size]);
        }
        return new InternalLangFieldElement(this.corpusField, this.label, this.mandatory, this.attributes, this.lang, availableLangArray);
    }

    private void initAllLang(FichePointeur fichePointeur, FicheFormParameters ficheFormParameters) {
        if (fichePointeur.isEmpty()) {
            this.setLang(ficheFormParameters.getWorkingLang());
        } else {
            this.setLang(((FicheMeta)fichePointeur.getCurrentSubsetItem()).getLang());
        }
    }

    private void initLangConfiguration(FichePointeur fichePointeur, FicheFormParameters ficheFormParameters, LangConfiguration langConfiguration) {
        Lang workingLang = ficheFormParameters.getWorkingLang();
        Langs workingLangs = langConfiguration.getWorkingLangs();
        Langs supplementaryLangs = langConfiguration.getSupplementaryLangs();
        boolean here = false;
        for (Lang currentLang : workingLangs) {
            if (workingLang.equals(currentLang)) {
                here = true;
            }
            this.addAvailableLang(currentLang);
        }
        for (Lang currentLang : supplementaryLangs) {
            if (workingLang.equals(currentLang)) {
                here = true;
            }
            this.addAvailableLang(currentLang);
        }
        if (fichePointeur.isEmpty()) {
            if (here) {
                this.setLang(workingLang);
            } else {
                this.setLang((Lang)workingLangs.get(0));
            }
        } else {
            this.setLang(((FicheMeta)fichePointeur.getCurrentSubsetItem()).getLang());
        }
    }

    private void initLangs(FichePointeur fichePointeur, FicheFormParameters ficheFormParameters, Langs langs) {
        Lang workingLang = ficheFormParameters.getWorkingLang();
        boolean here = false;
        for (Lang currentLang : langs) {
            if (workingLang.equals(currentLang)) {
                here = true;
            }
            this.addAvailableLang(currentLang);
        }
        if (fichePointeur.isEmpty()) {
            if (here) {
                this.setLang(workingLang);
            } else {
                this.setLang((Lang)langs.get(0));
            }
        } else {
            this.setLang(((FicheMeta)fichePointeur.getCurrentSubsetItem()).getLang());
        }
    }

    public static LangFieldElementBuilder build(FichePointeur fichePointeur, FicheFormParameters ficheFormParameters, CorpusField corpusField, FieldUi fieldUi) {
        LangFieldElementBuilder builder = new LangFieldElementBuilder(corpusField);
        switch (corpusField.getLangScope()) {
            case "all": {
                builder.initAllLang(fichePointeur, ficheFormParameters);
                break;
            }
            case "config": {
                LangConfiguration langConfiguration = ficheFormParameters.getBdfServer().getLangConfiguration();
                if (langConfiguration.isAllLanguages()) {
                    builder.initAllLang(fichePointeur, ficheFormParameters);
                    break;
                }
                builder.initLangConfiguration(fichePointeur, ficheFormParameters, langConfiguration);
                break;
            }
            case "list": {
                builder.initLangs(fichePointeur, ficheFormParameters, corpusField.getLangs());
                break;
            }
            default: {
                throw new SwitchException("Unknown langScope: " + corpusField.getLangScope());
            }
        }
        return builder.setAttributes(fieldUi.getAttributes()).setLabel(L10nUtils.toLabelString(ficheFormParameters, corpusField));
    }

    public static LangFieldElementBuilder init(CorpusField corpusField) {
        return new LangFieldElementBuilder(corpusField);
    }

    private static class InternalLangFieldElement
    implements LangFieldElement {
        private final CorpusField corpusField;
        private final String label;
        private final boolean mandatory;
        private final Attributes attributes;
        private final Lang lang;
        private final Lang[] availableLangArray;

        private InternalLangFieldElement(CorpusField corpusField, String label, boolean mandatory, Attributes attributes, Lang lang, Lang[] availableLangArray) {
            this.corpusField = corpusField;
            this.label = label;
            this.mandatory = mandatory;
            this.attributes = attributes;
            this.lang = lang;
            this.availableLangArray = availableLangArray;
        }

        @Override
        public CorpusField getCorpusField() {
            return this.corpusField;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public boolean isMandatory() {
            return this.mandatory;
        }

        @Override
        public Attributes getAttributes() {
            return this.attributes;
        }

        @Override
        public Lang getLang() {
            return this.lang;
        }

        @Override
        public Lang[] getAvailableLangArray() {
            return this.availableLangArray;
        }
    }
}

