/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.balayage.engine.runners;

import fr.exemole.bdfserver.tools.balayage.BdfBalayageUtils;
import fr.exemole.bdfserver.tools.balayage.engine.BalayageLog;
import fr.exemole.bdfserver.tools.balayage.engine.BalayageParameters;
import fr.exemole.bdfserver.tools.balayage.engine.runners.AbstractBalayageUnitRunner;
import fr.exemole.bdfserver.tools.configuration.ConfigurationUtils;
import java.io.File;
import java.util.function.Predicate;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.exportation.balayage.BalayageOutput;
import net.fichotheque.exportation.balayage.BalayageUnit;
import net.fichotheque.selection.DocumentQuery;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.selection.FicheSelector;
import net.fichotheque.selection.SelectionContext;
import net.fichotheque.tools.corpus.FichesBuilder;
import net.fichotheque.tools.exportation.file.FileExportEngine;
import net.fichotheque.utils.SelectionUtils;
import net.fichotheque.utils.selection.FicheSelectorBuilder;
import net.fichotheque.utils.selection.SelectionContextBuilder;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.AccoladePattern;

public class DocumentBalayageUnitRunner
extends AbstractBalayageUnitRunner {
    private final Predicate<String> extensionPredicate;
    private final boolean empty;
    private FileExportMessageHandler messageHandler;
    private File destinationDir;

    public DocumentBalayageUnitRunner(BalayageParameters balayageParameters, int balayageIndex, BalayageUnit balayageUnit) {
        super(balayageParameters, balayageIndex, balayageUnit);
        this.extensionPredicate = BdfBalayageUtils.getExtensionPredicate(balayageUnit);
        this.empty = balayageUnit.getOutputList().isEmpty();
        if (!this.empty) {
            BalayageOutput output = balayageUnit.getOutputList().get(0);
            this.messageHandler = new FileExportMessageHandler(balayageIndex, balayageParameters.getBalayageLog(), output);
            File rootDirectory = output.isIncludeOutput() ? ConfigurationUtils.getBalayageIncludeDirectory(balayageParameters.getBdfServer()) : balayageParameters.getBalayageRootDirectory();
            this.destinationDir = rootDirectory;
            AccoladePattern pattern = output.getOutputPath();
            if (pattern != null) {
                this.destinationDir = new File(rootDirectory, pattern.toString());
            }
        }
    }

    @Override
    protected void run(String balayageUnitType) {
        if (this.empty) {
            return;
        }
        DocumentQuery documentQuery = this.balayageUnit.getDocumentQuery();
        Addenda[] addendaArray = SelectionUtils.toAddendaArray(this.extractionContext.getFichotheque(), documentQuery, this.extractionContext.getSubsetAccessPredicate());
        Fiches fichePredicate = this.balayageParameters.getSelectedFiches();
        FicheQuery ficheQuery = this.balayageUnit.getFicheQuery();
        boolean globalSelect = this.balayageUnit.isGlobalSelect();
        if ((!globalSelect || fichePredicate == null) && ficheQuery.isEmpty()) {
            FileExportEngine.run(this.destinationDir, addendaArray, this.extensionPredicate, this.messageHandler);
        } else {
            if (!globalSelect) {
                fichePredicate = null;
            }
            SelectionContext selectionContext = SelectionContextBuilder.build(this.extractionContext, this.defaultWorkingLang).setSubsetAccessPredicate(this.extractionContext.getSubsetAccessPredicate()).setFichePredicate(fichePredicate).toSelectionContext();
            FicheSelector ficheSelector = FicheSelectorBuilder.init(selectionContext).add(ficheQuery).toFicheSelector();
            Fiches fiches = FichesBuilder.build("id-asc").populate(ficheSelector).toFiches();
            FileExportEngine.run(this.destinationDir, addendaArray, this.extensionPredicate, this.messageHandler, fiches);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    protected boolean isEmpty() {
        return this.empty;
    }

    private static class FileExportMessageHandler
    implements MessageHandler {
        private final BalayageLog balayageLog;
        private final int balayageIndex;
        private final BalayageOutput output;

        private FileExportMessageHandler(int balayageIndex, BalayageLog balayageLog, BalayageOutput output) {
            this.balayageIndex = balayageIndex;
            this.balayageLog = balayageLog;
            this.output = output;
        }

        @Override
        public void addMessage(String category, Message message) {
            if (category.startsWith("severe")) {
                this.balayageLog.addOutputError(this.balayageIndex, 0, this.output, "ioException", message.getMessageKey(), "");
            } else if (message.getMessageKey().equals("_ info.file")) {
                this.balayageLog.addFileGeneration(this.balayageIndex, 0, (File)message.getMessageValues()[0]);
            }
        }
    }
}

