/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.bdfdata;

import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.conf.BdfServerDirs;
import fr.exemole.bdfserver.storage.directory.bdfdata.BdfdataDirectory;
import fr.exemole.bdfserver.storage.directory.bdfdata.StartValues;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import net.mapeadores.util.exceptions.InternalResourceException;
import net.mapeadores.util.io.FileUtils;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.security.PasswordChecker;

public class StartEngine {
    private static final FileInfo[] FILES = new FileInfo[2];
    private static final FileInfo[] FILES_SPHERE = new FileInfo[3];
    private final BdfServerDirs dirs;
    private final StartValues startValues;
    private final File bdfdataDir;

    private StartEngine(BdfServerDirs dirs, StartValues startValues, File bdfdataDir) {
        this.dirs = dirs;
        this.startValues = startValues;
        this.bdfdataDir = bdfdataDir;
    }

    private void start() {
        for (FileInfo fileInfo : FILES) {
            this.writeStartFile(fileInfo);
        }
    }

    public StartEngine addFirstSphere() {
        for (FileInfo fileInfo : FILES_SPHERE) {
            this.writeStartFile(fileInfo);
        }
        this.writePassword();
        return this;
    }

    public StartEngine addCentralSpheres() {
        for (String sphereName : this.startValues.centralSpheres()) {
            this.writeStartFile(new FileInfo("sphere-metadata.xml", "fichotheque", "sphere", sphereName + ".xml"));
        }
        return this;
    }

    private void writeStartFile(FileInfo fileInfo) {
        File destFile;
        String fileContent;
        try (InputStream is = BdfdataDirectory.class.getResourceAsStream("defaultfiles/" + fileInfo.getOriginName());){
            fileContent = IOUtils.toString(is, "UTF-8");
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
        try {
            fileContent = this.startValues.replaceInText(fileContent);
            File destDir = new File(this.bdfdataDir, fileInfo.getRoot());
            String path = fileInfo.getPath();
            if (path.length() > 0) {
                path = this.startValues.replaceInText(path);
                destDir = new File(destDir, path);
            }
            destDir.mkdirs();
            destFile = new File(destDir, this.startValues.replaceInText(fileInfo.getDestinationName()));
        }
        catch (ParseException pe) {
            throw new InternalResourceException(pe);
        }
        try {
            FileUtils.writeStringToFile(destFile, fileContent, "UTF-8");
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
    }

    private void writePassword() {
        File confDir = new File(this.bdfdataDir, "conf");
        File passwdFile = new File(confDir, "passwd");
        try (BufferedWriter buf = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(passwdFile), "UTF-8"));){
            buf.append(this.startValues.spherename());
            buf.append("/1:");
            buf.append(PasswordChecker.getHash("pbkdf2", this.startValues.firstpassword()));
            buf.append('\n');
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
    }

    public static StartEngine start(BdfServerDirs dirs, StartValues startValues) {
        File bdfdataDir = dirs.getSubPath("var.data", "bdfdata");
        bdfdataDir.mkdirs();
        StartEngine startEngine = new StartEngine(dirs, startValues, bdfdataDir);
        startEngine.start();
        return startEngine;
    }

    static {
        StartEngine.FILES[0] = new FileInfo("fichotheque-metadata.xml", "fichotheque", "", "metadata.xml");
        StartEngine.FILES[1] = new FileInfo("lang-configuration.xml", "conf", "", "lang-configuration.xml");
        StartEngine.FILES_SPHERE[0] = new FileInfo("admin.xml", "conf", "redacteurlists", "admin.xml");
        StartEngine.FILES_SPHERE[1] = new FileInfo("sphere-metadata.xml", "fichotheque", "sphere", "{spherename}.xml");
        StartEngine.FILES_SPHERE[2] = new FileInfo("sphere-list.xml", "fichotheque", "sphere/{spherename}", "list.xml");
    }

    private static class FileInfo {
        private final String name;
        private final String root;
        private final String path;
        private final String destinationName;

        private FileInfo(String name, String root, String path, String destinationName) {
            this.name = name;
            this.root = root;
            this.path = path;
            this.destinationName = destinationName;
        }

        private String getOriginName() {
            return this.name;
        }

        private String getRoot() {
            return this.root;
        }

        private String getPath() {
            return this.path;
        }

        private String getDestinationName() {
            return this.destinationName;
        }
    }
}

