/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.bdfdata;

import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.storage.directory.StorageDirectory;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.SubsetKey;
import net.fichotheque.utils.AlbumUtils;
import net.mapeadores.util.io.FileUtils;
import net.mapeadores.util.io.IOUtils;

public class IllustrationDirectory {
    private final File dir;

    private IllustrationDirectory(File dir) {
        this.dir = dir;
    }

    public InputStream getImage() {
        File f = this.getImageFile();
        if (!f.exists()) {
            return null;
        }
        try {
            return new FileInputStream(f);
        }
        catch (IOException ioe) {
            throw new BdfStorageException("file : " + f.getAbsolutePath(), (Throwable)ioe);
        }
    }

    public void updateImage(InputStream inputStream, short imageType) {
        File f2;
        if (!this.dir.isDirectory()) {
            this.dir.delete();
        }
        this.dir.mkdirs();
        String extension = AlbumUtils.formatTypeToString(imageType);
        for (File f2 : this.dir.listFiles()) {
            String name = f2.getName();
            if (!name.startsWith("img.")) continue;
            f2.delete();
        }
        String fileName = "img." + extension;
        f2 = new File(this.dir, fileName);
        try (FileOutputStream os = new FileOutputStream(f2);){
            IOUtils.copy(inputStream, (OutputStream)os);
        }
        catch (IOException ioe) {
            throw new BdfStorageException("file : " + f2.getAbsolutePath(), (Throwable)ioe);
        }
    }

    public boolean delete() {
        try {
            if (this.dir.exists()) {
                FileUtils.forceDelete(this.dir);
                return true;
            }
            return false;
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
    }

    private File getImageFile() {
        File f = new File(this.dir, "img.png");
        if (!f.exists()) {
            f = new File(this.dir, "img.jpg");
        }
        return f;
    }

    public static IllustrationDirectory getIllustrationDirectory(StorageDirectory bdfdataDirectory, SubsetKey subsetKey, int id) {
        File illustrationDir = bdfdataDirectory.getDataFile(IllustrationDirectory.getPath(subsetKey, id));
        return new IllustrationDirectory(illustrationDir);
    }

    public static String getPath(SubsetKey subsetKey, int id) {
        if (!subsetKey.isAlbumSubset()) {
            throw new IllegalArgumentException("!subsetKey.isAlbumSubset()");
        }
        if (id < 0) {
            throw new IllegalArgumentException("id < 0");
        }
        StringBuilder buf = new StringBuilder();
        buf.append("fichotheque");
        buf.append(File.separatorChar);
        buf.append("album");
        buf.append(File.separatorChar);
        buf.append(subsetKey.getSubsetName());
        buf.append(File.separatorChar);
        buf.append("i.");
        buf.append(BdfServerUtils.getMillier(id));
        buf.append(File.separatorChar);
        buf.append(id);
        return buf.toString();
    }

    public static List<IllustrationInfo> getIllustrationInfoList(StorageDirectory bdfdataDirectory, SubsetKey albumKey) {
        ArrayList<IllustrationInfo> list = new ArrayList<IllustrationInfo>();
        File imageDirectory = bdfdataDirectory.getDataFile("fichotheque" + File.separator + "album" + File.separator + albumKey.getSubsetName());
        if (!imageDirectory.exists() || !imageDirectory.isDirectory()) {
            return list;
        }
        for (File imgDir : imageDirectory.listFiles()) {
            String name;
            if (!imgDir.isDirectory() || (name = imgDir.getName()).length() < 2 || !name.startsWith("i.")) continue;
            try {
                int directoryNumber = Integer.parseInt(name.substring(2));
                IllustrationDirectory.addIllustrationInfo(list, imgDir, directoryNumber);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return list;
    }

    private static void addIllustrationInfo(List<IllustrationInfo> list, File intervalDirectory, int directoryNumber) {
        for (File directory : intervalDirectory.listFiles()) {
            if (!directory.isDirectory()) continue;
            String name = directory.getName();
            String errorMessage = null;
            try {
                int illustrationid = Integer.parseInt(name);
                if (illustrationid < 1) {
                    errorMessage = "illustrationid < 1 (directoryNumber = " + directoryNumber;
                } else if (illustrationid < 1000 && directoryNumber != 0 || illustrationid / 1000 != directoryNumber) {
                    errorMessage = "Wrong range : illustrationid = " + illustrationid + " / directoryNumber = " + directoryNumber;
                } else {
                    IllustrationInfo illustrationInfo = IllustrationDirectory.getIllustrationInfo(directory, illustrationid);
                    if (illustrationInfo != null) {
                        list.add(illustrationInfo);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (errorMessage == null) continue;
            System.out.println(errorMessage);
        }
    }

    private static IllustrationInfo getIllustrationInfo(File imageDir, int id) {
        short type;
        File imgFile = new File(imageDir, "img.png");
        if (imgFile.exists()) {
            type = 2;
        } else {
            imgFile = new File(imageDir, "img.jpg");
            if (imgFile.exists()) {
                type = 1;
            } else {
                return null;
            }
        }
        IllustrationInfo illustrationInfo = new IllustrationInfo(type, id, imgFile);
        return illustrationInfo;
    }

    public static class IllustrationInfo {
        private final short type;
        private final int id;
        private final File file;

        private IllustrationInfo(short type, int id, File file) {
            this.type = type;
            this.id = id;
            this.file = file;
        }

        public short getType() {
            return this.type;
        }

        public String getName() {
            return null;
        }

        public int getId() {
            return this.id;
        }

        public File getFile() {
            return this.file;
        }
    }
}

