/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.servlets;

import fr.exemole.bdfserver.api.BdfExtensionInitializer;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.session.LoginException;
import fr.exemole.bdfserver.api.session.SessionObserver;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.conf.WebappDirs;
import fr.exemole.bdfserver.email.SmtpManager;
import fr.exemole.bdfserver.impl.BdfServerImpl;
import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.api.central.CentralSphere;
import fr.exemole.bdfserver.multi.api.central.CentralUser;
import fr.exemole.bdfserver.multi.subscribe.SubscribeManager;
import fr.exemole.bdfserver.multi.subscribe.SubscribeUtils;
import fr.exemole.bdfserver.servlets.BDFInit;
import fr.exemole.bdfserver.servlets.BDFInitParameters;
import fr.exemole.bdfserver.servlets.BDFInitParametersEngine;
import fr.exemole.bdfserver.servlets.BDFSession;
import fr.exemole.bdfserver.servlets.BDFUtils;
import fr.exemole.bdfserver.servlets.MultiImpl;
import fr.exemole.bdfserver.servlets.SubscribeManagerImpl;
import fr.exemole.bdfserver.tools.storage.Storages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import net.fichotheque.Fichotheque;
import net.fichotheque.sphere.LoginKey;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.mapeadores.util.buildinfo.BuildInfo;
import net.mapeadores.util.io.ResourceStorages;
import net.mapeadores.util.mimetype.MimeTypeResolver;
import net.mapeadores.util.mimetype.MimeTypeUtils;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.security.PasswordChecker;
import net.mapeadores.util.servlets.HttpServletRequestMap;
import net.mapeadores.util.servlets.ServletUtils;
import net.mapeadores.util.smtp.SmtpParameters;

public class BDFWebapp {
    public static final String BDFWEBAPP_KEY = "fr.exemole.BDFWebapp";
    public static final String BDFSESSION_KEY = "fr.exemole.BDFSession";
    public static final String BDFBINDING_KEY = "fr.exemole.BDFBinding";
    private final WebappDirs webappDirs;
    private final boolean loginPasswordDisabled;
    private final SmtpManager smtpManager;
    private final Map<String, BDFSession> sessionsMap = new LinkedHashMap<String, BDFSession>();
    private final BDFBinding bdfBinding = new BDFBinding();
    private final int maxInactiveInterval = 18000;
    private final MultiImpl multiImpl;
    private final Unique unique;
    private final SubscribeManager subscribeManager;

    private BDFWebapp(String servletContextName, BDFInitParameters initParameters) {
        this.webappDirs = initParameters.webappDirs();
        this.loginPasswordDisabled = initParameters.loginPasswordDisabled();
        this.smtpManager = initParameters.smtpManager();
        if (initParameters.multiBdf()) {
            this.multiImpl = new MultiImpl(this, servletContextName, initParameters);
            this.unique = null;
        } else {
            this.multiImpl = null;
            this.unique = new Unique(this.webappDirs);
        }
        this.subscribeManager = BDFWebapp.initSubscribeManager(initParameters);
    }

    public boolean isMultiBdf() {
        return this.multiImpl != null;
    }

    public Multi getMulti() {
        return this.multiImpl;
    }

    public Unique getUnique() {
        return this.unique;
    }

    public boolean isLoginPasswordDisabled() {
        return this.loginPasswordDisabled;
    }

    public WebappDirs getWebappDirs() {
        return this.webappDirs;
    }

    public SmtpManager getSmtpManager() {
        return this.smtpManager;
    }

    public SubscribeManager getSubscribeManager() {
        return this.subscribeManager;
    }

    public short checkMultiAdmin(HttpServletRequestMap requestMap) {
        BDFSession bdfSession = this.getCurrentBDFSession(requestMap);
        if (bdfSession != null && bdfSession.isMultiAdmin()) {
            return 1;
        }
        short check = this.multiImpl.getMultiConf().checkAuthentification(requestMap, this.loginPasswordDisabled);
        if (check == 1) {
            if (bdfSession == null) {
                bdfSession = this.createBDFSession(requestMap);
            }
            bdfSession.setMultiAdmin(true);
        }
        return check;
    }

    public synchronized void invalidateBdfUser(HttpServletRequestMap requestMap, String fichothequeName) {
        BDFSession bdfSession = this.getCurrentBDFSession(requestMap);
        if (bdfSession == null) {
            return;
        }
        BdfUser bdfUser = bdfSession.getBdfUser(fichothequeName);
        if (bdfUser == null) {
            return;
        }
        LoginKey loginKey = bdfUser.getLoginKey();
        if (this.multiImpl != null && this.multiImpl.isAuthentificationSharingAllowed(loginKey)) {
            bdfSession.logoutAll(loginKey);
        } else {
            bdfSession.logout(fichothequeName);
        }
        this.checkSession(bdfSession);
    }

    public synchronized void invalidateCentralUser(HttpServletRequestMap requestMap) {
        BDFSession bdfSession = this.getCurrentBDFSession(requestMap);
        if (bdfSession == null) {
            return;
        }
        CentralUser centralUser = bdfSession.getCentralUser();
        if (centralUser == null) {
            return;
        }
        bdfSession.logoutAll(centralUser.getLoginKey());
        this.checkSession(bdfSession);
    }

    public synchronized CentralUser getOrCreateCentralUser(HttpServletRequestMap requestMap) throws LoginException {
        BDFSession bdfSession = this.getCurrentBDFSession(requestMap);
        if (bdfSession != null) {
            CentralUser centralUser = bdfSession.getCentralUser();
            if (centralUser != null) {
                return centralUser;
            }
            if (!BDFUtils.hasLogin(requestMap) && (centralUser = this.getMatchingCentralUser(requestMap, bdfSession)) != null) {
                return centralUser;
            }
        }
        return this.createCentralUser(requestMap, bdfSession);
    }

    public synchronized BdfUser getOrCreateBdfUser(HttpServletRequestMap requestMap, BdfServer bdfServer) throws LoginException {
        BDFSession bdfSession = this.getCurrentBDFSession(requestMap);
        if (bdfSession != null) {
            BdfUser bdfUser = bdfSession.getBdfUser(bdfServer.getName());
            if (bdfUser != null) {
                bdfUser.putParameter("bdf.session.lastaccessedtime", System.currentTimeMillis());
                return bdfUser;
            }
            if (!BDFUtils.hasLogin(requestMap) && (bdfUser = this.getMatchingBdfUser(bdfServer, requestMap, bdfSession)) != null) {
                return bdfUser;
            }
        }
        return this.createBdfUser(bdfServer, requestMap, bdfSession);
    }

    public BDFSession getMatchingSession(BdfUser bdfUser) {
        String fichothequeName = bdfUser.getBdfServerName();
        for (BDFSession bdfSession : this.sessionsMap.values()) {
            if (!bdfSession.containsBdfUser(fichothequeName, bdfUser)) continue;
            return bdfSession;
        }
        return null;
    }

    public SessionObserver getSessionObserverInstance(String fichothequeName) {
        return new InternalSessionObserver(fichothequeName);
    }

    public static BDFWebapp build(ServletContext servletContext) {
        String servletContextName = ServletUtils.getServletContextName(servletContext);
        BDFInitParameters initParameters = BDFInitParametersEngine.run(servletContext);
        return new BDFWebapp(servletContextName, initParameters);
    }

    private CentralUser getMatchingCentralUser(HttpServletRequestMap requestMap, BDFSession bdfSession) {
        if (this.multiImpl == null) {
            return null;
        }
        for (LoginKey loginKey : bdfSession.getLoginKeySet()) {
            CentralUser centralUser;
            CentralSphere centralSphere;
            if (!this.multiImpl.isAuthentificationSharingAllowed(loginKey) || (centralSphere = this.multiImpl.getCentralSphere(loginKey.getSphereName())) == null || (centralUser = centralSphere.getCentralUser(loginKey.getLogin())) == null) continue;
            return centralUser;
        }
        return null;
    }

    private BdfUser getMatchingBdfUser(BdfServer bdfServer, HttpServletRequestMap requestMap, BDFSession bdfSession) {
        if (this.multiImpl == null) {
            return null;
        }
        Fichotheque fichotheque = bdfServer.getFichotheque();
        for (LoginKey loginKey : bdfSession.getLoginKeySet()) {
            Redacteur existingRedacteur;
            Sphere sphere;
            if (!this.multiImpl.isAuthentificationSharingAllowed(loginKey) || (sphere = (Sphere)fichotheque.getSubset(loginKey.getSphereKey())) == null || (existingRedacteur = sphere.getRedacteurByLogin(loginKey.getLogin())) == null || existingRedacteur.isInactive()) continue;
            return this.createBdfUser(bdfServer, requestMap, bdfSession, existingRedacteur);
        }
        return null;
    }

    private BdfUser createBdfUser(BdfServer bdfServer, HttpServletRequestMap requestMap, BDFSession bdfSession) throws LoginException {
        Redacteur redacteur = BDFUtils.getRedacteur(bdfServer, requestMap);
        if (redacteur.isInactive()) {
            throw new LoginException(LoginException.INACTIVE_ERROR);
        }
        if (!this.loginPasswordDisabled) {
            String bdfPassword = requestMap.getParameter("bdf-password");
            if (bdfPassword == null) {
                throw new LoginException(LoginException.UNDEFINED_ERROR);
            }
            if (!bdfServer.getPasswordManager().checkPassword(redacteur.getGlobalId(), bdfPassword)) {
                throw new LoginException(LoginException.PASSWORD_ERROR);
            }
        }
        if (bdfSession == null) {
            bdfSession = this.createBDFSession(requestMap);
        }
        return this.createBdfUser(bdfServer, requestMap, bdfSession, redacteur);
    }

    private BdfUser createBdfUser(BdfServer bdfServer, HttpServletRequestMap requestMap, BDFSession bdfSession, Redacteur redacteur) {
        BdfUser bdfUser = bdfServer.createBdfUser(redacteur);
        bdfSession.login(bdfServer.getName(), bdfUser);
        bdfServer.getSelectionManager().updateFicheSelection(bdfUser);
        long currentTime = System.currentTimeMillis();
        boolean withJavascript = true;
        if (requestMap.isTrue("bdf-noscript")) {
            withJavascript = false;
        }
        bdfUser.putParameter("bdf.session.creationtime", currentTime);
        bdfUser.putParameter("bdf.session.lastaccessedtime", currentTime);
        bdfUser.putParameter("bdf.html.withjavascript", withJavascript);
        bdfUser.putParameter("bdf.session.rooturl", BDFUtils.getRootUrl(requestMap.getRequest(), bdfServer.getName()));
        return bdfUser;
    }

    private CentralUser createCentralUser(HttpServletRequestMap requestMap, BDFSession bdfSession) throws LoginException {
        CentralUser centralUser = BDFUtils.getCentralUser(requestMap, this.multiImpl);
        if (!this.loginPasswordDisabled) {
            String bdfPassword = requestMap.getParameter("bdf-password");
            if (bdfPassword == null) {
                throw new LoginException(LoginException.UNDEFINED_ERROR);
            }
            String encryptedPassword = centralUser.getEncryptedPassword();
            if (encryptedPassword.isEmpty()) {
                throw new LoginException(LoginException.PASSWORD_ERROR);
            }
            if (!PasswordChecker.check(bdfPassword, encryptedPassword)) {
                throw new LoginException(LoginException.PASSWORD_ERROR);
            }
        }
        if (bdfSession == null) {
            bdfSession = this.createBDFSession(requestMap);
        }
        bdfSession.centralLogin(centralUser);
        return centralUser;
    }

    public BDFSession getCurrentBDFSession(HttpServletRequestMap requestMap) {
        HttpSession session = requestMap.getRequest().getSession(false);
        if (session != null) {
            return (BDFSession)session.getAttribute(BDFSESSION_KEY);
        }
        return null;
    }

    private BDFSession createBDFSession(HttpServletRequestMap requestMap) {
        HttpSession httpSession = requestMap.getRequest().getSession();
        httpSession.setMaxInactiveInterval(18000);
        BDFSession bdfSession = new BDFSession(httpSession);
        httpSession.setAttribute(BDFSESSION_KEY, (Object)bdfSession);
        this.sessionsMap.put(httpSession.getId(), bdfSession);
        httpSession.setAttribute(BDFBINDING_KEY, (Object)this.bdfBinding);
        return bdfSession;
    }

    private void checkSession(BDFSession bdfSession) {
        if (bdfSession.isEmpty()) {
            HttpSession httpSession = bdfSession.getHttpSession();
            this.sessionsMap.remove(httpSession.getId());
            httpSession.removeAttribute(BDFSESSION_KEY);
            httpSession.removeAttribute(BDFBINDING_KEY);
            httpSession.invalidate();
        }
    }

    private static SubscribeManager initSubscribeManager(BDFInitParameters initParameters) {
        SmtpParameters smtpParameters;
        EmailCore fromEmail;
        if (initParameters.multiBdf() && initParameters.authentificationSharing().equals("none") && initParameters.smtpManager().isInit() && initParameters.subscribeAllowed() && (fromEmail = (smtpParameters = initParameters.smtpManager().getSmtpParameters()).getEmail("subscribe.from")) != null) {
            return new SubscribeManagerImpl(smtpParameters);
        }
        return SubscribeUtils.INACTIVE_SUBSCRIBEMANAGER;
    }

    private class BDFBinding
    implements HttpSessionBindingListener {
        private BDFBinding() {
        }

        public void valueBound(HttpSessionBindingEvent httpSessionEvent) {
        }

        public void valueUnbound(HttpSessionBindingEvent httpSessionEvent) {
            HttpSession session = httpSessionEvent.getSession();
            BDFWebapp.this.sessionsMap.remove(session.getId());
        }
    }

    public class Unique {
        private final ResourceStorages webappResourceStorages;
        private final BuildInfo buildInfo = BDFInit.buildInfo();
        private final MimeTypeResolver mimeTypeResolver = MimeTypeUtils.DEFAULT_RESOLVER;
        private final List<BdfExtensionInitializer> extensionInitializerList;
        private BdfServer bdfServer = null;

        private Unique(WebappDirs webappDirs) {
            this.extensionInitializerList = BDFInit.extensionInitializerList(webappDirs);
            this.webappResourceStorages = BDFInit.initWebappResourceStorages(webappDirs, this.extensionInitializerList);
        }

        public BdfServer getBdfServer() {
            if (this.bdfServer != null) {
                return this.bdfServer;
            }
            return this.initBdfServer();
        }

        private synchronized BdfServer initBdfServer() {
            if (this.bdfServer != null) {
                return this.bdfServer;
            }
            String name = "_unique";
            HashMap<String, Object> contextObjectMap = new HashMap<String, Object>();
            contextObjectMap.put("smtpManager", BDFWebapp.this.smtpManager);
            contextObjectMap.put("sessionObserver", BDFWebapp.this.getSessionObserverInstance(name));
            contextObjectMap.put("mimeTypeResolver", this.mimeTypeResolver);
            Storages storages = BDFInit.storages(BDFWebapp.this.webappDirs.getBdfServerDirs(name), this.webappResourceStorages);
            this.bdfServer = new BdfServerImpl(name, storages, this.buildInfo, this.extensionInitializerList, contextObjectMap);
            return this.bdfServer;
        }
    }

    private class InternalSessionObserver
    implements SessionObserver {
        private final String fichothequeName;

        private InternalSessionObserver(String fichothequeName) {
            this.fichothequeName = fichothequeName;
        }

        @Override
        public BdfUser[] getCurrentBdfUserArray() {
            ArrayList<BdfUser> bdfUserList = new ArrayList<BdfUser>();
            for (BDFSession bdfSession : BDFWebapp.this.sessionsMap.values()) {
                BdfUser bdfUser = bdfSession.getBdfUser(this.fichothequeName);
                if (bdfUser == null) continue;
                bdfUserList.add(bdfUser);
            }
            return bdfUserList.toArray(new BdfUser[bdfUserList.size()]);
        }
    }
}

