/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.commands.fichotheque;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.commands.AbstractMultiCommand;
import fr.exemole.bdfserver.multi.commands.CreationParameters;
import fr.exemole.bdfserver.multi.commands.fichotheque.CreationSubsetEligibility;
import java.text.ParseException;
import net.fichotheque.SubsetKey;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class FichothequeDuplicationCommand
extends AbstractMultiCommand {
    public static final String COMMAND_NAME = "FichothequeDuplication";
    public static final String NEWFICHOTHEQUE_PARAMNAME = "newfichotheque";
    public static final String SOURCE_PARAMNAME = "source";
    public static final String SUBSETS_PARAMNAME = "subsets";
    public static final String ITEMS_PARAMPREFIX = "items/";

    public FichothequeDuplicationCommand(Multi multi, RequestMap requestMap) {
        super(multi, requestMap);
    }

    @Override
    public CommandMessage doCommand() throws ErrorMessageException {
        String name = this.run();
        return this.done("_ done.multi.fichothequecreation", name);
    }

    private String run() throws ErrorMessageException {
        String name = this.getFichothequeName(NEWFICHOTHEQUE_PARAMNAME);
        if (this.multi.containsFichotheque(name)) {
            throw new ErrorMessageException("_ error.existing.fichotheque", name);
        }
        this.multi.createFichotheque(this.getCreationParameters(name));
        return name;
    }

    private CreationParameters getCreationParameters(String name) throws ErrorMessageException {
        BdfServer sourceBdfServer = this.getSourceBdfServer();
        CreationSubsetEligibility creationSubsetEligibility = this.initCreationSubsetEligibility(sourceBdfServer);
        return CreationParameters.initDuplicate(name, sourceBdfServer, creationSubsetEligibility);
    }

    private BdfServer getSourceBdfServer() throws ErrorMessageException {
        String source = this.getMandatory(SOURCE_PARAMNAME);
        return this.multi.getBdfServer(source);
    }

    private CreationSubsetEligibility initCreationSubsetEligibility(BdfServer sourceBdfServer) {
        CreationSubsetEligibility creationSubsetEligibility = new CreationSubsetEligibility(sourceBdfServer.getFichotheque());
        String[] tokens = this.requestMap.getParameterTokens(SUBSETS_PARAMNAME, true);
        if (tokens == null) {
            return creationSubsetEligibility;
        }
        for (String token : tokens) {
            try {
                SubsetKey subsetKey = SubsetKey.parse(token);
                String itemsPolicy = FichothequeDuplicationCommand.checkItemsPolicy(this.requestMap.getParameter(ITEMS_PARAMPREFIX + subsetKey));
                creationSubsetEligibility.add(subsetKey, itemsPolicy);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return creationSubsetEligibility;
    }

    private static String checkItemsPolicy(String value) {
        if (value == null) {
            return "none";
        }
        switch (value) {
            case "none": 
            case "all": 
            case "selection": {
                return value;
            }
        }
        return "none";
    }
}

