/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.jsonproducers.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.api.storage.StorageContent;
import fr.exemole.bdfserver.json.TransformationJson;
import java.io.IOException;
import java.io.InputStream;
import net.fichotheque.exportation.transformation.TemplateContentDescription;
import net.fichotheque.exportation.transformation.TemplateKey;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProperty;
import net.mapeadores.util.localisation.MessageLocalisation;

public class TemplateContentJsonProperty
implements JsonProperty {
    private final BdfServer bdfServer;
    private final TemplateContentDescription templateContentDescription;
    private final MessageLocalisation messageLocalisation;

    public TemplateContentJsonProperty(BdfServer bdfServer, TemplateContentDescription templateContentDescription, MessageLocalisation messageLocalisation) {
        this.bdfServer = bdfServer;
        this.templateContentDescription = templateContentDescription;
        this.messageLocalisation = messageLocalisation;
    }

    @Override
    public String getName() {
        return "templateContent";
    }

    @Override
    public void writeValue(JSONWriter jw) throws IOException {
        TemplateKey templateKey = this.templateContentDescription.getTemplateKey();
        String contentPath = this.templateContentDescription.getPath();
        String content = this.getTextContent(templateKey, contentPath);
        jw.object();
        jw.key("templateKey").value(templateKey.getKeyString());
        jw.key("path").value(contentPath);
        jw.key("mandatory").value(this.templateContentDescription.isMandatory());
        TransformationJson.stateAndMessagesProperties(jw, this.templateContentDescription, this.messageLocalisation);
        jw.key("content").value(content);
        jw.endObject();
    }

    private String getTextContent(TemplateKey templateKey, String contentPath) {
        StorageContent storageContent = this.bdfServer.getTransformationManager().getTemplateStorageContent(templateKey, contentPath);
        if (storageContent != null) {
            String string;
            block9: {
                InputStream is = storageContent.getInputStream();
                try {
                    string = IOUtils.toString(is, "UTF-8");
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        throw new BdfStorageException(ioe);
                    }
                }
                is.close();
            }
            return string;
        }
        return "";
    }
}

