/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.impl;

import fr.exemole.bdfserver.api.managers.ScrutariExportManager;
import fr.exemole.bdfserver.api.storage.ScrutariExportStorage;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import java.util.SortedMap;
import java.util.TreeMap;
import net.fichotheque.exportation.scrutari.ScrutariExportDef;

class ScrutariExportManagerImpl
implements ScrutariExportManager {
    private static final List<ScrutariExportDef> EMPTY_LIST = Collections.emptyList();
    private final ScrutariExportStorage scrutariExportStorage;
    private final SortedMap<String, ScrutariExportDef> scrutariExportDefMap = new TreeMap<String, ScrutariExportDef>();
    private List<ScrutariExportDef> scrutariExportDefList = EMPTY_LIST;

    ScrutariExportManagerImpl(ScrutariExportStorage scrutariExportStorage) {
        this.scrutariExportStorage = scrutariExportStorage;
    }

    synchronized void check(List<ScrutariExportDef> scrutariExportDefList) {
        this.scrutariExportDefMap.clear();
        for (ScrutariExportDef scrutariExportDef : scrutariExportDefList) {
            this.scrutariExportDefMap.put(scrutariExportDef.getName(), scrutariExportDef);
        }
        this.updateList();
    }

    @Override
    public List<ScrutariExportDef> getScrutariExportDefList() {
        return this.scrutariExportDefList;
    }

    @Override
    public ScrutariExportDef getScrutariExportDef(String name) {
        return (ScrutariExportDef)this.scrutariExportDefMap.get(name);
    }

    @Override
    public synchronized void putScrutariExportDef(ScrutariExportDef scrutariExportDef) {
        String name = scrutariExportDef.getName();
        this.scrutariExportDefMap.put(name, scrutariExportDef);
        this.updateList();
        this.scrutariExportStorage.saveScrutariExportDef(scrutariExportDef);
    }

    @Override
    public synchronized void removeScrutariExportDef(String name) {
        boolean here = this.scrutariExportDefMap.containsKey(name);
        if (!here) {
            return;
        }
        this.scrutariExportDefMap.remove(name);
        this.scrutariExportStorage.removeScrutariExportDef(name);
        this.updateList();
    }

    private void updateList() {
        this.scrutariExportDefList = new ScrutariExportDefList(this.scrutariExportDefMap.values().toArray(new ScrutariExportDef[this.scrutariExportDefMap.size()]));
    }

    private static class ScrutariExportDefList
    extends AbstractList<ScrutariExportDef>
    implements RandomAccess {
        private final ScrutariExportDef[] array;

        private ScrutariExportDefList(ScrutariExportDef[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public ScrutariExportDef get(int index) {
            return this.array[index];
        }
    }
}

