/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.pioche;

import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.pioche.CountryPiocheHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.pioche.DocumentPiocheHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.pioche.ExternalSourceHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.pioche.FichePiocheHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.pioche.FieldPiocheHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.pioche.GeocodageHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.pioche.LanguagePiocheHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.pioche.MotclePiocheHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.pioche.PiocheParameters;
import fr.exemole.bdfserver.htmlproducers.pioche.UserPiocheHtmlProducer;
import fr.exemole.bdfserver.tools.externalsource.ExternalSourceUtils;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.instruction.OutputRequestHandler;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.externalsource.ExternalSource;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.logging.CommandMessageBuilder;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.primitives.DegreDecimal;
import net.mapeadores.util.text.StringUtils;

public final class PiocheHtmlProducerFactory {
    private PiocheHtmlProducerFactory() {
    }

    public static BdfServerHtmlProducer getHtmlProducer(OutputParameters parameters) throws ErrorMessageException {
        String page;
        OutputRequestHandler requestHandler = OutputRequestHandler.init(parameters);
        switch (page = parameters.getOutput()) {
            case "externalsource": {
                return new ExternalSourceHtmlProducer(parameters, PiocheHtmlProducerFactory.getExternalSourceParameters(requestHandler));
            }
            case "document": {
                return new DocumentPiocheHtmlProducer(parameters, PiocheHtmlProducerFactory.getDocumentParameters(requestHandler));
            }
            case "geocodage": {
                return new GeocodageHtmlProducer(parameters, PiocheHtmlProducerFactory.getGeocodageParameters(requestHandler));
            }
            case "fiche": {
                return new FichePiocheHtmlProducer(parameters, PiocheHtmlProducerFactory.getFicheParameters(requestHandler));
            }
            case "motcle": {
                return new MotclePiocheHtmlProducer(parameters, PiocheHtmlProducerFactory.getMotcleParameters(requestHandler));
            }
            case "user": {
                return new UserPiocheHtmlProducer(parameters, PiocheHtmlProducerFactory.getRedacteurParameters(requestHandler));
            }
            case "language": {
                return new LanguagePiocheHtmlProducer(parameters, PiocheHtmlProducerFactory.getParameters(requestHandler));
            }
            case "country": {
                return new CountryPiocheHtmlProducer(parameters, PiocheHtmlProducerFactory.getParameters(requestHandler));
            }
            case "field": {
                return new FieldPiocheHtmlProducer(parameters, PiocheHtmlProducerFactory.getFieldParameters(requestHandler));
            }
        }
        return null;
    }

    private static PiocheParameters getParameters(OutputRequestHandler requestHandler) throws ErrorMessageException {
        String appelant = requestHandler.getMandatoryParameter("appelant");
        int limit = PiocheHtmlProducerFactory.getLimit(requestHandler);
        return PiocheParameters.init().setAppelant(appelant).setLimit(limit);
    }

    private static PiocheParameters getFieldParameters(OutputRequestHandler requestHandler) throws ErrorMessageException {
        String appelant = requestHandler.getMandatoryParameter("appelant");
        int limit = PiocheHtmlProducerFactory.getLimit(requestHandler);
        return PiocheParameters.init().setAppelant(appelant).setLimit(limit).putParameter("fieldtype", requestHandler.getTrimedParameter("fieldtype"));
    }

    private static PiocheParameters getGeocodageParameters(OutputRequestHandler requestHandler) throws ErrorMessageException {
        String appelant = requestHandler.getMandatoryParameter("appelant");
        String latString = requestHandler.getMandatoryParameter("lat").trim();
        String lonString = requestHandler.getMandatoryParameter("lon").trim();
        DegreDecimal latDecimal = null;
        DegreDecimal lonDecimal = null;
        if (latString.length() > 0 && lonString.length() > 0) {
            CommandMessageBuilder commandMessageBuilder = new CommandMessageBuilder();
            try {
                latDecimal = DegreDecimal.newInstance(StringUtils.parseDecimal(latString));
            }
            catch (NumberFormatException nfe) {
                commandMessageBuilder.addMultiError("_ error.wrong.geopoint_lat", latString);
            }
            try {
                lonDecimal = DegreDecimal.newInstance(StringUtils.parseDecimal(lonString));
            }
            catch (NumberFormatException nfe) {
                commandMessageBuilder.addMultiError("_ error.wrong.geopoint_lon", lonString);
            }
            if (commandMessageBuilder.hasMultiError()) {
                throw BdfErrors.error(commandMessageBuilder, "_ error.wrong.geopoint");
            }
        }
        return PiocheParameters.init().setAppelant(appelant).putParameter("lat", latDecimal).putParameter("lon", lonDecimal).putParameter("addressfields", requestHandler.getTrimedParameter("addressfields")).putParameter("zoom", requestHandler.getTrimedParameter("zoom")).putParameter("nocurrent", requestHandler.isTrue("nocurrent"));
    }

    private static PiocheParameters getFicheParameters(OutputRequestHandler requestHandler) throws ErrorMessageException {
        String appelant = requestHandler.getMandatoryParameter("appelant");
        int limit = PiocheHtmlProducerFactory.getLimit(requestHandler);
        return PiocheParameters.init().setAppelant(appelant).setLimit(limit).setSubsetList(PiocheHtmlProducerFactory.getSubsetList(requestHandler, (short)1)).putParameter("buttons", requestHandler.getTrimedParameter("buttons"));
    }

    private static PiocheParameters getMotcleParameters(OutputRequestHandler requestHandler) throws ErrorMessageException {
        String appelant = requestHandler.getMandatoryParameter("appelant");
        int limit = PiocheHtmlProducerFactory.getLimit(requestHandler);
        return PiocheParameters.init().setAppelant(appelant).setLimit(limit).setSubsetList(PiocheHtmlProducerFactory.getSubsetList(requestHandler, (short)2)).putParameter("croisement", PiocheHtmlProducerFactory.getCroisementSubsetKey(requestHandler)).putParameter("wanted", requestHandler.getTrimedParameter("wanted"));
    }

    private static PiocheParameters getDocumentParameters(OutputRequestHandler requestHandler) throws ErrorMessageException {
        String appelant = requestHandler.getMandatoryParameter("appelant");
        int limit = PiocheHtmlProducerFactory.getLimit(requestHandler);
        return PiocheParameters.init().setAppelant(appelant).setLimit(limit).setSubsetList(PiocheHtmlProducerFactory.getSubsetList(requestHandler, (short)4));
    }

    private static PiocheParameters getExternalSourceParameters(OutputRequestHandler requestHandler) throws ErrorMessageException {
        String appelant = requestHandler.getMandatoryParameter("appelant");
        int limit = PiocheHtmlProducerFactory.getLimit(requestHandler);
        List<Subset> thesaurusList = PiocheHtmlProducerFactory.getSubsetList(requestHandler, (short)2);
        if (thesaurusList == null) {
            throw BdfErrors.emptyMandatoryParameter("subsets");
        }
        ExternalSource externalSource = ExternalSourceUtils.getExternalSource(requestHandler.getBdfServer(), (Thesaurus)thesaurusList.get(0));
        if (externalSource == null) {
            throw BdfErrors.wrongParameterValue("subsets", requestHandler.getMandatoryParameter("subsets"));
        }
        return PiocheParameters.init().setAppelant(appelant).setLimit(limit).setSubsetList(thesaurusList).putParameter("externalsource", externalSource).putParameter("croisement", PiocheHtmlProducerFactory.getCroisementSubsetKey(requestHandler));
    }

    private static PiocheParameters getRedacteurParameters(OutputRequestHandler requestHandler) throws ErrorMessageException {
        String appelant = requestHandler.getMandatoryParameter("appelant");
        int limit = PiocheHtmlProducerFactory.getLimit(requestHandler);
        return PiocheParameters.init().setAppelant(appelant).setLimit(limit).setSubsetList(PiocheHtmlProducerFactory.getSubsetList(requestHandler, (short)3)).putParameter("defaultspherekey", PiocheHtmlProducerFactory.getDefaultSphereKey(requestHandler));
    }

    private static int getLimit(OutputRequestHandler requestHandler) throws ErrorMessageException {
        String limitString = requestHandler.getTrimedParameter("limit");
        int limit = 5;
        if (!limitString.isEmpty()) {
            try {
                limit = Integer.parseInt(limitString);
                if (limit < 1) {
                    limit = 5;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return limit;
    }

    private static SubsetKey getDefaultSphereKey(OutputRequestHandler requestHandler) throws ErrorMessageException {
        String defaultsphereParam = requestHandler.getTrimedParameter("defaultsphere");
        if (defaultsphereParam.isEmpty()) {
            return null;
        }
        try {
            SubsetKey sphereKey = SubsetKey.parse(defaultsphereParam);
            if (sphereKey.isSphereSubset()) {
                return sphereKey;
            }
            return null;
        }
        catch (ParseException pe) {
            return null;
        }
    }

    private static List<Subset> getSubsetList(OutputRequestHandler requestHandler, short category) throws ErrorMessageException {
        String subsetsParam = requestHandler.getMandatoryParameter("subsets");
        if (subsetsParam.length() == 0) {
            return null;
        }
        String[] array = StringUtils.getTechnicalTokens(subsetsParam, true);
        ArrayList<Subset> subsetList = new ArrayList<Subset>();
        for (String name : array) {
            try {
                SubsetKey subsetKey = SubsetKey.parse(category, name);
                Subset subset = requestHandler.getFichotheque().getSubset(subsetKey);
                if (subset == null) continue;
                subsetList.add(subset);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (subsetList.isEmpty()) {
            throw BdfErrors.wrongParameterValue("subsets", subsetsParam);
        }
        return subsetList;
    }

    private static SubsetKey getCroisementSubsetKey(OutputRequestHandler requestHandler) throws ErrorMessageException {
        String subsetString = requestHandler.getTrimedParameter("croisement");
        if (subsetString.isEmpty()) {
            return null;
        }
        try {
            SubsetKey subsetKey = SubsetKey.parse(subsetString);
            return subsetKey;
        }
        catch (ParseException pe) {
            throw BdfErrors.wrongParameterValue("croisement", subsetString);
        }
    }
}

