/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.externalsource.ExternalSourceType;
import fr.exemole.bdfserver.api.namespaces.CommandSpace;
import fr.exemole.bdfserver.api.subsettree.CroisementSubsetNode;
import fr.exemole.bdfserver.api.subsettree.GroupNode;
import fr.exemole.bdfserver.api.subsettree.SubsetTree;
import fr.exemole.bdfserver.api.ui.CommentUi;
import fr.exemole.bdfserver.api.ui.DataUi;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.SpecialIncludeUi;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.commands.corpus.CloneCommand;
import fr.exemole.bdfserver.commands.corpus.FieldCreationCommand;
import fr.exemole.bdfserver.html.BdfHtmlUtils;
import fr.exemole.bdfserver.html.consumers.AttributesText;
import fr.exemole.bdfserver.html.consumers.Common;
import fr.exemole.bdfserver.html.consumers.CroisementSelection;
import fr.exemole.bdfserver.html.consumers.Grid;
import fr.exemole.bdfserver.html.consumers.LangRows;
import fr.exemole.bdfserver.html.consumers.MetadataPhrases;
import fr.exemole.bdfserver.html.consumers.SelectOption;
import fr.exemole.bdfserver.html.consumers.SubsetTitle;
import fr.exemole.bdfserver.html.consumers.SubsetTreeOptions;
import fr.exemole.bdfserver.html.consumers.Tree;
import fr.exemole.bdfserver.html.consumers.attributes.Appelant;
import fr.exemole.bdfserver.html.consumers.attributes.Deploy;
import fr.exemole.bdfserver.html.consumers.attributes.InputPattern;
import fr.exemole.bdfserver.html.consumers.commandbox.Flag;
import fr.exemole.bdfserver.htmlproducers.CommandBoxUtils;
import fr.exemole.bdfserver.htmlproducers.corpus.CorpusHtmlUtils;
import fr.exemole.bdfserver.tools.L10nUtils;
import fr.exemole.bdfserver.tools.externalsource.ExternalSourceUtils;
import fr.exemole.bdfserver.tools.ficheform.FicheFormUtils;
import fr.exemole.bdfserver.tools.subsettree.TreeFilterEngine;
import fr.exemole.bdfserver.tools.subsettree.TreeUtils;
import fr.exemole.bdfserver.tools.ui.MetadataPhraseDefCatalog;
import fr.exemole.bdfserver.tools.ui.UiUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.addenda.Document;
import net.fichotheque.album.Illustration;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.externalsource.ExternalSourceDef;
import net.fichotheque.namespaces.BdfSpace;
import net.fichotheque.tools.corpus.FichesBuilder;
import net.fichotheque.utils.AddendaUtils;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.html.CommandBox;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.html.HtmlWrapper;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.text.Labels;

public final class CorpusCommandBoxUtils {
    private static final HtmlWrapper FICHES_TREE = Tree.tree("command-fiches-Tree");
    private static final SelectOption[] INPUTTYPE_OPTIONS = new SelectOption[]{SelectOption.init("text").textL10nObject("_ label.corpus.inputtype_text"), SelectOption.init("select").textL10nObject("_ label.corpus.inputtype_select"), SelectOption.init("check").textL10nObject("_ label.corpus.inputtype_check"), SelectOption.init("radio").textL10nObject("_ label.corpus.inputtype_radio"), SelectOption.init("fichestyle").textL10nObject("_ label.corpus.inputtype_fichestyle")};
    private static final SelectOption[] WIDTHTYPE_OPTIONS = new SelectOption[]{SelectOption.init("small").textL10nObject("_ label.corpus.size_small"), SelectOption.init("medium").textL10nObject("_ label.corpus.size_medium"), SelectOption.init("large").textL10nObject("_ label.corpus.size_large")};
    private static final SelectOption[] STATUS_OPTIONS = new SelectOption[]{SelectOption.init("default").text("---"), SelectOption.init("mandatory").textL10nObject("_ label.corpus.status_mandatory"), SelectOption.init("optional").textL10nObject("_ label.corpus.status_optional"), SelectOption.init("obsolete").textL10nObject("_ label.corpus.status_obsolete")};
    private static final SelectOption[] VARIANT_OPTIONS = new SelectOption[]{SelectOption.init("").text("---"), SelectOption.init("table").textL10nObject("_ label.corpus.variant_fichetable")};

    private CorpusCommandBoxUtils() {
    }

    public static boolean printCorpusCreationBox(HtmlPrinter hp, CommandBox commandBox, BdfServer bdfServer, Lang workingLang) {
        commandBox = commandBox.derive("CorpusCreation", "_ CRP-01").__(Flag.UPDATE_COLLECTIONS).__(Flag.UPDATE_CORPUS_TREE).actionCssClass("action-New").submitLocKey("_ submit.corpus.corpuscreation");
        hp.__start(commandBox).__(Grid.START).__(Grid.textInputRow("_ label.corpus.newcorpusname", hp.name("newcorpus").size("30").populate(InputPattern.TECHNICAL_STRICT).required(true))).__(CorpusCommandBoxUtils.printSatelliteOpportunities(hp, bdfServer, workingLang)).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printConfChangeBox(HtmlPrinter hp, CommandBox commandBox, Corpus corpus) {
        commandBox = commandBox.derive("ConfChange", "_ CRP-35").__(CommandBoxUtils.insert(corpus)).__(Flag.UPDATE_CORPUS_TREE).actionCssClass("action-Edit").submitLocKey("_ submit.corpus.confchange");
        hp.__start(commandBox).P("global-SubTitle").__localize("_ info.corpus.confchange")._P().TEXTAREA(HA.name("conf").cols(60).rows(20).attr("data-codemirror-mode", "properties").attr("data-codemirror-options", "numbers"))._TEXTAREA().__end(commandBox);
        return true;
    }

    public static boolean printCorpusPhrasesBox(HtmlPrinter hp, CommandBox commandBox, Corpus corpus, BdfServer bdfServer, Lang lang) {
        Langs langs = bdfServer.getLangConfiguration().getWorkingLangs();
        CorpusMetadata corpusMetadata = corpus.getCorpusMetadata();
        MetadataPhrases metadataPhrases = MetadataPhrases.init(corpusMetadata, langs, "_ label.corpus.title").addDef(MetadataPhraseDefCatalog.FICHE_PHRASEDEF).addDef(MetadataPhraseDefCatalog.NEWFICHE_PHRASEDEF);
        if (corpus.getMasterSubset() != null) {
            metadataPhrases.addDef(MetadataPhraseDefCatalog.SATELLITE_PHRASEDEF);
        }
        metadataPhrases.populateFromAttributes(corpus).addExtensionPhraseDefList(bdfServer);
        commandBox = commandBox.derive("CorpusPhrases", "_ CRP-10").__(CommandBoxUtils.insert(corpus)).__(Flag.UPDATE_CORPUS_TREE).actionCssClass("action-Labels").submitLocKey("_ submit.corpus.corpusphrases");
        hp.__start(commandBox).__(metadataPhrases).__(CorpusCommandBoxUtils.printCorpusFieldList(hp, CorpusMetadataUtils.getSpecialCorpusFieldList(corpusMetadata, true), "_ title.corpus.labellist_special", langs, lang)).__(CorpusCommandBoxUtils.printCorpusFieldList(hp, corpusMetadata.getPropList(), "_ title.corpus.labellist_prop", langs, lang)).__(CorpusCommandBoxUtils.printCorpusFieldList(hp, corpusMetadata.getInfoList(), "_ title.corpus.labellist_info", langs, lang)).__(CorpusCommandBoxUtils.printCorpusFieldList(hp, corpusMetadata.getSectionList(), "_ title.corpus.labellist_section", langs, lang)).__end(commandBox);
        return true;
    }

    public static boolean printSubtitleActivationBox(HtmlPrinter hp, CommandBox commandBox, Corpus corpus) {
        commandBox = commandBox.derive("SubtitleActivation", "_ CRP-02").__(CommandBoxUtils.insert(corpus)).actionCssClass("action-FieldCreate").submitLocKey("_ submit.corpus.subtitleactivation");
        hp.__start(commandBox).__end(commandBox);
        return true;
    }

    public static boolean printFieldCreationBox(HtmlPrinter hp, CommandBox commandBox, Corpus corpus, short fieldCategory, Langs langs) {
        commandBox = commandBox.derive("FieldCreation", FieldCreationCommand.getCommandKey(fieldCategory)).__(CommandBoxUtils.insert(corpus)).hidden("category", FieldKey.categoryToString(fieldCategory)).actionCssClass("action-FieldCreate").submitLocKey("_ submit.corpus.fieldcreation");
        hp.__start(commandBox).__(Grid.START).__(Grid.textInputRow("_ label.corpus.newfieldname", hp.name("newfieldname").size("30").populate(InputPattern.TECHNICAL_STRICT).required(true))).__(CorpusCommandBoxUtils.printFieldTypeSelectRow(hp, fieldCategory));
        if (langs.size() == 1) {
            hp.__(Grid.textInputRow("_ label.corpus.fieldlabel", hp.name("newlabel/" + langs.getStringValue(0)).size("30")));
        } else {
            hp.__(Grid.choiceSetRow((Object)"_ label.corpus.fieldlabels", () -> hp.__(Grid.START_SUBTABLE).__(LangRows.init("newlabel/", null, langs).cols(25)).__(Grid.END_SUBTABLE)));
        }
        hp.__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printFicheRemoveBox(HtmlPrinter hp, CommandBox commandBox, FicheMeta ficheMeta, Lang workingLang, Locale formatLocale) {
        commandBox = commandBox.derive("FicheRemove", "_ CRP-11").__(CommandBoxUtils.insert(ficheMeta)).actionCssClass("action-Delete").submitLocKey("_ submit.corpus.ficheremove");
        hp.__start(commandBox).__(CorpusCommandBoxUtils.printSatelliteFicheWarning(hp, ficheMeta, "_ warning.corpus.satelliteremove", workingLang, formatLocale)).__(Grid.START).__(Grid.textAreaBlockRow((Object)"_ label.corpus.discardtext_remove", hp.name("discardtext").cols(60).rows(6).classes("command-LargeInput"), new DiscardText(ficheMeta))).__(Grid.END).__(Common.REMOVE_CONFIRM_CHECK).__end(commandBox);
        return true;
    }

    public static boolean printFicheDiscardBox(HtmlPrinter hp, CommandBox commandBox, FicheMeta ficheMeta, Lang workingLang, Locale formatLocale) {
        String textAreaId = hp.generateId();
        commandBox = commandBox.derive("FicheDiscard", "_ CRP-27").__(CommandBoxUtils.insert(ficheMeta)).actionCssClass("action-Discard").submitLocKey("_ submit.corpus.fichediscard");
        hp.__start(commandBox).__(CorpusCommandBoxUtils.printSatelliteFicheWarning(hp, ficheMeta, "_ warning.corpus.satellitediscard", workingLang, formatLocale)).__(Grid.START).__(Grid.textAreaBlockRow((Object)"_ label.corpus.discardtext", HA.name("discardtext").id(textAreaId).cols(60).rows(6).classes("command-LargeInput"), new DiscardText(ficheMeta))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printFicheRetrieveBox(HtmlPrinter hp, CommandBox commandBox, FicheMeta ficheMeta, Lang workingLang, Locale formatLocale) {
        String textAreaId = hp.generateId();
        commandBox = commandBox.derive("FicheRetrieve", "_ CRP-28").__(CommandBoxUtils.insert(ficheMeta)).actionCssClass("action-Retrieve").submitLocKey("_ submit.corpus.ficheretrieve");
        hp.__start(commandBox).__(CorpusCommandBoxUtils.printSatelliteFicheWarning(hp, ficheMeta, "_ warning.corpus.satelliteretrieve", workingLang, formatLocale)).__(Grid.START).__(Grid.textAreaBlockRow((Object)"_ label.corpus.discardtext", HA.name("").id(textAreaId).disabled(true).cols(60).rows(6).classes("command-LargeInput"), new DiscardText(ficheMeta))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printCroisementCopyBox(HtmlPrinter hp, CommandBox commandBox, BdfServer bdfServer, FicheMeta ficheMeta, Lang workingLang, Locale formatLocale) {
        boolean withIllustrations;
        SubsetTree addendaTree = TreeFilterEngine.croisement(ficheMeta, bdfServer.getTreeManager().getSubsetTree((short)4));
        SubsetTree albumTree = TreeFilterEngine.croisement(ficheMeta, bdfServer.getTreeManager().getSubsetTree((short)5));
        boolean withDocuments = !addendaTree.getNodeList().isEmpty();
        boolean bl = withIllustrations = !albumTree.getNodeList().isEmpty();
        if (!withDocuments && !withIllustrations) {
            return false;
        }
        commandBox = commandBox.derive("CroisementCopy", "_ CRP-29").__(CommandBoxUtils.insert(ficheMeta)).actionCssClass("action-Duplicate").submitLocKey("_ submit.corpus.croisementcopy");
        hp.__start(commandBox);
        if (withDocuments) {
            hp.H2().__localize("_ title.global.addenda_collection")._H2().UL("global-CroisementList").__(CorpusCommandBoxUtils.printCroisementNodeList(hp, bdfServer, addendaTree.getNodeList(), workingLang, "documents"))._UL();
        }
        if (withIllustrations) {
            hp.H2().__localize("_ title.global.album_collection")._H2().UL("global-CroisementList").__(CorpusCommandBoxUtils.printCroisementNodeList(hp, bdfServer, albumTree.getNodeList(), workingLang, "illustrations"))._UL();
        }
        hp.H2().__localize("_ title.corpus.destination")._H2().__(Grid.START).__(Grid.textInputRow("_ label.corpus.destinatinonid", hp.name("destination").size("20").populate(Appelant.fiche().limit(1)))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printFieldRemoveBox(HtmlPrinter hp, CommandBox commandBox, Corpus corpus, Lang lang) {
        commandBox = commandBox.derive("FieldRemove", "_ CRP-08").__(CommandBoxUtils.insert(corpus)).actionCssClass("action-FieldRemove").submitLocKey("_ submit.corpus.fieldremove");
        hp.__start(commandBox).__(Grid.START).__(Grid.selectRow((Object)"_ label.corpus.fieldtoremove", hp.name("fieldkey"), () -> hp.OPTION("", true).__escape("---")._OPTION().__(CorpusCommandBoxUtils.printFieldKeySelectOptions(hp, corpus, lang, false)))).__(Grid.END).__(Common.REMOVE_CONFIRM_CHECK).__end(commandBox);
        return true;
    }

    public static boolean printUiComponentPositionBox(HtmlPrinter hp, CommandBox commandBox, Corpus corpus, UiComponents uiComponents, BdfServer bdfServer, Lang lang) {
        commandBox = commandBox.derive("UiComponentPosition", "_ CRP-18").__(CommandBoxUtils.insert(corpus)).actionCssClass("action-ComponentPosition").submitLocKey("_ submit.corpus.uicomponentposition");
        hp.__start(commandBox).TEXTAREA(HA.name("componentposition").cols(60).rows(20).attr("data-codemirror-mode", "uicomponents"));
        for (UiComponent uiComponent : uiComponents.getUiComponentList()) {
            hp.__escape(uiComponent.getName());
            String label = L10nUtils.getTitle(bdfServer, corpus, uiComponent, lang);
            if (label != null) {
                hp.__space().__escape('(').__escape(label).__escape(')');
            }
            hp.__newLine();
        }
        hp._TEXTAREA().__end(commandBox);
        return true;
    }

    public static boolean printUiComponentOptionsBox(HtmlPrinter hp, CommandBox commandBox, Corpus corpus, UiComponents uiComponents, BdfServer bdfServer, Lang lang) {
        commandBox = commandBox.derive("UiComponentOptions", "_ CRP-19").__(CommandBoxUtils.insert(corpus)).actionCssClass("action-ComponentOptions").submitLocKey("_ submit.corpus.uicomponentoptions");
        hp.__start(commandBox).DL("global-DL");
        for (UiComponent uiComponent : uiComponents.getUiComponentList()) {
            IncludeUi includeUi;
            String name;
            if (uiComponent instanceof FieldUi) {
                CorpusField corpusField;
                FieldUi fieldUi = (FieldUi)uiComponent;
                if (!CorpusCommandBoxUtils.hasUiOption(fieldUi)) continue;
                name = fieldUi.getFieldString();
                boolean blockField = false;
                FieldKey fieldKey = fieldUi.getFieldKey();
                if (fieldKey.isSection()) {
                    blockField = true;
                } else if (fieldKey.isInfo() && (corpusField = corpus.getCorpusMetadata().getCorpusField(fieldKey)) != null) {
                    blockField = corpusField.isBlockDisplayInfoField();
                }
                hp.__(CorpusCommandBoxUtils.printComponentUiDt(hp, corpus, uiComponent, bdfServer, lang)).DD().__(CorpusCommandBoxUtils.printOptions(hp, name, fieldUi, blockField))._DD();
                continue;
            }
            if (uiComponent instanceof SpecialIncludeUi) {
                includeUi = (SpecialIncludeUi)uiComponent;
                name = includeUi.getName();
                if (!name.equals("liage")) continue;
                hp.__(CorpusCommandBoxUtils.printComponentUiDt(hp, corpus, uiComponent, bdfServer, lang)).DD().__(CorpusCommandBoxUtils.printOptions(hp, name, includeUi, false))._DD();
                continue;
            }
            if (!(uiComponent instanceof SubsetIncludeUi)) continue;
            includeUi = (SubsetIncludeUi)uiComponent;
            name = includeUi.getName();
            hp.__(CorpusCommandBoxUtils.printComponentUiDt(hp, corpus, uiComponent, bdfServer, lang)).DD().__(CorpusCommandBoxUtils.printOptions(hp, name, includeUi, false))._DD();
        }
        hp._DL().__end(commandBox);
        return true;
    }

    private static boolean hasUiOption(FieldUi fieldUi) {
        switch (fieldUi.getFieldString()) {
            case "lang": {
                return false;
            }
        }
        return true;
    }

    public static boolean printUiComponentAttributesBox(HtmlPrinter hp, CommandBox commandBox, Corpus corpus, UiComponents uiComponents, BdfServer bdfServer, Lang lang) {
        HashSet<String> existingSet = new HashSet<String>();
        commandBox = commandBox.derive("UiComponentAttributes", "_ CRP-30").__(CommandBoxUtils.insert(corpus)).actionCssClass("action-ComponentAttributes").submitLocKey("_ submit.global.attributechange");
        hp.__start(commandBox).DL("global-DL");
        for (UiComponent uiComponent : uiComponents.getUiComponentList()) {
            String name = uiComponent.getName();
            if (existingSet.contains(name)) continue;
            existingSet.add(name);
            hp.__(CorpusCommandBoxUtils.printComponentUiDt(hp, corpus, uiComponent, bdfServer, lang)).DD().TEXTAREA(hp.name(name + "|attributes").rows(4).cols(75).attr("data-codemirror-mode", "attributes")).__(new AttributesText(uiComponent.getAttributes()))._TEXTAREA()._DD();
        }
        hp._DL().__end(commandBox);
        return true;
    }

    public static boolean printCorpusRemoveBox(HtmlPrinter hp, CommandBox commandBox, Corpus corpus) {
        commandBox = commandBox.derive("CorpusRemove", "_ CRP-09").__(CommandBoxUtils.insert(corpus)).__(Flag.UPDATE_COLLECTIONS).__(Flag.UPDATE_CORPUS_TREE).actionCssClass("action-Delete").submitLocKey("_ submit.corpus.corpusremove");
        hp.__start(commandBox).__(Common.REMOVE_CONFIRM_CHECK).__end(commandBox);
        return true;
    }

    public static boolean printIncludeChangeBox(HtmlPrinter hp, CommandBox commandBox, Corpus corpus, IncludeUi includeUi, Langs workingLangs) {
        String targetId = hp.generateId();
        Labels labels = includeUi.getCustomLabels();
        boolean custom = labels != null;
        commandBox = commandBox.derive("IncludeChange", "_ CRP-13").__(CommandBoxUtils.insert(corpus)).hidden("key", includeUi.getName()).submitLocKey("_ submit.corpus.includechange");
        hp.__start(commandBox).__(Grid.START).__(Grid.checkboxRow((Object)"_ label.corpus.customlabels", hp.name("custom").value("1").checked(custom).populate(Deploy.checkbox(targetId)), () -> hp.DIV(Grid.detailPanelTable().id(targetId).addClass(!custom, "hidden")).__(LangRows.init("title/", labels, workingLangs).cols(30))._DIV())).__(Grid.textAreaInputRow((Object)"_ label.global.attributes", hp.name("attributes").rows(4).cols(50).attr("data-codemirror-mode", "attributes"), new AttributesText(includeUi.getAttributes()))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printDataChangeBox(HtmlPrinter hp, CommandBox commandBox, Corpus corpus, DataUi dataUi, Langs workingLangs) {
        commandBox = commandBox.derive("DataChangeCommand", "_ CRP-34").__(CommandBoxUtils.insert(corpus)).hidden("name", dataUi.getDataName()).submitLocKey("_ submit.corpus.datachange");
        hp.__start(commandBox).__(Grid.START).DIV("grid-Row").DIV("grid-UniqueCell").__localize("_ title.corpus.includelabels").DIV(Grid.detailPanelTable()).__(LangRows.init("title/", dataUi.getLabels(), workingLangs).cols(30))._DIV()._DIV()._DIV().__(CorpusCommandBoxUtils.printExternalSourceParams(hp, dataUi.getExternalSourceDef())).__(Grid.textAreaInputRow((Object)"_ label.global.attributes", hp.name("attributes").rows(4).cols(50).attr("data-codemirror-mode", "attributes"), new AttributesText(dataUi.getAttributes()))).__(Grid.END).__end(commandBox);
        return true;
    }

    private static boolean printExternalSourceParams(HtmlPrinter hp, ExternalSourceDef externalSourceDef) {
        ExternalSourceType externalSourceType = ExternalSourceUtils.getMatchingExternalSourceType(externalSourceDef);
        for (ExternalSourceType.Param param : externalSourceType.getParamList()) {
            String paramName = param.getName();
            String value = externalSourceDef.getParam(paramName);
            if (value == null) {
                value = "";
            }
            hp.__(Grid.textInputRow(param.getL10nObject(), hp.name("param_" + paramName).value(value).size("30")));
        }
        return true;
    }

    public static boolean printSpecialIncludeAddBox(HtmlPrinter hp, CommandBox commandBox, Corpus corpus, List<SelectOption> optionList, String selected) {
        commandBox = commandBox.derive("SpecialIncludeAdd", "_ CRP-31").__(CommandBoxUtils.insert(corpus)).actionCssClass("action-New").submitLocKey("_ submit.corpus.specialincludeadd");
        hp.__start(commandBox).__(Grid.START).__(Grid.selectRow((Object)"_ label.corpus.specialinclude", hp.name("name"), () -> {
            for (SelectOption selectOption : optionList) {
                selectOption.accept(hp, (Object)selected);
            }
        })).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printDataCreationBox(HtmlPrinter hp, CommandBox commandBox, Corpus corpus, BdfServer bdfServer) {
        List<ExternalSourceType> list = ExternalSourceUtils.getDataUiAvalaibleTypeList(bdfServer);
        commandBox = commandBox.derive("DataCreationCommand", "_ CRP-33").__(CommandBoxUtils.insert(corpus)).submitLocKey("_ submit.corpus.datacreation");
        hp.__start(commandBox).__(Grid.START).__(Grid.textInputRow("_ label.global.name", hp.name("name").size("30").populate(InputPattern.TECHNICAL_STRICT).required(true))).__(Grid.selectRow((Object)"_ label.corpus.externalsourcetype", hp.name("type"), () -> {
            boolean selected = true;
            for (ExternalSourceType externalSourceType : list) {
                hp.OPTION(externalSourceType.getName(), selected).__localize(externalSourceType.getL10nObject())._OPTION();
                selected = false;
            }
        })).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printSubsetIncludeCreationBox(HtmlPrinter hp, CommandBox commandBox, Corpus corpus, BdfServer bdfServer, Lang workingLang, short subsetCategory) {
        SubsetTree subsetTree = bdfServer.getTreeManager().getSubsetTree(subsetCategory);
        if (TreeUtils.getFirstSubsetKey(subsetTree) == null) {
            return false;
        }
        commandBox = commandBox.derive("SubsetIncludeCreation", "_ CRP-12").__(CommandBoxUtils.insert(corpus)).actionCssClass(BdfHtmlUtils.getAddCss(subsetCategory)).submitLocKey("_ submit.corpus.subsetincludecreation");
        hp.__start(commandBox).__(Grid.START).__(Grid.selectRow((Object)BdfHtmlUtils.getSubsetCategoryLocKey(subsetCategory), hp.name("subset"), SubsetTreeOptions.init(subsetTree, bdfServer, workingLang).withKeys(true))).__if(subsetCategory == 1 || subsetCategory == 2, () -> {
            Subset masterSubset = corpus.getMasterSubset();
            if (masterSubset != null && (subsetCategory == 1 || subsetCategory == 2 && masterSubset instanceof Corpus)) {
                String l10nKey = CorpusCommandBoxUtils.getMasterL10nKey(masterSubset.getSubsetKey().getCategory());
                hp.__(Grid.checkboxRow(l10nKey, hp.name("masterinclude").value("1")));
            }
        }).__(Grid.textInputRow("_ label.global.mode", hp.name("mode").size("15").populate(InputPattern.TECHNICAL_STRICT))).__(Grid.choiceSetRow((Object)"_ label.corpus.croisement_weight", () -> hp.__(Grid.radioCell("_ label.corpus.weightfilter_no", hp.name("weightfilter").value("0").checked(true))).__(Grid.radioCell((Object)"_ label.corpus.weightfilter_yes", hp.name("weightfilter").value("1").checked(false), () -> hp.__(Grid.START).__(Grid.textInputRow("_ label.corpus.croisement_weight", hp.name("weightfiltervalue").size("3"))).__(Grid.END))))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printComponentRemoveBox(HtmlPrinter hp, CommandBox commandBox, Corpus corpus, UiComponent uiComponent) {
        commandBox = commandBox.derive("IncludeRemove", "_ CRP-14").__(CommandBoxUtils.insert(corpus)).hidden("name", uiComponent.getName()).actionCssClass("action-Delete").submitLocKey("_ submit.corpus.includeremove");
        hp.__start(commandBox).__end(commandBox);
        return true;
    }

    public static boolean printCommentChangeBox(HtmlPrinter hp, CommandBox commandBox, Corpus corpus, CommentUi commentUi, Lang[] workingLangArray) {
        String[] htmlArray = UiUtils.toStringArray(commentUi, workingLangArray);
        commandBox = commandBox.derive("CommentChange", "_ CRP-16").__(CommandBoxUtils.insert(corpus)).hidden("name", commentUi.getCommentName()).submitLocKey("_ submit.corpus.commentchange");
        hp.__start(commandBox).__(Grid.START).__(LangRows.init("comment/", workingLangArray, htmlArray).cols(77).rows(9).codemirrorMode("html")).__(Grid.END).__(Grid.START).__(CorpusCommandBoxUtils.printCommentLocationRadioList(hp, commentUi.getLocation())).__(Grid.textAreaInputRow((Object)"_ label.global.attributes", hp.name("attributes").rows(4).cols(50).attr("data-codemirror-mode", "attributes"), new AttributesText(commentUi.getAttributes()))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printCommentCreationBox(HtmlPrinter hp, CommandBox commandBox, Corpus corpus, Lang[] langArray) {
        int length = langArray.length;
        String[] empty = new String[length];
        for (int i = 0; i < length; ++i) {
            empty[i] = "";
        }
        commandBox = commandBox.derive("CommentCreation", "_ CRP-15").__(CommandBoxUtils.insert(corpus)).actionCssClass("action-CommentAdd").submitLocKey("_ submit.corpus.commentcreation");
        hp.__start(commandBox).__(Grid.START).__(CorpusCommandBoxUtils.printCommentLocationRadioList(hp, 3)).__(Grid.END).__(Grid.START).__(LangRows.init("comment/", langArray, empty).cols(77).rows(9).codemirrorMode("html")).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printCommentRemoveBox(HtmlPrinter hp, CommandBox commandBox, Corpus corpus, CommentUi commentUi) {
        commandBox = commandBox.derive("CommentRemove", "_ CRP-17").__(CommandBoxUtils.insert(corpus)).hidden("name", commentUi.getCommentName()).actionCssClass("action-Delete").submitLocKey("_ submit.corpus.commentremove");
        hp.__start(commandBox).__(Common.REMOVE_CONFIRM_CHECK).__end(commandBox);
        return true;
    }

    public static boolean printReloadBox(HtmlPrinter hp, CommandBox commandBox, Corpus corpus) {
        commandBox = commandBox.derive("Reload", "_ CRP-20").__(CommandBoxUtils.insert(corpus)).actionCssClass("action-Refresh").submitLocKey("_ submit.corpus.reload");
        hp.__start(commandBox).__(Grid.START).__(Grid.checkboxRow("_ label.corpus.fichepurge", hp.name("purge").value("1").checked(false))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printCloneBox(HtmlPrinter hp, CommandBox commandBox, Corpus corpus, BdfServer bdfServer, Lang workingLang) {
        commandBox = commandBox.derive("Clone", "_ CRP-21").__(CommandBoxUtils.insert(corpus)).actionCssClass("action-Duplicate").__(Flag.UPDATE_COLLECTIONS).__(Flag.UPDATE_CORPUS_TREE).submitLocKey("_ submit.corpus.clone");
        hp.__start(commandBox).__(Grid.START).__(Grid.textInputRow("_ label.corpus.newcorpusname", hp.name(CloneCommand.NEWCORPUS_PARAMNAME).size("30").populate(InputPattern.TECHNICAL_STRICT).required(true))).__(CorpusCommandBoxUtils.printSatelliteOpportunities(hp, bdfServer, workingLang)).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printConversionBox(HtmlPrinter hp, CommandBox commandBox, Corpus corpus, Lang lang) {
        commandBox = commandBox.derive("Conversion", "_ CRP-22").__(CommandBoxUtils.insert(corpus)).actionCssClass("action-Duplicate").submitLocKey("_ submit.corpus.fieldconversion");
        hp.__start(commandBox).__(Grid.START).__(Grid.selectRow((Object)"_ label.corpus.old_fieldkey", hp.name("field"), () -> CorpusCommandBoxUtils.printFieldKeySelectOptions(hp, corpus, lang, true))).__(Grid.selectRow((Object)"_ label.corpus.new_fieldcategory", hp.name("newcategory"), () -> CorpusCommandBoxUtils.printCategorySelectOptions(hp))).__(Grid.textInputRow("_ label.corpus.new_fieldname", hp.name("newname").size("30"))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printSectionMergeBox(HtmlPrinter hp, CommandBox commandBox, Corpus corpus, Lang lang) {
        commandBox = commandBox.derive("SectionMerge", "_ CRP-32").__(CommandBoxUtils.insert(corpus)).actionCssClass("action-FieldRemove").submitLocKey("_ submit.corpus.sectionmerge");
        hp.__start(commandBox).__(Grid.START).__(Grid.selectRow((Object)"_ label.corpus.fieldkey_origin", hp.name("origin"), () -> CorpusCommandBoxUtils.printSectionSelectOptions(hp, corpus, lang))).__(Grid.textAreaInputRow("_ label.corpus.transitiontext", hp.name("transitiontext").rows(4).cols(60))).__(Grid.selectRow((Object)"_ label.corpus.fieldkey_destination", hp.name("destination"), () -> CorpusCommandBoxUtils.printSectionSelectOptions(hp, corpus, lang))).__(Grid.END).__(Common.MERGE_CONFIRM_CHECK).__end(commandBox);
        return true;
    }

    public static boolean printDuplicationBox(HtmlPrinter hp, CommandBox commandBox, Corpus corpus, BdfServer bdfServer, Lang lang) {
        String linkToOriginDetailId = hp.generateId();
        Attribute excludeAttribute = corpus.getCorpusMetadata().getAttributes().getAttribute(CommandSpace.DUPLICATION_EXCLUDE_KEY);
        boolean allChecked = excludeAttribute == null;
        boolean filterChecked = !allChecked;
        commandBox = commandBox.derive("Duplication", "_ CRP-23").__(CommandBoxUtils.insert(corpus)).actionCssClass("action-Duplicate").submitLocKey("_ submit.corpus.ficheduplication");
        hp.__start(commandBox).__(Grid.START).__(Grid.selectRow((Object)"_ label.corpus.destinationcorpus", hp.name("destination"), SubsetTreeOptions.init(bdfServer.getTreeManager().getSubsetTree((short)1), bdfServer, lang).onlyNames(true).withKeys(true).selectedSubsetKey(corpus.getSubsetKey()))).__(Grid.choiceSetRow((Object)"_ label.corpus.fichesorigin", () -> hp.__(Grid.radioCell("_ label.corpus.mode_selection", hp.name("mode").value("selection").checked(false))).__(Grid.radioCell((Object)"_ label.corpus.mode_list", hp.name("mode").value("list").checked(true), () -> hp.__(Grid.START).__(Grid.textAreaBlockRow("_ label.corpus.idtokens", hp.name("idtokens").cols(80).rows(5))).__(Grid.checkboxRow("_ label.corpus.withdestinationids", hp.name("withdestinationids").value("1").checked(false))).__(Grid.END))))).__(Grid.choiceSetRow((Object)"_ label.corpus.duplicationfilter", () -> hp.__(Grid.radioCell("_ label.corpus.duplicationfilter_all", hp.name("filter").value("all").checked(allChecked))).__(Grid.radioCell("_ label.corpus.duplicationfilter_ficheonly", hp.name("filter").value("ficheonly").checked(false))).__(Grid.radioCell((Object)"_ label.corpus.duplicationfilter_exclude", hp.name("filter").value("exclude").checked(filterChecked), () -> hp.__(Grid.START).__(Grid.textAreaBlockRow((Object)"_ label.corpus.duplicationexclude", hp.name("exclude").cols(80).rows(5), () -> {
            if (excludeAttribute != null) {
                boolean next = false;
                for (String value : excludeAttribute) {
                    if (next) {
                        hp.__escape(", ");
                    } else {
                        next = true;
                    }
                    hp.__escape(value);
                }
            }
        })).__(Grid.checkboxRow("_ label.corpus.storeexclude", hp.name("store").value("1").checked(false))).__(Grid.END))))).__(Grid.textAreaInputRow((Object)"_ label.corpus.fieldmatching", hp.name("fieldmatching").rows(4).cols(50), () -> hp.__escape("", true))).__(Grid.checkboxRow((Object)"_ label.corpus.linktoorigin", hp.name("linktoorigin").value("1").checked(false).populate(Deploy.checkbox(linkToOriginDetailId)), () -> hp.DIV(Grid.detailPanelTable().id(linkToOriginDetailId).addClass("hidden")).__(Grid.textInputRow("_ label.global.mode", hp.name("linktoorigin_mode").size("15"))).__(Grid.textInputRow("_ label.corpus.croisement_weight", hp.name("linktoorigin_weight").size("3")))._DIV())).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printReponderationBox(HtmlPrinter hp, CommandBox commandBox, Corpus corpus) {
        commandBox = commandBox.derive("Reponderation", "_ CRP-24").__(CommandBoxUtils.insert(corpus)).actionCssClass("action-Run").submitLocKey("_ submit.corpus.reponderation");
        hp.__start(commandBox).__(Grid.START).__(Grid.textInputRow("_ label.corpus.croisementsubset", hp.name("croisementsubset").size("30"))).__(Grid.choiceSetRow((Object)"_ label.corpus.fichesorigin", () -> hp.__(Grid.radioCell("_ label.corpus.mode_selection", hp.name("mode").value("selection").checked(false))).__(Grid.radioCell((Object)"_ label.corpus.mode_list", hp.name("mode").value("list").checked(true), () -> hp.__(Grid.START).__(Grid.textAreaBlockRow("_ label.corpus.idtokens", hp.name("idtokens").cols(80).rows(5))).__(Grid.END))))).__(Grid.textInputRow("_ label.corpus.old_mode", hp.name("oldmode").size("15"))).__(Grid.textInputRow("_ label.corpus.old_weight", hp.name("oldweight").size("3"))).__(Grid.textInputRow("_ label.corpus.new_mode", hp.name("newmode").size("15"))).__(Grid.textInputRow("_ label.corpus.new_weight", hp.name("newweight").size("3"))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printCorpusAttributeChangeBox(HtmlPrinter hp, CommandBox commandBox, Corpus corpus) {
        commandBox = commandBox.derive("CorpusAttributeChange", "_ CRP-03").__(CommandBoxUtils.insert(corpus)).actionCssClass("action-Attributes").submitLocKey("_ submit.global.attributechange");
        hp.__start(commandBox).__(Grid.START).__(Grid.textAreaBlockRow((Object)"_ label.global.attributes", hp.name("attributes").rows(8).cols(75).attr("data-codemirror-mode", "attributes"), new AttributesText(corpus.getCorpusMetadata().getAttributes()))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printFicheAttributeChangeBox(HtmlPrinter hp, CommandBox commandBox, FicheMeta ficheMeta) {
        commandBox = commandBox.derive("FicheAttributeChange", "_ CRP-25").__(CommandBoxUtils.insert(ficheMeta)).submitLocKey("_ submit.global.attributechange");
        hp.__start(commandBox).__(Grid.START).__(Grid.textAreaBlockRow((Object)"_ label.global.attributes", HA.name("attributes").rows(8).cols(75).attr("data-codemirror-mode", "attributes"), new AttributesText(ficheMeta.getAttributes()))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printImageToIllustrationBox(HtmlPrinter hp, CommandBox commandBox, Corpus corpus, BdfServer bdfServer, Lang lang) {
        ArrayList<CorpusField> imageFieldList = new ArrayList<CorpusField>();
        CorpusMetadata corpusMetadata = corpus.getCorpusMetadata();
        for (CorpusField corpusField : corpusMetadata.getPropList()) {
            switch (corpusField.getFicheItemType()) {
                case "item": 
                case "image": {
                    imageFieldList.add(corpusField);
                    break;
                }
            }
        }
        if (imageFieldList.isEmpty()) {
            return false;
        }
        UiComponents uiComponents = bdfServer.getUiManager().getMainUiComponents(corpus);
        List<SubsetIncludeUi> albumIncludeList = UiUtils.getSubsetIncludeUiList(uiComponents, (short)5);
        if (albumIncludeList.isEmpty()) {
            return false;
        }
        commandBox = commandBox.derive("ImageToIllustration", "_ CRP-26").__(CommandBoxUtils.insert(corpus)).submitLocKey("_ submit.corpus.imagetoillustration");
        hp.__start(commandBox).__(Grid.START).__(Grid.selectRow((Object)"_ label.corpus.imagefield", hp.name("field"), () -> {
            for (CorpusField corpusField : imageFieldList) {
                hp.__(CorpusCommandBoxUtils.printFieldKeySelectOption(hp, corpusField, lang));
            }
        })).__(Grid.selectRow((Object)"_ title.corpus.albuminclude_list", hp.name("albuminclude"), () -> {
            for (IncludeUi includeUi : albumIncludeList) {
                String value = includeUi.getName();
                String labelString = L10nUtils.getIncludeTitle(bdfServer, includeUi, lang);
                labelString = labelString != null ? " " + labelString : "";
                hp.OPTION(value, false).__escape('[').__escape(value).__escape(']').__escape(labelString)._OPTION();
            }
        })).__(Grid.textInputRow("_ label.corpus.baseurl", hp.name("baseurl").size("30"))).__(Grid.choiceSetRow((Object)"_ label.global.runmode", () -> hp.__(Grid.radioCell("_ label.global.runmode_test", HA.name("mode").value("test").checked(true))).__(Grid.radioCell("_ label.global.runmode_run", HA.name("mode").value("run").checked(false))))).__(Grid.END).__end(commandBox);
        return true;
    }

    private static boolean printSatelliteFicheWarning(HtmlPrinter hp, FicheMeta master, String warningKey, Lang workingLang, Locale formatLocale) {
        ArrayList<FicheMeta> satelliteList = new ArrayList<FicheMeta>();
        int ficheid = master.getId();
        for (Corpus satelliteCorpus : master.getCorpus().getSatelliteCorpusList()) {
            FicheMeta satelliteFicheMeta = satelliteCorpus.getFicheMetaById(ficheid);
            if (satelliteFicheMeta == null) continue;
            satelliteList.add(satelliteFicheMeta);
        }
        if (satelliteList.isEmpty()) {
            return false;
        }
        Fiches fiches = FichesBuilder.init().addAll(satelliteList).toFiches();
        hp.P("global-Warning").__localize(warningKey)._P().UL("command-fiches-List");
        for (Fiches.Entry entry : fiches.getEntryList()) {
            Corpus corpus = entry.getCorpus();
            hp.LI().P().__(SubsetTitle.init(corpus, workingLang).subsetIcon(true))._P().__(FICHES_TREE, () -> {
                for (FicheMeta ficheMeta : entry.getFicheMetaList()) {
                    hp.__(Tree.LEAF, () -> hp.SPAN("command-fiches-Fiche").__escape(CorpusMetadataUtils.getFicheTitle(ficheMeta, workingLang, formatLocale))._SPAN());
                }
            })._LI();
        }
        hp._UL();
        return true;
    }

    private static boolean printSatelliteOpportunities(HtmlPrinter hp, BdfServer bdfServer, Lang workingLang) {
        hp.__(Grid.choiceSetRow((Object)"_ label.corpus.corpustype", () -> {
            List<Corpus> corpusList;
            hp.__(Grid.radioCell("_ label.corpus.corpustype_standard", hp.name("corpustype").value("standard").checked(true)));
            if (bdfServer.getFichotheque().getThesaurusList().size() > 0) {
                SubsetTree thesaurusTree = bdfServer.getTreeManager().getSubsetTree((short)2);
                hp.__(Grid.radioCell((Object)"_ label.corpus.corpustype_thesaurussatellite", hp.name("corpustype").value("thesaurussatellite").checked(false), () -> hp.__(Grid.START).__(Grid.selectRow((Object)"_ label.global.thesaurus", hp.name("masterthesaurus"), SubsetTreeOptions.init(thesaurusTree, bdfServer, workingLang).onlyNames(true).withKeys(true))).__(Grid.END)));
            }
            if (!(corpusList = bdfServer.getFichotheque().getCorpusList()).isEmpty()) {
                HashSet<SubsetKey> noSatelliteSet = new HashSet<SubsetKey>();
                for (Corpus corpus : corpusList) {
                    if (corpus.getMasterSubset() != null) continue;
                    noSatelliteSet.add(corpus.getSubsetKey());
                }
                if (!noSatelliteSet.isEmpty()) {
                    SubsetTree corpusTree = TreeFilterEngine.selection(noSatelliteSet, bdfServer.getTreeManager().getSubsetTree((short)1));
                    hp.__(Grid.radioCell((Object)"_ label.corpus.corpustype_corpussatellite", hp.name("corpustype").value("corpussatellite").checked(false), () -> hp.__(Grid.START).__(Grid.selectRow((Object)"_ label.global.corpus", hp.name("mastercorpus"), SubsetTreeOptions.init(corpusTree, bdfServer, workingLang).onlyNames(true).withKeys(true))).__(Grid.END)));
                }
            }
        }));
        return true;
    }

    private static boolean printCorpusFieldList(HtmlPrinter hp, List<CorpusField> corpusFieldList, String titleKey, Langs langs, Lang lang) {
        if (corpusFieldList.isEmpty()) {
            return false;
        }
        hp.H2().__localize(titleKey)._H2().DL("global-DL");
        for (CorpusField corpusField : corpusFieldList) {
            hp.DT().__(BdfHtmlUtils.printCodeMirrorSpan(hp, corpusField, lang))._DT().DD().__(Grid.START).__(LangRows.init(corpusField.getFieldString() + "/", corpusField.getLabels(), langs).cols(30)).__(Grid.END)._DD();
        }
        hp._DL();
        return true;
    }

    private static boolean printFieldTypeSelectRow(HtmlPrinter hp, short fieldCategory) {
        if (!FieldCreationCommand.isWithTypeSelect(fieldCategory)) {
            return false;
        }
        hp.__(Grid.selectRow((Object)"_ label.corpus.ficheitemtype", hp.name("ficheitemtype"), () -> hp.OPTION("", true).__escape("---")._OPTION().__(CorpusCommandBoxUtils.printFicheItemTypeOption(hp, "item")).__(CorpusCommandBoxUtils.printFicheItemTypeOption(hp, "person")).__(CorpusCommandBoxUtils.printFicheItemTypeOption(hp, "language")).__(CorpusCommandBoxUtils.printFicheItemTypeOption(hp, "country")).__(CorpusCommandBoxUtils.printFicheItemTypeOption(hp, "date")).__(CorpusCommandBoxUtils.printFicheItemTypeOption(hp, "link")).__(CorpusCommandBoxUtils.printFicheItemTypeOption(hp, "email")).__(CorpusCommandBoxUtils.printFicheItemTypeOption(hp, "number")).__(CorpusCommandBoxUtils.printFicheItemTypeOption(hp, "amount")).__(CorpusCommandBoxUtils.printFicheItemTypeOption(hp, "geopoint")).__(CorpusCommandBoxUtils.printFicheItemTypeOption(hp, "para")).__(CorpusCommandBoxUtils.printFicheItemTypeOption(hp, "image"))));
        return true;
    }

    private static boolean printFicheItemTypeOption(HtmlPrinter hp, String ficheItemType) {
        hp.OPTION(ficheItemType, false).__localize(CorpusHtmlUtils.getFicheItemMessageKey(ficheItemType)).__space().__escape('[').__escape(ficheItemType).__escape(']')._OPTION();
        return true;
    }

    private static boolean printCroisementNodeList(HtmlPrinter hp, BdfServer bdfServer, List<SubsetTree.Node> nodeList, Lang workingLang, String paramName) {
        for (SubsetTree.Node node : nodeList) {
            hp.LI();
            if (node instanceof GroupNode) {
                hp.P("corpus-croisement-GroupTitle").__escape(TreeUtils.getTitle(bdfServer, (GroupNode)node, workingLang))._P().UL("corpus-croisement-GroupList").__(CorpusCommandBoxUtils.printCroisementNodeList(hp, bdfServer, ((GroupNode)node).getSubnodeList(), workingLang, paramName))._UL();
            } else {
                CroisementSubsetNode subsetNode = (CroisementSubsetNode)node;
                Subset subset = subsetNode.getSubset();
                hp.P("corpus-croisement-SubsetTitle").__(SubsetTitle.init(subset, workingLang).subsetIcon(true))._P().__(CroisementSelection.TREE, () -> {
                    for (Croisements.Entry entry : subsetNode.getCroisements().getEntryList()) {
                        SubsetItem subsetItem = entry.getSubsetItem();
                        String globalId = subsetItem.getGlobalId();
                        String name = subsetItem instanceof Illustration ? ((Illustration)subsetItem).getFileName() : (subsetItem instanceof Document ? AddendaUtils.toTitle((Document)subsetItem) : "");
                        HtmlAttributes inputAttributes = hp.name(paramName).value(globalId);
                        hp.__(Tree.checkboxLeaf(inputAttributes, () -> hp.__escape(globalId).__dash().__escape(name)));
                    }
                });
            }
            hp._LI();
        }
        return true;
    }

    private static boolean printFieldKeySelectOptions(HtmlPrinter hp, Corpus corpus, Lang lang, boolean withNoRemoveable) {
        CorpusMetadata corpusMetadata = corpus.getCorpusMetadata();
        if (withNoRemoveable) {
            hp.__(CorpusCommandBoxUtils.printFieldKeySelectOption(hp, corpusMetadata.getCorpusField(FieldKey.TITLE), lang)).__(CorpusCommandBoxUtils.printFieldKeySelectOption(hp, corpusMetadata.getCorpusField(FieldKey.LANG), lang));
        }
        if (corpusMetadata.isWithSubtitle()) {
            hp.__(CorpusCommandBoxUtils.printFieldKeySelectOption(hp, corpusMetadata.getCorpusField(FieldKey.SUBTITLE), lang));
        }
        if (withNoRemoveable) {
            hp.__(CorpusCommandBoxUtils.printFieldKeySelectOption(hp, corpusMetadata.getCorpusField(FieldKey.OWNERS), lang));
        }
        for (CorpusField corpusField : corpusMetadata.getPropList()) {
            hp.__(CorpusCommandBoxUtils.printFieldKeySelectOption(hp, corpusField, lang));
        }
        for (CorpusField corpusField : corpusMetadata.getInfoList()) {
            hp.__(CorpusCommandBoxUtils.printFieldKeySelectOption(hp, corpusField, lang));
        }
        for (CorpusField corpusField : corpusMetadata.getSectionList()) {
            hp.__(CorpusCommandBoxUtils.printFieldKeySelectOption(hp, corpusField, lang));
        }
        return true;
    }

    private static boolean printSectionSelectOptions(HtmlPrinter hp, Corpus corpus, Lang lang) {
        CorpusMetadata corpusMetadata = corpus.getCorpusMetadata();
        for (CorpusField corpusField : corpusMetadata.getSectionList()) {
            hp.__(CorpusCommandBoxUtils.printFieldKeySelectOption(hp, corpusField, lang));
        }
        return true;
    }

    private static boolean printFieldKeySelectOption(HtmlPrinter hp, CorpusField corpusField, Lang lang) {
        hp.OPTION(corpusField.getFieldString(), false).__escape(CorpusMetadataUtils.getFieldTitle(corpusField, lang, true))._OPTION();
        return true;
    }

    private static boolean printCategorySelectOptions(HtmlPrinter hp) {
        hp.OPTION("prop", true).__localize("_ label.corpus.category_prop")._OPTION().OPTION("info", false).__localize("_ label.corpus.category_info")._OPTION().OPTION("section", false).__localize("_ label.corpus.category_section")._OPTION();
        return true;
    }

    private static boolean printComponentUiDt(HtmlPrinter hp, Corpus corpus, UiComponent uiComponent, BdfServer bdfServer, Lang lang) {
        hp.DT();
        if (uiComponent instanceof FieldUi) {
            CorpusField corpusField = corpus.getCorpusMetadata().getCorpusField(((FieldUi)uiComponent).getFieldKey());
            if (corpusField != null) {
                BdfHtmlUtils.printCodeMirrorSpan(hp, corpusField, lang);
            } else {
                hp.__escape(((FieldUi)uiComponent).getFieldString());
            }
        } else if (uiComponent instanceof SpecialIncludeUi) {
            BdfHtmlUtils.printCodeMirrorSpan(hp, (SpecialIncludeUi)uiComponent, bdfServer, lang);
        } else if (uiComponent instanceof SubsetIncludeUi) {
            BdfHtmlUtils.printCodeMirrorSpan(hp, (SubsetIncludeUi)uiComponent, bdfServer, lang);
        } else if (uiComponent instanceof CommentUi) {
            BdfHtmlUtils.printCodeMirrorSpan(hp, (CommentUi)uiComponent, lang);
        } else if (uiComponent instanceof DataUi) {
            BdfHtmlUtils.printCodeMirrorSpan(hp, (DataUi)uiComponent, lang);
        } else {
            hp.__escape(uiComponent.getName());
        }
        hp._DT();
        return true;
    }

    private static boolean printOptions(HtmlPrinter hp, String name, UiComponent uiComponent, boolean blockField) {
        String status = uiComponent.getStatus();
        hp.__(Grid.START);
        if (uiComponent.isModifiableStatus()) {
            hp.__(Grid.selectRow((Object)"_ label.corpus.componentstatus", hp.name(name + "|status"), () -> {
                for (SelectOption option : STATUS_OPTIONS) {
                    hp.__(option, status);
                }
            }));
        }
        if (uiComponent.isRelevantOption("includeVariant")) {
            String currentValue = uiComponent.getOptionValue("includeVariant");
            hp.__(Grid.selectRow((Object)"_ label.corpus.includevariant", hp.name(name + "|variant"), () -> {
                for (SelectOption option : VARIANT_OPTIONS) {
                    hp.__(option, currentValue);
                }
            }));
        }
        String conditionalId = null;
        if (uiComponent.isRelevantOption("inputType")) {
            conditionalId = hp.generateId();
            String currentValue = uiComponent.getOptionValue("inputType", "text");
            hp.__(Grid.selectRow((Object)"_ label.corpus.inputtype", hp.name(name + "|input").id(conditionalId), () -> {
                for (SelectOption option : INPUTTYPE_OPTIONS) {
                    hp.__(option, currentValue);
                }
            }));
        }
        if (uiComponent.isRelevantOption("inputWidth")) {
            HtmlAttributes selectAttributes = hp.name(name + "|width");
            if (conditionalId != null) {
                CorpusCommandBoxUtils.populateTypeConditional(selectAttributes, conditionalId);
            }
            String currentWidthType = FicheFormUtils.getWidth(uiComponent);
            hp.__(Grid.selectRow((Object)"_ label.corpus.size", selectAttributes, () -> {
                for (SelectOption option : WIDTHTYPE_OPTIONS) {
                    hp.__(option, currentWidthType);
                }
            }));
        }
        if (uiComponent.isRelevantOption("inputRows")) {
            HtmlAttributes inputAttributes = hp.name(name + "|rows").value(String.valueOf(FicheFormUtils.getRows(uiComponent))).size("3");
            if (conditionalId != null) {
                CorpusCommandBoxUtils.populateTypeConditional(inputAttributes, conditionalId);
            }
            hp.__(Grid.textInputRow("_ label.corpus.rows", inputAttributes));
        }
        if (uiComponent.isRelevantOption("defaultValue")) {
            String defaultValue = uiComponent.getOptionValue("defaultValue");
            if (defaultValue.indexOf(10) > -1) {
                blockField = true;
            }
            if (blockField) {
                hp.__(Grid.textAreaInputRow((Object)"_ label.corpus.defaulvalue", hp.name(name + "|default").value(defaultValue).rows(4).cols(50).classes("command-LargeInput"), () -> hp.__escape(defaultValue, true)));
            } else {
                hp.__(Grid.textInputRow("_ label.corpus.defaulvalue", hp.name(name + "|default").value(defaultValue).size("40")));
            }
        }
        hp.__(Grid.END);
        return true;
    }

    private static void populateTypeConditional(HtmlAttributes htmlAttributes, String conditionalId) {
        htmlAttributes.attr("data-conditional-source", conditionalId).attr("data-conditional-values", "text").attr("data-conditional-parent", ".grid-Row");
    }

    private static boolean printCommentLocationRadioList(HtmlPrinter hp, int position) {
        hp.__(Grid.choiceSetRow((Object)"_ label.corpus.commentlocation", () -> hp.__(Grid.radioCell("_ label.corpus.commentlocation_form", hp.name("location").value("form").checked(position == 1))).__(Grid.radioCell("_ label.corpus.commentlocation_template", hp.name("location").value("template").checked(position == 2))).__(Grid.radioCell("_ label.corpus.commentlocation_both", hp.name("location").value("both").checked(position == 3)))));
        return true;
    }

    private static String getMasterL10nKey(short subsetCategory) {
        switch (subsetCategory) {
            case 1: {
                return "_ label.corpus.masterinclude_fiche";
            }
        }
        return "_ label.corpus.masterinclude_motcle";
    }

    private static class DiscardText
    implements Consumer<HtmlPrinter> {
        private final FicheMeta ficheMeta;

        private DiscardText(FicheMeta ficheMeta) {
            this.ficheMeta = ficheMeta;
        }

        @Override
        public void accept(HtmlPrinter hp) {
            BdfHtmlUtils.printAttributeToText(hp, this.ficheMeta.getAttributes().getAttribute(BdfSpace.DISCARDTEXT_KEY));
        }
    }
}

