/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.album;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfHtmlUtils;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.htmlproducers.album.AlbumCommandBoxUtils;
import fr.exemole.bdfserver.htmlproducers.album.AlbumHtmlUtils;
import java.util.List;
import net.fichotheque.album.Album;
import net.fichotheque.album.metadata.AlbumDim;
import net.mapeadores.util.html.CommandBox;

public class AlbumMetadataFormHtmlProducer
extends BdfServerHtmlProducer {
    private final Album album;

    public AlbumMetadataFormHtmlProducer(BdfParameters bdfParameters, Album album) {
        super(bdfParameters);
        this.album = album;
        this.addJsLib(BdfJsLibs.COMMANDTEST);
        this.addJsLib(BdfJsLibs.COMMANDVEIL);
        this.addJsLib(BdfJsLibs.SUBSETCHANGE);
        this.addThemeCss("album.css");
    }

    @Override
    public void printHtml() {
        this.start();
        BdfHtmlUtils.printSubsetHeader(this, this.bdfParameters, this.album, "album-metadataform");
        AlbumHtmlUtils.printAlbumToolbar(this, "album-metadataform", this.album);
        this.printCommandMessageUnit();
        CommandBox commandBox = CommandBox.init().action("album").family("ALB").veil(true).page("album-metadataform");
        AlbumCommandBoxUtils.printAlbumPhrasesBox(this, commandBox, this.album, this.bdfServer);
        List<AlbumDim> albumDimList = this.album.getAlbumMetadata().getAlbumDimList();
        if (!albumDimList.isEmpty()) {
            this.__(PageUnit.start("_ title.album.albumdim_list")).DL("global-DL").__(this.printAlbumDimDL(albumDimList, commandBox.mode("subunit")))._DL().__(PageUnit.END);
            commandBox.mode("");
        }
        AlbumCommandBoxUtils.printAlbumDimCreationBox(this, commandBox, this.album);
        this.end();
    }

    private boolean printAlbumDimDL(List<AlbumDim> albumDimList, CommandBox commandBox) {
        for (AlbumDim albumDim : albumDimList) {
            this.DT().__escape(albumDim.getName()).__escape(" / ").__localize(AlbumHtmlUtils.getAlbumDimMessageKey(albumDim.getDimType()))._DT().DD().__(this.printAlbumDimChangeDetails(albumDim, commandBox)).__(this.printAlbumDimRemoveDetails(albumDim, commandBox))._DD();
        }
        return true;
    }

    private boolean printAlbumDimChangeDetails(AlbumDim albumDim, CommandBox commandBox) {
        this.DETAILS("command-Details").SUMMARY().__localize("_ link.global.change")._SUMMARY().__(AlbumCommandBoxUtils.printAlbumDimChangeBox(this, commandBox, albumDim))._DETAILS();
        return true;
    }

    private boolean printAlbumDimRemoveDetails(AlbumDim albumDim, CommandBox commandBox) {
        this.DETAILS("command-Details").SUMMARY().__localize("_ link.global.delete")._SUMMARY().__(AlbumCommandBoxUtils.printAlbumDimRemoveBox(this, commandBox, albumDim))._DETAILS();
        return true;
    }
}

