/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.administration;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.interaction.Domain;
import fr.exemole.bdfserver.api.menu.ActionEntry;
import fr.exemole.bdfserver.api.menu.ActionGroup;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.Tree;
import fr.exemole.bdfserver.html.consumers.attributes.Deploy;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.tools.BH;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import java.util.List;
import net.fichotheque.exportation.balayage.BalayageDescription;
import net.fichotheque.permission.PermissionSummary;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.localisation.Message;

public class IndexHtmlProducer
extends BdfServerHtmlProducer {
    private final Button linkButton = Button.link();
    private final PermissionSummary permissionSummary;

    public IndexHtmlProducer(BdfParameters bdfParameters) {
        super(bdfParameters);
        this.permissionSummary = bdfParameters.getPermissionSummary();
        this.addJsLib(BdfJsLibs.DEPLOY);
        this.addThemeCss("administration.css");
        this.addThemeCssForAction("admin");
        this.setMainStorageKey("main", "index");
    }

    @Override
    public void printHtml() {
        this.start();
        this.printCommandMessageUnit();
        this.__(this.printConfigurationGroup()).__(this.printRightsGroup()).__(this.printReportingGroup()).__(this.printCustomizationGroup()).__(this.printImportationGroup()).__(this.printExportationGroup()).__(this.printBalayageGroup()).__(this.printExtensionGroups());
        this.end();
    }

    private boolean printConfigurationGroup() {
        if (!this.permissionSummary.isFichothequeAdmin()) {
            return false;
        }
        boolean withExtensions = !this.bdfServer.getExtensionManager().getBdfExtensionReferenceList().isEmpty();
        this.__(this.startGroup("group_configuration", "_ title.administration.configurationlinks")).__(this.link("action-Core", BH.domain("configuration").page("config-core"), "_ link.configuration.core")).__(this.link("action-Labels", BH.domain("configuration").page("config-phrases"), "_ link.configuration.phrasesform")).__(this.link("action-Logos", BH.domain("configuration").page("config-logos"), "_ link.configuration.logosform")).__(this.link("action-Groups", BH.domain("configuration").page("config-groups"), "_ link.configuration.groupform")).__(this.link("action-SubsetTrees", BH.domain("configuration").page("config-subsettree"), "_ link.configuration.subsettreeform")).__if(withExtensions, this.link("action-Extensions", BH.domain("configuration").page("config-extensions"), "_ link.configuration.extensionsform")).__(this.link("action-Advanced", BH.domain("configuration").page("config-advancedcommands"), "_ link.configuration.advancedcommands")).__(this.link("action-EtcConfig", BH.domain("configuration").page("config-etc"), "_ link.configuration.etcconfig")).__(this.endGroup());
        return true;
    }

    private boolean printRightsGroup() {
        if (!this.permissionSummary.isFichothequeAdmin()) {
            return false;
        }
        this.__(this.startGroup("group_rights", "_ title.administration.rightslinks")).__(this.paneLink("action-Roles", "administration", "roles", "_ link.administration.roleadmin")).__(this.link("action-Ods", "users/_all.ods", "_ link.administration.rolesummary_all", "Edition")).__(this.endGroup());
        return true;
    }

    private boolean printReportingGroup() {
        if (!this.permissionSummary.isFichothequeAdmin()) {
            return false;
        }
        boolean withLog = !this.bdfServer.getInitLogs().isEmpty();
        this.__(this.startGroup("group_reporting", "_ title.administration.reportinglinks")).__if(withLog, this.link("action-Logs", BH.domain("administration").page("initlog"), "_ title.administration.storageprocesslog")).__(this.link("action-Stats", BH.domain("misc").page("globalstats"), "_ title.misc.globalstats")).__(this.link("action-Diagrams", BH.domain("misc").page("diagrams"), "_ title.misc.diagrams")).__(this.link("action-Sessions", BH.domain("administration").page("sessionlist"), "_ title.administration.sessionlist")).__(this.link("action-Backup", BH.domain("administration").page("backup"), "_ link.administration.backup")).__(this.paneLink("action-Diagnostic", "administration", "diagnostic", "_ link.administration.diagnostic")).__(this.endGroup());
        return true;
    }

    private boolean printCustomizationGroup() {
        if (!this.permissionSummary.isFichothequeAdmin()) {
            return false;
        }
        if (!this.isWithJavascript()) {
            return false;
        }
        this.__(this.startGroup("group_customization", "_ title.administration.customizationlinks")).__(this.paneLink("action-Resources", "administration", "resources", "_ link.administration.resourceadmin")).__(this.paneLink("action-Transformations", "exportation", "transformations", "_ link.exportation.transformationadmin")).__(this.endGroup());
        return true;
    }

    private boolean printImportationGroup() {
        if (!this.permissionSummary.isFichothequeAdmin()) {
            return false;
        }
        this.__(this.startGroup("group_importation", "_ title.administration.importationlinks")).__(this.link("action-Corpus", BH.domain("importation").page("corpusimport"), "_ title.importation.corpusimport")).__(this.link("action-Thesaurus", BH.domain("importation").page("thesaurusimport"), "_ title.importation.thesaurusimport")).__(this.link("action-Labels", BH.domain("importation").page("labelimport"), "_ title.importation.labelimport")).__(this.endGroup());
        return true;
    }

    private boolean printExportationGroup() {
        if (!this.permissionSummary.isFichothequeAdmin()) {
            return false;
        }
        if (!this.isWithJavascript()) {
            return false;
        }
        this.__(this.startGroup("group_exportation", "_ title.administration.exportationlinks")).__(this.paneLink("action-Selection", "selection", "defs", "_ link.selection.selectiondefadmin")).__(this.paneLink("action-TableExports", "exportation", "tableexports", "_ link.exportation.tableexportadmin")).__(this.paneLink("action-Accesses", "exportation", "accesses", "_ link.exportation.accessadmin")).__(this.paneLink("action-ScrutariExports", "exportation", "scrutariexports", "_ link.exportation.scrutariexportadmin")).__(this.paneLink("action-SqlExports", "exportation", "sqlexports", "_ link.exportation.sqlexportadmin")).__(this.paneLink("action-Balayages", "exportation", "balayages", "_ link.exportation.balayageadmin")).__(this.endGroup());
        return true;
    }

    private boolean printBalayageGroup() {
        if (!this.permissionSummary.canDo("balayagerun")) {
            return false;
        }
        List<BalayageDescription> balayageDefList = this.bdfServer.getBalayageManager().getBalayageDescriptionList();
        if (balayageDefList.isEmpty()) {
            return false;
        }
        Button balayageLink = Button.link().target("Edition").action("action-Run");
        this.__(this.startGroup("group_balayage", "_ title.exportation.balayageindex", "administration-Balayages")).__(Tree.TREE, () -> {
            for (BalayageDescription balayageDescription : balayageDefList) {
                String balayageName = balayageDescription.getName();
                this.__(Tree.LEAF, () -> this.__(balayageLink.text(balayageName).tooltipMessage("_ link.exportation.balayagerun_long", balayageName).href(BH.domain("exportation").page("balayage-result").command("BalayageRun").pageErr("balayage-error").balayage(balayageName))));
            }
        }).__(this.endGroup());
        return true;
    }

    private boolean printExtensionGroups() {
        if (!this.permissionSummary.isFichothequeAdmin()) {
            return false;
        }
        for (ActionGroup actionGroup : BdfServerUtils.getExtensionActionGroupList("admin", this.bdfServer, this.bdfUser)) {
            this.DETAILS(HA.id("group_ext_" + actionGroup.getId()).classes("administration-Group").populate(Deploy.DETAILS)).SUMMARY().__(this.printTitle(actionGroup.getTitle()))._SUMMARY().DIV("administration-List");
            for (ActionEntry actionEntry : actionGroup.getActionEntryList()) {
                String target = actionEntry.getTarget();
                if (target == null) {
                    target = "Edition";
                }
                this.A(HA.href(actionEntry.getUrl()).target(target).classes("global-button-Link " + actionEntry.getCssName())).__(Button.ICON).SPAN("global-button-Text").__(this.printTitle(actionEntry.getTitle()))._SPAN()._A();
            }
            this.__(this.endGroup());
        }
        return true;
    }

    private Button link(String action, CharSequence href, String messageKey) {
        return this.link(action, href, messageKey, "Edition");
    }

    private Button link(String action, CharSequence href, String messageKey, String target) {
        return this.linkButton.href(href.toString()).action(action).textL10nObject(messageKey).target(target);
    }

    private Button paneLink(String action, String domain, String page, String messageKey) {
        if (!this.isWithJavascript()) {
            return null;
        }
        return this.linkButton.href(Domain.getCompleteDomain(domain, page)).action(action).textL10nObject(messageKey).target("_blank");
    }

    private boolean startGroup(String id, String summaryKey) {
        return this.startGroup(id, summaryKey, null);
    }

    private boolean startGroup(String id, String summaryKey, String supplementaryClasses) {
        String classes = "administration-Group";
        if (supplementaryClasses != null) {
            classes = classes + " " + supplementaryClasses;
        }
        this.DETAILS(HA.id(id).classes(classes).populate(Deploy.DETAILS)).SUMMARY().__localize(summaryKey)._SUMMARY().DIV("administration-List");
        return true;
    }

    private boolean printTitle(Object titleObject) {
        if (titleObject instanceof Message) {
            this.__localize((Message)titleObject);
        } else {
            this.__escape(titleObject.toString());
        }
        return true;
    }

    private boolean endGroup() {
        this._DIV()._DETAILS();
        return true;
    }
}

