/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.administration;

import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.administration.BackupHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.administration.BackupResultHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.administration.DiagnosticHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.administration.IndexHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.administration.InitLogHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.administration.ResourceUploadHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.administration.ResourcesHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.administration.RolesHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.administration.SessionListHtmlProducer;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.instruction.OutputRequestHandler;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.text.RelativePath;

public final class AdministrationHtmlProducerFactory {
    private AdministrationHtmlProducerFactory() {
    }

    public static BdfServerHtmlProducer getHtmlProducer(OutputParameters parameters) throws ErrorMessageException {
        String page;
        OutputRequestHandler requestHandler = OutputRequestHandler.init(parameters);
        switch (page = parameters.getOutput()) {
            case "index": {
                return new IndexHtmlProducer(parameters);
            }
            case "backup": {
                parameters.checkFichothequeAdmin();
                return new BackupHtmlProducer(parameters);
            }
            case "backupresult": {
                parameters.checkFichothequeAdmin();
                String backupFileName = (String)parameters.getResultObject("obj.backupfilename");
                if (backupFileName == null) {
                    throw BdfErrors.missingCommandResultPage("backupresult");
                }
                return new BackupResultHtmlProducer(parameters, backupFileName);
            }
            case "initlog": {
                parameters.checkFichothequeAdmin();
                return new InitLogHtmlProducer(parameters);
            }
            case "resources": {
                parameters.checkFichothequeAdmin();
                return new ResourcesHtmlProducer(parameters);
            }
            case "resource-upload": {
                parameters.checkFichothequeAdmin();
                RelativePath path = requestHandler.getRelativePath();
                return new ResourceUploadHtmlProducer(parameters, path);
            }
            case "roles": {
                parameters.checkFichothequeAdmin();
                return new RolesHtmlProducer(parameters);
            }
            case "sessionlist": {
                parameters.checkFichothequeAdmin();
                return new SessionListHtmlProducer(parameters);
            }
            case "diagnostic": {
                parameters.checkFichothequeAdmin();
                return new DiagnosticHtmlProducer(parameters);
            }
        }
        return null;
    }
}

