/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.html;

import fr.exemole.bdfserver.api.BdfExtensionReference;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfCommandResult;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.managers.ExtensionManager;
import fr.exemole.bdfserver.api.namespaces.UiSpace;
import fr.exemole.bdfserver.api.providers.ActionProvider;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.html.BdfHtmlHook;
import fr.exemole.bdfserver.html.BdfHtmlHookProvider;
import fr.exemole.bdfserver.html.BdfHtmlProducer;
import fr.exemole.bdfserver.html.BdfJsLibAssembly;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.tools.storage.IconScanEngine;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.fichotheque.Fichotheque;
import net.fichotheque.utils.FichothequeMetadataUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.html.CommandBox;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.html.HtmlPrinterUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangPreference;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.logging.CommandMessage;

public abstract class BdfServerHtmlProducer
extends BdfHtmlProducer {
    protected BdfServer bdfServer;
    protected BdfUser bdfUser;
    protected Lang workingLang;
    protected Locale formatLocale;
    protected LangPreference langPreference;
    protected Fichotheque fichotheque;
    protected BdfParameters bdfParameters;
    private BdfCommandResult bdfCommandResult;
    private BdfHtmlHookManager bdfHtmlHookManager;

    private BdfServerHtmlProducer(BdfServer bdfServer) {
        super(bdfServer.getJsAnalyser(), bdfServer.getBuildInfo());
        this.bdfServer = bdfServer;
        this.fichotheque = bdfServer.getFichotheque();
        this.setBodyCssClass("global-body-Default");
    }

    public BdfServerHtmlProducer(BdfServer bdfServer, LangPreference langPreference) {
        this(bdfServer);
        this.workingLang = LangsUtils.getPreferredAvailableLang(bdfServer.getLangConfiguration().getWorkingLangs(), langPreference);
        this.formatLocale = this.workingLang.toLocale();
        this.langPreference = langPreference;
        this.bdfUser = null;
        this.addMessageLocalisation(bdfServer.getL10nManager().getMessageLocalisation(langPreference));
    }

    public BdfServerHtmlProducer(BdfParameters bdfParameters) {
        this(bdfParameters.getBdfServer());
        this.bdfParameters = bdfParameters;
        this.bdfUser = bdfParameters.getBdfUser();
        this.workingLang = this.bdfUser.getWorkingLang();
        this.formatLocale = this.bdfUser.getFormatLocale();
        this.langPreference = this.bdfUser.getLangPreference();
        this.addMessageLocalisation(this.bdfServer.getL10nManager().getMessageLocalisation(this.bdfUser));
        this.setWithJavascript(BdfUserUtils.isWithJavascript(this.bdfUser));
    }

    public BdfServer getBdfServer() {
        return this.bdfServer;
    }

    public Fichotheque getFichotheque() {
        return this.fichotheque;
    }

    public BdfUser getBdfUser() {
        return this.bdfUser;
    }

    public Map<String, String> getStoredValues(String name) {
        return this.bdfServer.getStoredValues(this.bdfUser, name);
    }

    public final void addThemeCssForAction(String actionKey) {
        for (BdfExtensionReference extensionReference : this.bdfServer.getExtensionManager().getBdfExtensionReferenceList()) {
            String cssThemeFile;
            ActionProvider actionProvider = (ActionProvider)extensionReference.getImplementation(ActionProvider.class);
            if (actionProvider == null || (cssThemeFile = actionProvider.getCssThemeFile(actionKey)) == null) continue;
            this.addExtensionThemeCss(extensionReference.getRegistrationName(), cssThemeFile);
        }
    }

    public final boolean checkFontAwesome() {
        boolean present = this.bdfServer.getFichotheque().getFichothequeMetadata().getAttributes().isTrue(UiSpace.FONTAWESOME_KEY);
        if (present) {
            this.addFontAwesomeCss();
        }
        return present;
    }

    public final void scanIcons() {
        this.setSupplementaryIconAttributesList(IconScanEngine.run(this.bdfServer.getResourceStorages(), this.bdfServer.getMimeTypeResolver()));
    }

    public BdfServerHtmlProducer setBdfCommandResult(BdfCommandResult bdfCommandResult) {
        this.bdfCommandResult = bdfCommandResult;
        return this;
    }

    public BdfCommandResult getBdfCommandResult() {
        return this.bdfCommandResult;
    }

    @Override
    public CommandMessage getCommandMessage() {
        CommandMessage commandMessage = super.getCommandMessage();
        if (commandMessage != null) {
            return commandMessage;
        }
        if (this.bdfCommandResult != null) {
            return this.bdfCommandResult.getCommandMessage();
        }
        return null;
    }

    public Lang getWorkingLang() {
        return this.workingLang;
    }

    public Locale getFormatLocale() {
        return this.formatLocale;
    }

    @Override
    public HtmlPrinter __start(Object object) {
        if (object instanceof CommandBox) {
            this.startCommandBox((CommandBox)object);
            return this;
        }
        return super.__start(object);
    }

    @Override
    public HtmlPrinter __end(Object object) {
        if (object instanceof CommandBox) {
            this.endCommandBox((CommandBox)object);
            return this;
        }
        return super.__end(object);
    }

    public void start() {
        this.start(FichothequeMetadataUtils.getTitle(this.bdfServer.getFichotheque(), this.workingLang));
    }

    public void startLoc(String titleMessageKey, boolean appendToFichothequeName) {
        if (appendToFichothequeName) {
            this.start(FichothequeMetadataUtils.getTitle(this.bdfServer.getFichotheque(), this.workingLang) + " - " + this.getLocalization(titleMessageKey));
        } else {
            this.start(this.getLocalization(titleMessageKey));
        }
    }

    public void startPhrase(String phraseName) {
        String title = null;
        if (phraseName != null) {
            title = FichothequeUtils.getPhraseLabel(this.bdfServer.getFichotheque().getFichothequeMetadata().getPhrases(), phraseName, this.workingLang);
        }
        if (title == null) {
            title = FichothequeMetadataUtils.getTitle(this.bdfServer.getFichotheque(), this.workingLang);
        }
        this.start(title);
    }

    @Override
    public void start(String title) {
        if (this.isWithJavascript()) {
            this.resolveJavascript();
        }
        this.resolveCss();
        this.setIcons();
        super.start(this.langPreference.getFirstLang(), title);
    }

    public void start(String title, boolean appendToFichothequeName) {
        if (appendToFichothequeName) {
            this.start(FichothequeMetadataUtils.getTitle(this.bdfServer.getFichotheque(), this.workingLang) + " - " + title);
        } else {
            this.start(title);
        }
    }

    @Override
    public void end() {
        String log;
        BdfJsLibAssembly jsLibAssembly;
        if (this.isWithJavascript() && (jsLibAssembly = this.getJsLibAssembly()) != null) {
            jsLibAssembly.end(this, this.bdfServer.getResourceStorages(), this.bdfServer.getFichotheque(), this.bdfParameters, this.workingLang);
        }
        if (this.bdfUser != null && !(log = this.getLog()).isEmpty()) {
            this.COMMENT().__newLine().__escape(log).__newLine()._COMMENT();
        }
        super.end();
    }

    public boolean printCommandMessageUnit() {
        CommandMessage cm = this.getCommandMessage();
        if (cm != null) {
            this.__(PageUnit.SIMPLE, () -> HtmlPrinterUtils.printCommandMessage((HtmlPrinter)this, cm, "global-DoneMessage", "global-ErrorMessage"));
            return true;
        }
        return false;
    }

    public final void initHook(Class bdfHtmlProducerClass) {
        ExtensionManager extensionManager = this.bdfServer.getExtensionManager();
        for (BdfExtensionReference extensionReference : extensionManager.getBdfExtensionReferenceList()) {
            BdfHtmlHook bdfHtmlHook;
            BdfHtmlHookProvider bdfHtmlHookProvider = (BdfHtmlHookProvider)extensionReference.getImplementation(BdfHtmlHookProvider.class);
            if (bdfHtmlHookProvider == null || (bdfHtmlHook = bdfHtmlHookProvider.getBdfHtmlHook(bdfHtmlProducerClass)) == null) continue;
            if (this.bdfHtmlHookManager == null) {
                this.bdfHtmlHookManager = new BdfHtmlHookManager();
            }
            this.bdfHtmlHookManager.add(bdfHtmlHook);
        }
        if (this.bdfHtmlHookManager != null) {
            this.bdfHtmlHookManager.init(this);
        }
    }

    public void insertInclude(String insertName) {
        if (this.bdfHtmlHookManager != null) {
            this.bdfHtmlHookManager.insert(this, insertName);
        }
    }

    private boolean startCommandBox(CommandBox commandBox) {
        String commandKey = commandBox.lockey();
        if (commandKey == null) {
            throw new IllegalStateException("commandKey is null");
        }
        String unitCssClasses = commandBox.mode().equals("subunit") ? "unit-Subunit family-Border" : "unit-Unit family-Border";
        String family = commandBox.family();
        if (family != null) {
            unitCssClasses = unitCssClasses + " family-" + family;
        }
        String sectionId = this.generateId();
        String formId = this.generateId();
        HtmlAttributes sectionAttr = HA.id(sectionId).classes(unitCssClasses);
        if (commandBox.veil()) {
            sectionAttr.attr("data-veil-role", "unit");
        }
        this.SECTION(sectionAttr).HEADER("unit-Header family-Colors").H1("unit-Title command-Title family-Colors").SPAN("command-TitleText").__localize(commandKey)._SPAN().__(this.printTitleSubmitButton(commandBox, formId))._H1()._HEADER().__(this.printFormStart(commandBox, formId)).DIV("unit-Body");
        return true;
    }

    private boolean printTitleSubmitButton(CommandBox commandBox, String formId) {
        String submitMessageKey = commandBox.submitLocKey();
        if (submitMessageKey == null) {
            return false;
        }
        this.__(Button.submit().action(this.getCommandBoxActionCssClass(commandBox)).tooltipMessage(submitMessageKey).formId(formId));
        return true;
    }

    private boolean endCommandBox(CommandBox commandBox) {
        String submitMessageKey = commandBox.submitLocKey();
        if (submitMessageKey != null) {
            this.__(Button.COMMAND, Button.submit(this.getCommandBoxActionCssClass(commandBox), submitMessageKey));
        }
        this.__(this.printCommandKey(commandBox))._DIV()._FORM()._SECTION();
        return true;
    }

    private boolean printFormStart(CommandBox commandBox, String formId) {
        Map<String, String> hiddenAttributesMap;
        String errorPage;
        HtmlAttributes formAttributes = HA.action(commandBox.action()).id(formId);
        if (commandBox.multipart()) {
            formAttributes.enctype("multipart/form-data");
        }
        String submitProcess = commandBox.submitProcess();
        formAttributes.attr("data-submit-process", submitProcess);
        String target = commandBox.target();
        if (target != null) {
            formAttributes.target(target);
        }
        this.FORM_post(formAttributes);
        this.INPUT_hidden("cmd", commandBox.name());
        String page = commandBox.page();
        if (page != null) {
            this.INPUT_hidden("page", page);
        }
        if ((errorPage = commandBox.errorPage()) != null) {
            this.INPUT_hidden("page-err", errorPage);
        }
        if ((hiddenAttributesMap = commandBox.hiddenMap()) != null) {
            this.INPUT_hidden(hiddenAttributesMap);
        }
        return true;
    }

    private String getCommandBoxActionCssClass(CommandBox commandBox) {
        String actionCssClass = commandBox.actionCssClass();
        if (actionCssClass != null) {
            return actionCssClass;
        }
        return "action-Save";
    }

    private boolean printCommandKey(CommandBox commandBox) {
        String helpUrl;
        String keyString = commandBox.lockey();
        if (keyString == null || keyString.isEmpty()) {
            return false;
        }
        if (keyString.startsWith("_ ")) {
            keyString = keyString.substring(2);
        }
        if ((helpUrl = commandBox.helpUrl()) == null) {
            helpUrl = "http://www.fichotheque.net/" + keyString + ".html";
        }
        this.DIV("command-CommandKey ");
        if (helpUrl.isEmpty()) {
            this.SPAN("family-Colors").__escape(keyString)._SPAN();
        } else {
            this.A(HA.href(helpUrl).target("_blank").classes("command-HelpLink family-Colors").titleLocKey("_ info.global.commandhelp")).__escape(keyString)._A();
        }
        this._DIV();
        return true;
    }

    private static class BdfHtmlHookManager {
        private final List<BdfHtmlHook> list = new ArrayList<BdfHtmlHook>();

        private BdfHtmlHookManager() {
        }

        private void add(BdfHtmlHook bdfHtmlHook) {
            this.list.add(bdfHtmlHook);
        }

        private void init(BdfServerHtmlProducer bdfHtmlProducer) {
            for (BdfHtmlHook bdfHtmlHook : this.list) {
                bdfHtmlHook.init(bdfHtmlProducer);
            }
        }

        private void insert(BdfServerHtmlProducer bdfHtmlProducer, String insertName) {
            for (BdfHtmlHook bdfHtmlHook : this.list) {
                bdfHtmlHook.insert(bdfHtmlProducer, insertName);
            }
        }
    }
}

