/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.get.streamproducers;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import net.fichotheque.SubsetItem;
import net.fichotheque.exportation.table.SubsetTable;
import net.fichotheque.exportation.table.SumCellConverter;
import net.fichotheque.exportation.table.TableExportContext;
import net.fichotheque.tools.exportation.table.CsvTableWriter;
import net.fichotheque.tools.exportation.table.TableExportEngine;
import net.mapeadores.util.io.StreamProducer;

public class TableExportCsvProducer
implements StreamProducer {
    private final String fileName;
    private final BdfParameters bdfParameters;
    private final SubsetTable subsetTable;
    private final Collection<SubsetItem> subsetItems;
    private final String headerType;
    private final TableExportContext tableExportContext;
    private final SumCellConverter cellEngine;

    public TableExportCsvProducer(String fileName, BdfParameters bdfParameters, SubsetTable subsetTable, Collection<SubsetItem> subsetItems, String headerType, TableExportContext tableExportContext, SumCellConverter cellEngine) {
        this.fileName = fileName;
        this.bdfParameters = bdfParameters;
        this.subsetTable = subsetTable;
        this.subsetItems = subsetItems;
        this.headerType = headerType;
        this.tableExportContext = tableExportContext;
        this.cellEngine = cellEngine;
    }

    @Override
    public String getMimeType() {
        return "text/csv";
    }

    @Override
    public String getCharset() {
        return "UTF-8";
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void writeStream(OutputStream outputStream) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(outputStream, "UTF-8");){
            CsvTableWriter csvTableWriter = new CsvTableWriter(this.subsetTable.getColDefList(), writer, this.bdfParameters.getFormatLocale());
            switch (this.headerType) {
                case "columntitle": {
                    csvTableWriter.appendColumnTitleHeader(this.bdfParameters.getWorkingLang(), this.tableExportContext.getSourceLabelProvider(), this.subsetTable.getSubset());
                    break;
                }
                case "columnkey": {
                    csvTableWriter.appendColumnKeyHeader();
                }
            }
            TableExportEngine.exportSubset(this.subsetTable, csvTableWriter, this.cellEngine, this.subsetItems);
        }
    }
}

