/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.thesaurus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.croisement.CroisementChanges;
import net.fichotheque.croisement.CroisementEditor;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.tools.croisement.CroisementChangeEngine;
import net.fichotheque.tools.croisement.LienBuffer;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class SelectionIndexationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "SelectionIndexation";
    public static final String COMMANDKEY = "_ THS-22";
    public static final String ADD_PARAMSUFFIX = "ajout_";
    public static final String REMOVE_PARAMSUFFIX = "supp_";
    public static final String WEIGHT_PARAMSUFFIX = "weight_";
    private Motcle motcle;
    private List<CorpusInfo> corpusInfoList;
    private String mode;

    public SelectionIndexationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        int[] countArray;
        try (EditSession session = this.startEditSession("thesaurus", COMMANDNAME);){
            CroisementEditor croisementEditor = session.getFichothequeEditor().getCroisementEditor();
            CroisementChangeEngine croisementChangeEngine = CroisementChangeEngine.appendOrWeightReplaceEngine(this.motcle);
            for (CorpusInfo corpusInfo : this.corpusInfoList) {
                corpusInfo.run(croisementChangeEngine);
            }
            CroisementChanges croisementChanges = croisementChangeEngine.toCroisementChanges();
            croisementEditor.updateCroisements(this.motcle, croisementChanges);
            countArray = this.getCount(croisementChanges);
        }
        this.putResultObject("obj.int_array", countArray);
        this.putResultObject("obj.motcle", this.motcle);
        this.setDone("_ done.edition.selectionindexation", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.motcle = this.requestHandler.getMandatoryMotcle();
        this.mode = this.requestHandler.getMode();
        this.checkSubsetAdmin(this.motcle.getThesaurus());
        this.corpusInfoList = new ArrayList<CorpusInfo>();
        for (Corpus corpus : this.fichotheque.getCorpusList()) {
            List<FicheMeta> removeList = this.getRemoveList(corpus);
            List<LienBuffer> addList = this.getAddList(corpus, this.mode);
            if (removeList == null && addList == null) continue;
            this.corpusInfoList.add(new CorpusInfo(corpus, addList, removeList, this.mode));
        }
        if (this.corpusInfoList.isEmpty()) {
            throw BdfErrors.error("_ error.empty.selectionindexation");
        }
    }

    private List<LienBuffer> getAddList(Corpus corpus, String mode) throws ErrorMessageException {
        String[] addValues = this.requestHandler.getTokens(ADD_PARAMSUFFIX + corpus.getSubsetName());
        if (addValues.length == 0) {
            return null;
        }
        ArrayList<LienBuffer> lienBufferList = new ArrayList<LienBuffer>();
        for (String value : addValues) {
            try {
                int id = Integer.parseInt(value);
                FicheMeta ficheMeta = corpus.getFicheMetaById(id);
                if (ficheMeta == null) continue;
                lienBufferList.add(new LienBuffer(ficheMeta, mode, this.getWeight(ficheMeta)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (lienBufferList.isEmpty()) {
            return null;
        }
        return lienBufferList;
    }

    private List<FicheMeta> getRemoveList(Corpus corpus) throws ErrorMessageException {
        String[] removeValues = this.requestHandler.getTokens(REMOVE_PARAMSUFFIX + corpus.getSubsetName());
        if (removeValues.length == 0) {
            return null;
        }
        ArrayList<FicheMeta> removeList = new ArrayList<FicheMeta>();
        for (String value : removeValues) {
            try {
                int id = Integer.parseInt(value);
                FicheMeta ficheMeta = corpus.getFicheMetaById(id);
                if (ficheMeta == null) continue;
                removeList.add(ficheMeta);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (removeList.isEmpty()) {
            return null;
        }
        return removeList;
    }

    private int getWeight(FicheMeta ficheMeta) throws ErrorMessageException {
        String param = this.requestHandler.getTrimedParameter(WEIGHT_PARAMSUFFIX + ficheMeta.getSubsetName() + "_" + String.valueOf(ficheMeta.getId()));
        if (param.isEmpty()) {
            return 1;
        }
        try {
            int weight = Integer.parseInt(param);
            if (weight < 1) {
                weight = 1;
            }
            return weight;
        }
        catch (NumberFormatException nfe) {
            return 1;
        }
    }

    private int[] getCount(CroisementChanges croisementChanges) {
        int addCount = 0;
        int removeCount = 0;
        for (CroisementChanges.Entry entry : croisementChanges.getEntryList()) {
            if (entry.getCroisementChange().getChangedLienList().isEmpty()) {
                ++removeCount;
                continue;
            }
            ++addCount;
        }
        int[] result = new int[]{addCount, removeCount};
        return result;
    }

    public static String getAddParamName(String corpusName) {
        return ADD_PARAMSUFFIX + corpusName;
    }

    public static String getWeightParamName(String corpusName, String ficheId) {
        return WEIGHT_PARAMSUFFIX + corpusName + "_" + ficheId;
    }

    public static String getRemoveParamName(String corpusName) {
        return REMOVE_PARAMSUFFIX + corpusName;
    }

    private static class CorpusInfo {
        private final Corpus corpus;
        private final List<LienBuffer> addList;
        private final List<FicheMeta> removeList;
        private final String mode;

        private CorpusInfo(Corpus corpus, List<LienBuffer> addList, List<FicheMeta> removeList, String mode) {
            this.corpus = corpus;
            this.addList = addList;
            this.removeList = removeList;
            this.mode = mode;
        }

        private void run(CroisementChangeEngine croisementChangeEngine) {
            if (this.addList != null) {
                for (LienBuffer lienBuffer : this.addList) {
                    croisementChangeEngine.addLien(lienBuffer);
                }
            }
            if (this.removeList != null) {
                for (FicheMeta ficheMeta : this.removeList) {
                    croisementChangeEngine.removeLien(ficheMeta, this.mode);
                }
            }
        }
    }
}

