/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.sphere;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.NoRemoveableSubsetException;
import net.fichotheque.SubsetKey;
import net.fichotheque.sphere.Sphere;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class SphereRemoveCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "SphereRemove";
    public static final String COMMANDKEY = "_ SPH-03";
    private Sphere sphere;

    public SphereRemoveCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        SubsetKey sphereKey = this.sphere.getSubsetKey();
        try (EditSession session = this.startEditSession("sphere", COMMANDNAME);){
            try {
                session.getFichothequeEditor().removeSphere(this.sphere);
            }
            catch (NoRemoveableSubsetException nrse) {
                throw new ShouldNotOccurException("test done before");
            }
        }
        this.putResultObject("obj.subsetkey", sphereKey);
        this.setDone("_ done.sphere.sphereremove", sphereKey.getSubsetName());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        this.sphere = this.requestHandler.getMandatorySphere();
        if (!this.checkConfirmation()) {
            throw BdfErrors.error("_ error.empty.confirmationcheck_remove");
        }
        if (!this.sphere.isRemoveable()) {
            throw BdfErrors.error("_ error.notremoveable.sphere");
        }
    }
}

