/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.EditOrigin;
import net.fichotheque.exportation.table.TableExportDescription;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class TableExportRemoveCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "TableExportRemove";
    public static final String COMMANDKEY = "_ EXP-12";
    private String tableExportName;

    public TableExportRemoveCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        EditOrigin editOrigin = this.bdfUser.newEditOrigin("exportation", COMMANDNAME);
        this.bdfServer.getTableExportManager().removeTableExport(this.tableExportName, editOrigin);
        this.setDone("_ done.exportation.tableexportremove", this.tableExportName);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        TableExportDescription tableExportDescription = this.requestHandler.getMandatoryTableExportDescription();
        if (!tableExportDescription.isEditable()) {
            throw BdfErrors.unsupportedNotEditableParameterValue("tableexport", tableExportDescription.getName());
        }
        if (!this.checkConfirmation()) {
            throw BdfErrors.error("_ error.empty.confirmationcheck_remove");
        }
        this.tableExportName = tableExportDescription.getName();
    }
}

