/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import net.fichotheque.corpus.FicheMeta;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeParser;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class FicheAttributeChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "FicheAttributeChange";
    public static final String COMMANDKEY = "_ CRP-25";
    public static final String ATTRIBUTES_PARAMNAME = "attributes";
    private FicheMeta ficheMeta;
    private AttributeChange attributeChange;

    public FicheAttributeChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            session.getFichothequeEditor().changeAttributes(this.ficheMeta, this.attributeChange);
        }
        this.putResultObject("obj.corpus", this.ficheMeta.getCorpus());
        this.putResultObject("obj.fichemeta", this.ficheMeta);
        this.setDone("_ done.global.attributechange", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.ficheMeta = this.requestHandler.getMandatoryFicheMeta();
        this.getPermissionChecker().checkWrite(this.ficheMeta);
        String attributes = this.getMandatory(ATTRIBUTES_PARAMNAME);
        this.attributeChange = AttributeParser.parse(attributes);
    }
}

