/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.BdfServerEditor;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.externalsource.ExternalSourceType;
import fr.exemole.bdfserver.api.ui.DataUi;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.externalsource.ExternalSourceUtils;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.ui.components.DataUiBuilder;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.tools.externalsource.ExternalSourceDefBuilder;
import net.fichotheque.tools.parsers.TypoParser;
import net.mapeadores.util.attr.AttributeParser;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelChange;
import net.mapeadores.util.text.LabelChangeBuilder;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.text.TypoOptions;

public class DataChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "DataChangeCommand";
    public static final String COMMANDKEY = "_ CRP-34";
    public static final String NAME_PARAMNAME = "name";
    public static final String TITLE_PARAMPREFIX = "title/";
    public static final String PARAM_PARAMPREFIX = "param_";
    public static final String ATTRIBUTES_PARAMNAME = "attributes";
    private Corpus corpus;
    private UiComponents uiComponents;
    private DataUi dataUi;
    private LabelChange labelChange;
    private String attributes;

    public DataChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        boolean done;
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            done = this.updateDataUi(session.getBdfServerEditor(), this.dataUi);
        }
        this.putResultObject("obj.corpus", this.corpus);
        if (done) {
            this.setDone("_ done.corpus.datachange", this.dataUi.getDataName());
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.corpus = this.requestHandler.getMandatoryCorpus();
        this.checkSubsetAdmin(this.corpus);
        String name = this.getMandatory(NAME_PARAMNAME);
        this.uiComponents = this.bdfServer.getUiManager().getMainUiComponents(this.corpus);
        this.dataUi = (DataUi)this.uiComponents.getUiComponent(DataUi.toComponentName(name));
        if (this.dataUi == null) {
            throw BdfErrors.unknownParameterValue(NAME_PARAMNAME, name);
        }
        this.labelChange = this.requestHandler.getLabelChange(TITLE_PARAMPREFIX, false);
        this.attributes = this.getMandatory(ATTRIBUTES_PARAMNAME);
    }

    private boolean updateDataUi(BdfServerEditor bdfServerEditor, DataUi dataUi) throws ErrorMessageException {
        DataUiBuilder dataUiBuilder = DataUiBuilder.init(dataUi);
        LabelChangeBuilder labelChangeBuilder = dataUiBuilder.getLabelChangeBuilder();
        for (Label label : this.labelChange.getChangedLabels()) {
            Lang currentLang = label.getLang();
            TypoOptions typoOptions = TypoOptions.getTypoOptions(currentLang.toLocale());
            String labelString = label.getLabelString();
            String checkedLabelString = TypoParser.parseTypo(labelString, typoOptions);
            if (!checkedLabelString.equals(labelString)) {
                CleanedString cleanedString = CleanedString.newInstance(checkedLabelString);
                if (cleanedString == null) {
                    labelChangeBuilder.putRemovedLang(currentLang);
                    continue;
                }
                label = LabelUtils.toLabel(currentLang, cleanedString);
            }
            labelChangeBuilder.putLabel(label);
        }
        for (Lang lang : this.labelChange.getRemovedLangList()) {
            labelChangeBuilder.putRemovedLang(lang);
        }
        ExternalSourceType externalSourceType = ExternalSourceUtils.getMatchingExternalSourceType(dataUi.getExternalSourceDef());
        ExternalSourceDefBuilder externalSourceDefBuilder = dataUiBuilder.getExternalSourceDefBuilder();
        for (ExternalSourceType.Param param : externalSourceType.getParamList()) {
            String paramName = param.getName();
            String requestParamName = PARAM_PARAMPREFIX + paramName;
            if (this.requestHandler.hasParameter(requestParamName)) {
                externalSourceDefBuilder.addParam(paramName, this.requestHandler.getMandatoryParameter(requestParamName));
                continue;
            }
            externalSourceDefBuilder.addParam(paramName, null);
        }
        AttributeParser.parse(dataUiBuilder.getAttributeChangeBuilder(), this.attributes);
        bdfServerEditor.putComponentUi(this.uiComponents, dataUiBuilder.toDataUi());
        return true;
    }
}

