/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.ui.CommentUi;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.commands.corpus.CommentChangeCommand;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.ui.components.CommentUiBuilder;
import net.fichotheque.corpus.Corpus;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class CommentCreationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "CommentCreation";
    public static final String COMMANDKEY = "_ CRP-15";
    private Corpus corpus;
    private int location;

    public CommentCreationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        boolean done;
        UiComponents uiComponents = this.bdfServer.getUiManager().getMainUiComponents(this.corpus);
        String name = this.getCommentName(uiComponents);
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            CommentUiBuilder commentUiBuilder = CommentUiBuilder.init(this.bdfServer.getUiManager().getHtmlCleaner(), name).setLocation(this.location);
            CommentChangeCommand.putHtmlString(commentUiBuilder, this.requestHandler, "comment/");
            done = session.getBdfServerEditor().putComponentUi(uiComponents, commentUiBuilder.toCommentUi());
        }
        this.putResultObject("obj.corpus", this.corpus);
        if (done) {
            this.setDone("_ done.corpus.commentcreation", name);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.corpus = this.requestHandler.getMandatoryCorpus();
        this.checkSubsetAdmin(this.corpus);
        this.location = CommentChangeCommand.getLocation(this.requestHandler, "location");
    }

    private String getCommentName(UiComponents uiComponents) {
        int number = 1;
        String name = null;
        while (uiComponents.contains(CommentUi.toComponentName(name = "c" + String.valueOf(number)))) {
            ++number;
        }
        return name;
    }
}

