/* UtilLib_Servlet - Copyright (c) 2022 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.mapeadores.util.servlets.exceptions;

import javax.servlet.http.HttpServletResponse;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.servlets.HttpAccessException;


/**
 *
 * @author Vincent Calame
 */
public class BadRequestException extends HttpAccessException {

    private final static int CODE = HttpServletResponse.SC_BAD_REQUEST;

    public BadRequestException() {
        super(CODE);
    }

    public BadRequestException(CommandMessage message) {
        super(CODE, message);
    }

    public BadRequestException(String messageKey, Object... messageValues) {
        super(CODE, LogUtils.error(messageKey, messageValues));
    }

}
