/* OdLib_Io - Copyright (c) 2020 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.mapeadores.opendocument.io.odtable;


/**
 *
 * @author Vincent Calame
 */
public class TableSettings {

    private final String tableName;
    private int horizontalSplit;
    private int fixedRows;

    public TableSettings(String tableName) {
        this.tableName = tableName;
    }

    public String tableName() {
        return tableName;
    }

    public int fixedColumns() {
        return horizontalSplit;
    }

    public TableSettings fixedColumns(int fixedColumns) {
        this.horizontalSplit = fixedColumns;
        return this;
    }

    public int fixedRows() {
        return fixedRows;
    }

    public TableSettings fixedRows(int fixedRows) {
        this.fixedRows = fixedRows;
        return this;
    }

    public static TableSettings init(String tableName) {
        return new TableSettings(tableName);
    }

}
