/* FichothequeLib_Tools - Copyright (c) 2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.importation.corpus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.importation.CorpusImport;
import net.fichotheque.tools.importation.ImportationUtils;


/**
 *
 * @author Vincent Calame
 */
public class EditCorpusImportBuilder extends CorpusImportBuilder {

    private final List<EditFicheImportBuilder> builderList = new ArrayList<EditFicheImportBuilder>();
    private final Map<Integer, EditFicheImportBuilder> ficheMap = new HashMap<Integer, EditFicheImportBuilder>();
    private final Map<Integer, EditFicheImportBuilder> builderMap = new HashMap<Integer, EditFicheImportBuilder>();

    public EditCorpusImportBuilder(Corpus corpus) {
        super(corpus, CorpusImport.EDIT_TYPE);
    }

    public EditFicheImportBuilder getEditFicheImportBuilder(FicheMeta ficheMeta) {
        int ficheId = ficheMeta.getId();
        EditFicheImportBuilder builder = ficheMap.get(ficheId);
        if (builder == null) {
            builder = new EditFicheImportBuilder(ficheId);
            ficheMap.put(ficheId, builder);
            builderList.add(builder);
        }
        return builder;
    }

    public EditFicheImportBuilder getEditFicheImportBuilder(int newId) {
        EditFicheImportBuilder builder;
        if (newId > 0) {
            builder = builderMap.get(newId);
            if (builder == null) {
                builder = new EditFicheImportBuilder(newId);
                builderList.add(builder);
                builderMap.put(newId, builder);
            }
        } else {
            builder = new EditFicheImportBuilder(-1);
            builderList.add(builder);
        }
        return builder;
    }

    @Override
    protected List<CorpusImport.FicheImport> getFicheImportList() {
        List<CorpusImport.FicheImport> finalList = new ArrayList<CorpusImport.FicheImport>();
        for (EditFicheImportBuilder builder : builderList) {
            CorpusImport.EditFicheImport ficheImport = builder.toEditFicheImport();
            finalList.add(ficheImport);
        }
        return ImportationUtils.wrap(finalList.toArray(new CorpusImport.FicheImport[finalList.size()]));
    }

    public static EditCorpusImportBuilder init(Corpus corpus) {
        return new EditCorpusImportBuilder(corpus);
    }

}
