/* BdfServer_API - Copyright (c) 2013-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.importation;

import java.util.List;


/**
 *
 * @author Vincent Calame
 */
public interface ParseResult {

    public String getType();

    public List<InitError> getInitErrorList();

    public List<InitWarning> getInitWarningList();

    public List<ParseError> getParseErrorList();

    public List<BdfError> getBdfErrorList();

    public List<ResultItem> getResultItemList();

    public String getPath();

    public default boolean isAllCorrect() {
        if (!getInitErrorList().isEmpty()) {
            return false;
        }
        if (!getInitWarningList().isEmpty()) {
            return false;
        }
        if (!getParseErrorList().isEmpty()) {
            return false;
        }
        if (!getBdfErrorList().isEmpty()) {
            return false;
        }
        return true;
    }


    public static interface InitError {

        public String getKey();

        public String getText();

    }


    public static interface InitWarning {

        public String getKey();

        public String getText();

    }


    public static interface ParseError {

        public String getRawText();

        public int getLineNumber();

    }


    public static interface BdfError {

        public String getKey();

        public String getText();

        public int getLineNumber();

    }


    public static interface ResultItem {

        public Object getKeyObject();

        public Object getValueObject();

        public int getLineNumber();

    }

}
