/* BdfServer_Multi - Copyright (c) 2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.multi.subscribe;

import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.models.PersonCore;


/**
 *
 * @author Vincent Calame
 */
public interface SubscribeManager {

    public final static String EMAIL_FROM = "subscribe.from";
    public final static String EMAIL_REPLYTO = "subscribe.replyto";
    public final static String EMAIL_BCC = "subscribe.bcc";

    public boolean isActive();

    public CommandMessage sendToken(PersonCore personCore, EmailCore emailCore, MessageLocalisation messageLocalisation, String multiRootUrl) throws ErrorMessageException;

    public SubscribeToken getSubcribeToken(String token);

}
