/* BdfServer_DirectoryStorage - Copyright (c) 2013-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.storage.directory.bdfdata;

import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.storage.directory.StorageDirectory;
import fr.exemole.bdfserver.tools.storage.StorageFile;
import java.io.File;
import java.io.IOException;
import net.fichotheque.EditOrigin;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.album.Album;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.croisement.CroisementKey;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.io.FileUtils;


/**
 *
 * @author Vincent Calame
 */
public final class Remove {

    private Remove() {
    }

    public static void removeAddenda(StorageDirectory bdfdataDirectory, SubsetKey addendaKey, EditOrigin editOrigin) {
        StorageFile metadataStorageFile = BdfdataStorageFileCatalog.addendaMetadata(bdfdataDirectory, addendaKey);
        metadataStorageFile.archiveAndDelete(editOrigin);
        deleteSubsetDir(bdfdataDirectory, addendaKey);
    }

    public static void removeAlbum(StorageDirectory bdfdataDirectory, SubsetKey albumKey, EditOrigin editOrigin) {
        StorageFile metadataStorageFile = BdfdataStorageFileCatalog.albumMetadata(bdfdataDirectory, albumKey);
        metadataStorageFile.archiveAndDelete(editOrigin);
        deleteSubsetDir(bdfdataDirectory, albumKey);
    }

    public static void removeCorpus(StorageDirectory bdfdataDirectory, SubsetKey corpusKey, Subset masterSubset, EditOrigin editOrigin) {
        SubsetKey masterSubsetKey = null;
        if (masterSubset != null) {
            masterSubsetKey = masterSubset.getSubsetKey();
        }
        StorageFile metadataStorageFile = BdfdataStorageFileCatalog.corpusMetadata(bdfdataDirectory, corpusKey, masterSubsetKey);
        metadataStorageFile.archiveAndDelete(editOrigin);
        deleteSubsetDir(bdfdataDirectory, corpusKey);
    }

    public static void removeSphere(StorageDirectory bdfdataDirectory, SubsetKey sphereKey, EditOrigin editOrigin) {
        StorageFile listStorageFile = BdfdataStorageFileCatalog.sphereList(bdfdataDirectory, sphereKey);
        listStorageFile.archiveAndDelete(editOrigin);
        StorageFile metadataStorageFile = BdfdataStorageFileCatalog.sphereMetadata(bdfdataDirectory, sphereKey);
        metadataStorageFile.archiveAndDelete(editOrigin);
        deleteSubsetDir(bdfdataDirectory, sphereKey);
    }

    public static void removeThesaurus(StorageDirectory bdfdataDirectory, SubsetKey thesaurusKey, EditOrigin editOrigin) {
        StorageFile treeStorageFile = BdfdataStorageFileCatalog.thesaurusTree(bdfdataDirectory, thesaurusKey);
        treeStorageFile.archiveAndDelete(editOrigin);
        StorageFile metadataStorageFile = BdfdataStorageFileCatalog.thesaurusMetadata(bdfdataDirectory, thesaurusKey);
        metadataStorageFile.archiveAndDelete(editOrigin);
        deleteSubsetDir(bdfdataDirectory, thesaurusKey);
    }

    public static void removeDocument(StorageDirectory bdfdataDirectory, Addenda addenda, int id, EditOrigin editOrigin) {
        SubsetKey addendaKey = addenda.getSubsetKey();
        StorageFile storageFile = BdfdataStorageFileCatalog.document(bdfdataDirectory, addendaKey, id);
        storageFile.archiveAndDelete(editOrigin);
        DocumentDirectory documentDirectory = DocumentDirectory.getDocumentDirectory(bdfdataDirectory, addendaKey, id);
        documentDirectory.delete();
    }

    public static void removeIllustration(StorageDirectory bdfdataDirectory, Album album, int id, EditOrigin editOrigin) {
        SubsetKey albumKey = album.getSubsetKey();
        StorageFile storageFile = BdfdataStorageFileCatalog.illustration(bdfdataDirectory, albumKey, id);
        storageFile.archiveAndDelete(editOrigin);
        IllustrationDirectory illustrationDirectory = IllustrationDirectory.getIllustrationDirectory(bdfdataDirectory, albumKey, id);
        illustrationDirectory.delete();
    }

    public static void removeFiche(StorageDirectory bdfdataDirectory, Corpus corpus, int id, EditOrigin editOrigin) {
        SubsetKey subsetKey = corpus.getSubsetKey();
        StorageFile ficheStorageFile = BdfdataStorageFileCatalog.fiche(bdfdataDirectory, subsetKey, id);
        ficheStorageFile.archiveAndDelete(editOrigin);
        StorageFile attributesStorageFile = BdfdataStorageFileCatalog.ficheAttributes(bdfdataDirectory, subsetKey, id);
        attributesStorageFile.archiveAndDelete(editOrigin);
        StorageFile chronoStorageFile = BdfdataStorageFileCatalog.ficheChrono(bdfdataDirectory, subsetKey, id);
        chronoStorageFile.delete();
        FicheDirectory ficheDirectory = FicheDirectory.getFicheDirectory(bdfdataDirectory, subsetKey, id);
        ficheDirectory.delete();
    }

    public static void removeMotcle(StorageDirectory bdfdataDirectory, Thesaurus thesaurus, int id, EditOrigin editOrigin) {
        StorageFile storageFile = BdfdataStorageFileCatalog.motcle(bdfdataDirectory, thesaurus.getSubsetKey(), id);
        storageFile.archiveAndDelete(editOrigin);
    }

    public static void removeRedacteur(StorageDirectory bdfdataDirectory, Sphere sphere, int id, EditOrigin editOrigin) {
        StorageFile storageFile = BdfdataStorageFileCatalog.redacteur(bdfdataDirectory, sphere.getSubsetKey(), id);
        storageFile.archiveAndDelete(editOrigin);
    }

    public static void removeCroisement(StorageDirectory bdfdataDirectory, CroisementKey croisementKey, EditOrigin editOrigin) {
        StorageFile storageFile = BdfdataStorageFileCatalog.croisement(bdfdataDirectory, croisementKey);
        storageFile.archiveAndDelete(editOrigin);
    }

    private static void deleteSubsetDir(StorageDirectory bdfdataDirectory, SubsetKey subsetKey) {
        String path = BdfdataConstants.FICHOTHEQUE + File.separator + subsetKey.getCategoryString() + File.separator + subsetKey.getSubsetName();
        File dir = bdfdataDirectory.getDataFile(path);
        try {
            if (dir.exists()) {
                FileUtils.forceDelete(dir);
            }
        } catch (IOException ioe) {
            throw new BdfStorageException(dir, ioe);
        }

    }

}
