/* FichothequeLib_Tools - Copyright (c) 2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.importation.parsers;

import net.fichotheque.corpus.Corpus;
import net.fichotheque.thesaurus.metadata.ThesaurusLangChecker;
import net.fichotheque.thesaurus.policies.PolicyProvider;
import net.fichotheque.tools.importation.ParseResultBuilder;
import net.fichotheque.tools.importation.corpus.CorpusImportBuilder;
import net.fichotheque.tools.importation.corpus.EditCorpusImportBuilder;
import net.fichotheque.tools.importation.corpus.RemoveCorpusImportBuilder;
import net.fichotheque.tools.parsers.FicheParser;
import net.mapeadores.util.exceptions.SwitchException;


/**
 *
 * @author Vincent Calame
 */
public abstract class CorpusRowParser {

    public final static String CREATION_TYPE = "creation";
    public final static String CHANGE_TYPE = "change";
    public final static String REMOVE_TYPE = "remove";

    public abstract void parseRow(int rowNumber, Row row);

    public abstract CorpusImportBuilder getCorpusImportBuilder();

    public static CorpusRowParser newInstance(String[] fieldArray, String parseType, Corpus corpus, ParseResultBuilder parseResultBuilder, FicheParser.Parameters ficheParserParameters, PolicyProvider policyProvider, ThesaurusLangChecker thesaurusLangChecker) {
        switch (parseType) {
            case CREATION_TYPE:
                return CorpusCreationRowParser.newInstance(fieldArray, new EditCorpusImportBuilder(corpus), parseResultBuilder, ficheParserParameters, policyProvider, thesaurusLangChecker);
            case CHANGE_TYPE:
                return CorpusChangeRowParser.newInstance(fieldArray, new EditCorpusImportBuilder(corpus), parseResultBuilder, ficheParserParameters, policyProvider, thesaurusLangChecker);
            case REMOVE_TYPE:
                return CorpusRemoveRowParser.newInstance(fieldArray, new RemoveCorpusImportBuilder(corpus), parseResultBuilder);
            default:
                throw new SwitchException("Unknown parse type: " + parseType);

        }
    }

    public static String checkType(String type) {
        switch (type) {
            case CREATION_TYPE:
                return CREATION_TYPE;
            case CHANGE_TYPE:
                return CHANGE_TYPE;
            case REMOVE_TYPE:
                return REMOVE_TYPE;
            default:
                throw new IllegalArgumentException("Unknown type: " + type);
        }
    }

}
