/* FichothequeLib_Import - Copyright (c) 2019-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.from.html;

import java.util.List;
import net.fichotheque.corpus.fiche.FicheBlock;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.tools.from.html.handlers.DefaultHandler;
import net.fichotheque.utils.FicheUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;


/**
 *
 * @author Vincent Calame
 */
public final class ConversionEngine {

    private ConversionEngine() {

    }

    public static FicheBlocks convertHtmlPage(String htmlPage) {
        return convertDocument(Jsoup.parse(htmlPage));
    }

    public static FicheBlocks convertHtmlFragment(String htmlFragment) {
        Document doc = Jsoup.parseBodyFragment(htmlFragment);
        return convertDocument(Jsoup.parseBodyFragment(htmlFragment));
    }

    public static FicheBlocks convertDocument(Document document) {
        Element body = document.body();
        SoupReorganizeEngine.run(body);
        List<FicheBlock> ficheBlockList = DefaultHandler.INSTANCE.convertChildNodes(body);
        return FicheUtils.toFicheBlocks(ficheBlockList);
    }

}
