/* BdfServer - Copyright (c) 2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.tools.jslib;

import java.util.List;
import java.util.Map;
import net.mapeadores.util.jslib.JsLib;
import net.mapeadores.util.text.StringUtils;


/**
 *
 * @author Vincent Calame
 */
public class JsLibConf {

    private final Map<String, String> iniMap;
    private final JsLib jsLib;
    private final List<String> pageList;

    JsLibConf(Map<String, String> iniMap, JsLib jsLib, List<String> pageList) {
        this.iniMap = iniMap;
        this.jsLib = jsLib;
        this.pageList = pageList;
    }

    public JsLib getJsLib() {
        return jsLib;
    }

    public List<String> getPageList() {
        return pageList;
    }

    public String[] getArray(String paramName) {
        String value = iniMap.get(paramName);
        if (value == null) {
            return StringUtils.EMPTY_STRINGARRAY;
        }
        return StringUtils.getTechnicalTokens(value, true);
    }

    public String getString(String paramName) {
        return iniMap.get(paramName);
    }

    public String getString(String paramName, String defaultValue) {
        String value = iniMap.get(paramName);
        if (value != null) {
            return value;
        } else {
            return defaultValue;
        }
    }

}
