/* BdfServer - Copyright (c) 2014-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.json;

import java.io.IOException;
import java.util.List;
import net.fichotheque.importation.ParseResult;
import net.mapeadores.util.json.JSONWriter;


/**
 *
 * @author Vincent Calame
 */
public final class ImportationJson {

    private ImportationJson() {

    }

    public static void properties(JSONWriter jw, ParseResult parseResult) throws IOException {
        jw.key("type")
                .value(parseResult.getType());
        jw.key("path")
                .value(parseResult.getPath());
        List<ParseResult.InitError> initErrorList = parseResult.getInitErrorList();
        if (!initErrorList.isEmpty()) {
            jw.key("initErrorArray");
            jw.array();
            for (ParseResult.InitError initError : initErrorList) {
                jw.object();
                {
                    jw.key("key")
                            .value(initError.getKey());
                    jw.key("text")
                            .value(initError.getText());
                }
                jw.endObject();
            }
            jw.endArray();
        }
        List<ParseResult.InitWarning> initWarningList = parseResult.getInitWarningList();
        if (!initWarningList.isEmpty()) {
            jw.key("initWarningArray");
            jw.array();
            for (ParseResult.InitWarning initWarning : initWarningList) {
                jw.object();
                {
                    jw.key("key")
                            .value(initWarning.getKey());
                    jw.key("text")
                            .value(initWarning.getText());
                }
                jw.endObject();
            }
            jw.endArray();
        }
        List<ParseResult.ParseError> parseErrorList = parseResult.getParseErrorList();
        if (!parseErrorList.isEmpty()) {
            jw.key("parseErrorArray");
            jw.array();
            for (ParseResult.ParseError parseError : parseErrorList) {
                jw.object();
                {
                    jw.key("line")
                            .value(parseError.getLineNumber());
                    jw.key("rawtext")
                            .value(parseError.getRawText());
                }
                jw.endObject();
            }
            jw.endArray();
        }
        List<ParseResult.BdfError> bdfErrorList = parseResult.getBdfErrorList();
        if (!bdfErrorList.isEmpty()) {
            jw.key("bdfErrorArray");
            jw.array();
            for (ParseResult.BdfError bdfError : bdfErrorList) {
                jw.object();
                {
                    jw.key("line")
                            .value(bdfError.getLineNumber());
                    jw.key("key")
                            .value(bdfError.getKey());
                    jw.key("text")
                            .value(bdfError.getText());
                }
                jw.endObject();
            }
            jw.endArray();
        }
    }

}
