/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.mapeadores.util.text.StringSplitter;

public class NearStringSplitter
implements StringSplitter {
    private static final String SEPARATOR = ". ";
    private final int near;
    private final int threshold;
    private final int backwardlimit;

    public NearStringSplitter(int near, int threshold) {
        this.near = near;
        this.threshold = threshold < near ? near : threshold;
        this.backwardlimit = Math.max(this.near * 2 - this.threshold, 50);
    }

    @Override
    public List<String> split(String text) {
        if (text.length() < this.threshold) {
            return Collections.singletonList(text);
        }
        ArrayList<String> result = new ArrayList<String>();
        this.split(text, result);
        return result;
    }

    private void split(String part, List<String> result) {
        int backwardIdx;
        int separatorIdx = part.indexOf(SEPARATOR, this.near);
        if (separatorIdx == -1) {
            int backwardIdx2 = part.lastIndexOf(SEPARATOR, this.near);
            if (backwardIdx2 > this.backwardlimit) {
                result.add(part.substring(0, backwardIdx2 + SEPARATOR.length()));
                result.add(part.substring(backwardIdx2 + SEPARATOR.length()));
            } else {
                result.add(part);
            }
            return;
        }
        String newPart = null;
        if (separatorIdx > this.threshold && (backwardIdx = part.lastIndexOf(SEPARATOR, this.near)) > this.backwardlimit) {
            newPart = this.getNewPart(part, backwardIdx, result);
        }
        if (newPart == null) {
            newPart = this.getNewPart(part, separatorIdx, result);
        }
        if (newPart.length() < this.threshold) {
            result.add(newPart);
        } else {
            this.split(newPart, result);
        }
    }

    private String getNewPart(String part, int separatorIndex, List<String> result) {
        result.add(part.substring(0, separatorIndex + SEPARATOR.length()));
        return part.substring(separatorIndex + SEPARATOR.length());
    }
}

