/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.primitives;

import net.mapeadores.util.primitives.Decimal;

public class DecimalLong {
    private DecimalLong() {
    }

    public static long toDecimalLong(int value) {
        return value * 100;
    }

    public static long toDecimalLong(long value) {
        return value * 100L;
    }

    public static long toDecimalLong(float f) {
        return DecimalLong.toDecimalLong((double)f);
    }

    public static long toDecimalLong(double d) {
        long lg;
        boolean neg = false;
        if (d < 0.0) {
            neg = true;
            d = -d;
        }
        if ((d *= 100.0) - (double)(lg = (long)Math.floor(d)) >= 0.5) {
            ++lg;
        }
        if (neg) {
            lg = -lg;
        }
        return lg;
    }

    public static Decimal toDecimal(long l) {
        long partieEntiere = l / 100L;
        int partieDecimale = (int)(l % 100L);
        byte zeroLength = 0;
        if (partieDecimale == 0) {
            zeroLength = 2;
        } else if (Math.abs(partieDecimale) < 10) {
            zeroLength = 1;
        }
        return new Decimal(partieEntiere, zeroLength, partieDecimale);
    }

    public static long toDecimalLong(Decimal decimal) {
        long lg = decimal.getPartieEntiere() * 100L;
        int partieDecimale = decimal.getPartieDecimale();
        if (partieDecimale == 0) {
            return lg;
        }
        byte zeroLength = decimal.getZeroLength();
        if (zeroLength > 2) {
            return lg;
        }
        boolean neg = false;
        if (lg < 0L) {
            lg = -lg;
            neg = true;
        }
        if (partieDecimale < 0) {
            partieDecimale = -partieDecimale;
        }
        String s = String.valueOf(partieDecimale);
        int length = s.length();
        int premierChiffre = s.charAt(0) - 48;
        int deuxiemeChiffre = 0;
        if (length > 1) {
            deuxiemeChiffre = s.charAt(1) - 48;
        }
        int troisiemeChiffre = 0;
        if (length > 2) {
            troisiemeChiffre = s.charAt(2) - 48;
        }
        switch (zeroLength) {
            case 2: {
                if (premierChiffre < 5) break;
                ++lg;
                break;
            }
            case 1: {
                lg += (long)premierChiffre;
                if (deuxiemeChiffre < 5) break;
                ++lg;
                break;
            }
            case 0: {
                lg = lg + (long)(premierChiffre * 10) + (long)deuxiemeChiffre;
                if (troisiemeChiffre < 5) break;
                ++lg;
            }
        }
        if (neg) {
            lg = -lg;
        }
        return lg;
    }

    public static String toString(long decimalLong, char decimalSeparator) {
        Decimal decimal = DecimalLong.toDecimal(decimalLong);
        return decimal.toStringWithBlank(decimalSeparator);
    }
}

