/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.logicaloperation;

import java.util.ArrayList;
import java.util.List;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.logicaloperation.LogicalOperationUtils;
import net.mapeadores.util.logicaloperation.Operand;
import net.mapeadores.util.logicaloperation.RuntimeOperandException;
import net.mapeadores.util.logicaloperation.SubOperand;

class InformatiqueParser {
    private static final short WAINTING_FOR_OPERANDE = 1;
    private static final short ON_SIMPLE_OPERANDE = 2;
    private static final short WAITING_FOR_OPERATOR = 3;
    private final String operationString;
    private final SubOperandBuilder rootBuilder;
    private int currentIndex;
    private int remainingLength;
    private short state;
    private boolean currentAcceptMode;
    private SubOperandBuilder currentSubOperandBuilder;

    InformatiqueParser(String operationString) {
        this.operationString = operationString;
        this.currentIndex = 0;
        this.remainingLength = operationString.length() - 1;
        this.state = 1;
        this.currentAcceptMode = true;
        this.currentSubOperandBuilder = this.rootBuilder = new SubOperandBuilder(null, true);
    }

    Operand toOperand() {
        Operand result = this.rootBuilder.toOperand(false);
        if (result == null) {
            throw new RuntimeOperandException("empty", 0);
        }
        return result;
    }

    void parse() {
        while (this.remainingLength >= 0) {
            this.test();
        }
        while (!this.currentSubOperandBuilder.isRoot()) {
            this.flushCurrentSubOperand();
        }
    }

    private void test() {
        switch (this.state) {
            case 1: {
                this.testWaitingForOperand();
                break;
            }
            case 2: {
                this.testOnSimpleOperande();
                break;
            }
            case 3: {
                this.testWaitingForOperator();
                break;
            }
            default: {
                throw new SwitchException("Unknown state = " + this.state);
            }
        }
    }

    private void testWaitingForOperand() {
        char carac = this.operationString.charAt(this.currentIndex);
        if (!Character.isWhitespace(carac)) {
            if (carac == '(') {
                SubOperandBuilder newOperandBuilder = new SubOperandBuilder(this.currentSubOperandBuilder, this.currentAcceptMode);
                this.currentSubOperandBuilder.add(newOperandBuilder);
                this.currentSubOperandBuilder = newOperandBuilder;
                this.changeState((short)1);
            } else if (carac == ')') {
                this.flushCurrentSubOperand();
                this.changeState((short)3);
            } else if (carac == '!') {
                this.currentAcceptMode = !this.currentAcceptMode;
            } else {
                if (carac == '&' || carac == '|') {
                    if (this.remainingLength == 0 || this.operationString.charAt(this.currentIndex + 1) != carac) {
                        throw new RuntimeOperandException("missingOperatorSecondaryChar", this.currentIndex);
                    }
                    throw new RuntimeOperandException("unexpectedOperator", this.currentIndex);
                }
                this.currentSubOperandBuilder.newSimpleOperand(carac, this.currentAcceptMode);
                this.changeState((short)2);
            }
        }
        this.next();
    }

    private void testOnSimpleOperande() {
        char carac = this.operationString.charAt(this.currentIndex);
        if (carac == '&' || carac == '|') {
            if (this.remainingLength == 0 || this.operationString.charAt(this.currentIndex + 1) != carac) {
                throw new RuntimeOperandException("missingOperatorSecondaryChar", this.currentIndex);
            }
            boolean test = this.currentSubOperandBuilder.checkOperator(InformatiqueParser.toOperator(carac));
            if (!test) {
                throw new RuntimeOperandException("differentOperator", this.currentIndex);
            }
            this.changeState((short)1);
            this.next();
        } else if (carac == ')') {
            this.flushCurrentSubOperand();
            this.changeState((short)3);
        } else {
            if (carac == '(') {
                throw new RuntimeOperandException("openingParenthesis", this.currentIndex);
            }
            if (carac == '\\' && this.remainingLength > 0) {
                char nextChar = this.operationString.charAt(this.currentIndex + 1);
                switch (nextChar) {
                    case '&': 
                    case '(': 
                    case ')': 
                    case '\\': 
                    case '|': {
                        this.currentSubOperandBuilder.appendToSimpleOperand(nextChar);
                        this.next();
                        break;
                    }
                    default: {
                        this.currentSubOperandBuilder.appendToSimpleOperand(carac);
                        break;
                    }
                }
            } else {
                this.currentSubOperandBuilder.appendToSimpleOperand(carac);
            }
        }
        this.next();
    }

    private void testWaitingForOperator() {
        char carac = this.operationString.charAt(this.currentIndex);
        if (!Character.isWhitespace(carac)) {
            if (carac == '&' || carac == '|') {
                if (this.remainingLength == 0 || this.operationString.charAt(this.currentIndex + 1) != carac) {
                    throw new RuntimeOperandException("missingOperatorSecondaryChar", this.currentIndex);
                }
                boolean test = this.currentSubOperandBuilder.checkOperator(InformatiqueParser.toOperator(carac));
                if (!test) {
                    throw new RuntimeOperandException("differentOperator", this.currentIndex);
                }
                this.changeState((short)1);
                this.next();
            } else if (carac == ')') {
                this.flushCurrentSubOperand();
            } else {
                throw new RuntimeOperandException("missingOperator", this.currentIndex);
            }
        }
        this.next();
    }

    private void flushCurrentSubOperand() {
        if (this.currentSubOperandBuilder.isRoot()) {
            throw new RuntimeOperandException("tooManyClosingParenthesis", this.currentIndex);
        }
        this.currentSubOperandBuilder = this.currentSubOperandBuilder.getParentBuilder();
    }

    private void changeState(short newState) {
        this.state = newState;
        this.currentAcceptMode = true;
    }

    private void next() {
        ++this.currentIndex;
        --this.remainingLength;
    }

    private static short toOperator(char carac) {
        switch (carac) {
            case '&': {
                return 1;
            }
            case '|': {
                return 2;
            }
        }
        throw new SwitchException("Unknown operator character = " + carac);
    }

    private static boolean testScopeChar(char carac) {
        if (carac == '_') {
            return true;
        }
        if (carac >= 'a' && carac <= 'z') {
            return true;
        }
        if (carac >= 'A' && carac <= 'Z') {
            return true;
        }
        if (carac >= '0' && carac <= '9') {
            return true;
        }
        switch (carac) {
            case '!': 
            case ',': 
            case '-': 
            case '.': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    private static class SubOperandBuilder
    extends OperandBuilder {
        private final boolean acceptMode;
        private short operator = 0;
        private final SubOperandBuilder parentBuilder;
        private SimpleOperandBuilder currentSimpleOperandBuilder;
        private final List<OperandBuilder> builderList = new ArrayList<OperandBuilder>();

        private SubOperandBuilder(SubOperandBuilder parentBuilder, boolean acceptMode) {
            this.acceptMode = acceptMode;
            this.parentBuilder = parentBuilder;
        }

        private boolean checkOperator(short newOperator) {
            if (this.operator == 0) {
                this.operator = newOperator;
                return true;
            }
            return this.operator == newOperator;
        }

        private void add(SubOperandBuilder subOperandBuilder) {
            this.builderList.add(subOperandBuilder);
        }

        private SubOperandBuilder getParentBuilder() {
            return this.parentBuilder;
        }

        private void newSimpleOperand(char carac, boolean acceptMode) {
            SimpleOperandBuilder simpleOperandBuilder = new SimpleOperandBuilder(acceptMode);
            simpleOperandBuilder.append(carac);
            this.currentSimpleOperandBuilder = simpleOperandBuilder;
            this.builderList.add(simpleOperandBuilder);
        }

        private void appendToSimpleOperand(char carac) {
            this.currentSimpleOperandBuilder.append(carac);
        }

        @Override
        protected Operand toOperand(boolean inverse) {
            int size;
            if (!this.acceptMode) {
                boolean bl = inverse = !inverse;
            }
            if ((size = this.builderList.size()) == 0) {
                return null;
            }
            if (size == 1) {
                return this.builderList.get(0).toOperand(inverse);
            }
            if (this.operator == 0) {
                this.operator = (short)2;
            }
            if (inverse) {
                this.operator = LogicalOperationUtils.inverseOperator(this.operator);
            }
            ArrayList<Operand> resultList = new ArrayList<Operand>();
            for (int i = 0; i < size; ++i) {
                Operand operand = this.builderList.get(i).toOperand(inverse);
                if (operand == null) continue;
                if (operand instanceof SubOperand) {
                    SubOperand subOperand = (SubOperand)operand;
                    if (subOperand.getOperator() == this.operator) {
                        int childLength = subOperand.size();
                        for (int j = 0; j < childLength; ++j) {
                            resultList.add((Operand)subOperand.get(j));
                        }
                        continue;
                    }
                    resultList.add(operand);
                    continue;
                }
                resultList.add(operand);
            }
            int size2 = resultList.size();
            if (size2 == 0) {
                return null;
            }
            if (size2 == 1) {
                return (Operand)resultList.get(1);
            }
            return LogicalOperationUtils.toSubOperand(resultList.toArray(new Operand[size2]), this.operator);
        }

        private boolean isRoot() {
            return this.parentBuilder == null;
        }
    }

    private static class SimpleOperandBuilder
    extends OperandBuilder {
        private boolean acceptMode;
        private final StringBuilder buf = new StringBuilder();
        private boolean withWhiteSpace;
        private boolean maybeScope = true;
        private int lastColonIndex = -1;

        private SimpleOperandBuilder(boolean acceptMode) {
            this.acceptMode = acceptMode;
        }

        private void append(char c) {
            if (Character.isWhitespace(c)) {
                if (this.buf.length() > 0) {
                    this.maybeScope = false;
                    this.withWhiteSpace = true;
                }
            } else {
                if (this.withWhiteSpace) {
                    this.buf.append(' ');
                    this.withWhiteSpace = false;
                }
                this.buf.append(c);
                if (this.maybeScope) {
                    if (c == ':') {
                        int colonIndex = this.buf.length() - 1;
                        if (colonIndex == 0) {
                            this.maybeScope = false;
                        } else {
                            this.lastColonIndex = colonIndex;
                        }
                    } else if (!InformatiqueParser.testScopeChar(c)) {
                        this.maybeScope = false;
                    }
                }
            }
        }

        @Override
        protected Operand toOperand(boolean inverse) {
            String body;
            String scope;
            if (inverse) {
                boolean bl = this.acceptMode = !this.acceptMode;
            }
            if (this.buf.length() == 0) {
                return null;
            }
            String operandString = this.buf.toString();
            if (this.lastColonIndex > 0) {
                scope = operandString.substring(0, this.lastColonIndex);
                body = operandString.substring(this.lastColonIndex + 1).trim();
            } else {
                scope = "";
                body = operandString;
            }
            return LogicalOperationUtils.toSimpleOperand(this.acceptMode, operandString, scope, body);
        }
    }

    private static abstract class OperandBuilder {
        protected OperandBuilder() {
        }

        protected abstract Operand toOperand(boolean var1);
    }
}

