/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.logging;

import java.util.List;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.logging.MessageSource;
import net.mapeadores.util.logging.MessageSourceBuilder;

public class SimpleMessageHandler
implements MessageHandler {
    private final MessageSourceBuilder builder = new MessageSourceBuilder("");

    @Override
    public void addMessage(String category, Message message) {
        this.builder.addMessage(category, message);
    }

    public boolean hasMessage() {
        return !this.builder.isEmpty();
    }

    public List<MessageSource.Entry> toList() {
        return this.builder.toMessageSource().getEntryList();
    }

    public List<Message> filter(String category) {
        return this.builder.toMessageList(category);
    }

    public List<Message> filterWarning() {
        return this.builder.toMessageList("warning.");
    }

    public List<Message> filterSevere() {
        return this.builder.toMessageList("severe.");
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        List<MessageSource.Entry> list = this.builder.toMessageSource().getEntryList();
        for (MessageSource.Entry entry : list) {
            Message message = entry.getMessage();
            if (buf.length() > 0) {
                buf.append("\n");
            }
            buf.append(message.getMessageKey());
            Object[] values = message.getMessageValues();
            int length = values.length;
            if (length <= 0) continue;
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    buf.append(" / ");
                } else {
                    buf.append(": ");
                }
                buf.append(values[i].toString());
            }
        }
        return buf.toString();
    }
}

