/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.logging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.mapeadores.util.logging.LineMessage;
import net.mapeadores.util.logging.LineMessageHandler;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.logging.MessageByLine;

public class SimpleLineMessageHandler
implements LineMessageHandler {
    private final SortedMap<Integer, InternalMessageByLine> messageByLineMap = new TreeMap<Integer, InternalMessageByLine>();

    @Override
    public void addMessage(String category, LineMessage message) {
        int lineNumber = message.getLineNumber();
        InternalMessageByLine messageByLine = (InternalMessageByLine)this.messageByLineMap.get(lineNumber);
        if (messageByLine == null) {
            messageByLine = new InternalMessageByLine(lineNumber);
            this.messageByLineMap.put(lineNumber, messageByLine);
        }
        messageByLine.add(category, message);
    }

    public boolean hasMessage() {
        return !this.messageByLineMap.isEmpty();
    }

    public List<MessageByLine> toMessageByLineList() {
        return LogUtils.wrap(this.messageByLineMap.values().toArray(new MessageByLine[this.messageByLineMap.size()]));
    }

    public List<LineMessage> toLineMessageList() {
        ArrayList<LineMessage> result = new ArrayList<LineMessage>();
        for (InternalMessageByLine line : this.messageByLineMap.values()) {
            for (MessageByLine.Category category : line.getCategoryList()) {
                for (LineMessage message : category.getMessageList()) {
                    result.add(message);
                }
            }
        }
        return result;
    }

    private static class InternalMessageByLine
    implements MessageByLine {
        private final int lineNumber;
        private final Map<String, InternalCategory> categoryMap = new HashMap<String, InternalCategory>();
        private final List<MessageByLine.Category> categoryList = new ArrayList<MessageByLine.Category>();

        private InternalMessageByLine(int lineNumber) {
            this.lineNumber = lineNumber;
        }

        @Override
        public int getLineNumber() {
            return this.lineNumber;
        }

        @Override
        public List<MessageByLine.Category> getCategoryList() {
            return this.categoryList;
        }

        private void add(String categoryName, LineMessage message) {
            InternalCategory category = this.categoryMap.get(categoryName);
            if (category == null) {
                category = new InternalCategory(categoryName);
                this.categoryMap.put(categoryName, category);
                this.categoryList.add(category);
            }
            category.add(message);
        }
    }

    private static class InternalCategory
    implements MessageByLine.Category {
        private final String name;
        private final List<LineMessage> messageList = new ArrayList<LineMessage>();

        private InternalCategory(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<LineMessage> getMessageList() {
            return this.messageList;
        }

        private void add(LineMessage message) {
            this.messageList.add(message);
        }
    }
}

