/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.logging;

import java.io.IOException;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.logging.MessageLog;
import net.mapeadores.util.logging.MessageSource;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class MessageXMLPart
extends XMLPart {
    public MessageXMLPart(XMLWriter xmlWriter) {
        super(xmlWriter);
    }

    public void addLogs(MessageLog messageLog) throws IOException {
        this.openTag("logs");
        for (MessageSource messageSource : messageLog.getMessageSourceList()) {
            this.addMessageSource(messageSource);
        }
        this.closeTag("logs");
    }

    public void addMessageSource(MessageSource messageSource) throws IOException {
        String name = messageSource.getName();
        this.startOpenTag("log");
        this.addAttribute("name", name);
        this.addAttribute("uri", name);
        this.endOpenTag();
        for (MessageSource.Entry entry : messageSource.getEntryList()) {
            this.addMessage(entry.getMessage(), entry.getCategory());
        }
        this.closeTag("log");
    }

    public void addMessage(Message message) throws IOException {
        this.addMessage(message, null);
    }

    private void addMessage(Message message, String category) throws IOException {
        this.startOpenTag("message");
        this.addAttribute("category", category);
        this.addAttribute("key", message.getMessageKey());
        Object[] values = message.getMessageValues();
        if (values.length == 0) {
            this.closeEmptyTag();
        } else {
            this.endOpenTag();
            for (Object val : values) {
                this.addSimpleElement("value", val.toString());
            }
            this.closeTag("message");
        }
    }
}

