/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.io.IOUtils;

public interface DocStream {
    public InputStream getInputStream() throws IOException;

    public String getMimeType();

    public String getCharset();

    public int getLength();

    public long getLastModified();

    default public String getContent() {
        String string;
        block9: {
            String charset = this.getCharset();
            if (charset == null) {
                return "";
            }
            InputStream is = this.getInputStream();
            try {
                string = IOUtils.toString(is, charset);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new NestedIOException(ioe);
                }
            }
            is.close();
        }
        return string;
    }

    default public Reader getReader() throws IOException {
        return new InputStreamReader(this.getInputStream(), this.getCharset());
    }
}

