/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.http;

import net.mapeadores.util.http.UrlStatus;

public final class UrlStatusUtils {
    public static final UrlStatus MALFORMED = new UrlStatus("malformed");
    public static final UrlStatus RELATIVE = new UrlStatus("relative");
    public static final UrlStatus UNKNOWN_PROTOCOL = new UrlStatus("unknown_protocol");
    public static final UrlStatus UNREACHABLE = new UrlStatus("unreachable");
    public static final UrlStatus TIMEOUT = new UrlStatus("timeout");
    public static final UrlStatus BAD_HTTP = new UrlStatus("bad_http");
    public static final UrlStatus MISSING_REDIRECTION = new UrlStatus("missing_redirection");
    public static final UrlStatus REDIRECTION_LIMIT = new UrlStatus("redirection_limit");
    public static final UrlStatus OK = new UrlStatus("ok");

    private UrlStatusUtils() {
    }

    public static String checkState(String state) {
        switch (state) {
            case "bad_http": {
                return "bad_http";
            }
            case "http_error": {
                return "http_error";
            }
            case "malformed": {
                return "malformed";
            }
            case "missing_redirection": {
                return "missing_redirection";
            }
            case "not_found": {
                return "not_found";
            }
            case "ok": {
                return "ok";
            }
            case "redirection": {
                return "redirection";
            }
            case "redirection_limit": {
                return "redirection_limit";
            }
            case "relative": {
                return "relative";
            }
            case "unknown_protocol": {
                return "unknown_protocol";
            }
            case "unreachable": {
                return "unreachable";
            }
            case "timeout": {
                return "timeout";
            }
        }
        return state;
    }

    static int getSpecialCode(String state) {
        switch (state) {
            case "bad_http": {
                return 1;
            }
            case "malformed": {
                return 2;
            }
            case "missing_redirection": {
                return 3;
            }
            case "ok": {
                return 4;
            }
            case "redirection_limit": {
                return 5;
            }
            case "relative": {
                return 6;
            }
            case "unknown_protocol": {
                return 7;
            }
            case "unreachable": {
                return 8;
            }
            case "timeout": {
                return 9;
            }
        }
        return 0;
    }

    static UrlStatus getSpecial(int specialCode) {
        switch (specialCode) {
            case 1: {
                return BAD_HTTP;
            }
            case 2: {
                return MALFORMED;
            }
            case 3: {
                return MISSING_REDIRECTION;
            }
            case 4: {
                return OK;
            }
            case 5: {
                return REDIRECTION_LIMIT;
            }
            case 6: {
                return RELATIVE;
            }
            case 7: {
                return UNKNOWN_PROTOCOL;
            }
            case 8: {
                return UNREACHABLE;
            }
            case 9: {
                return TIMEOUT;
            }
        }
        return null;
    }
}

