/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.html;

import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.LineMessage;
import net.mapeadores.util.logging.LogUtils;

public final class HtmlPrinterUtils {
    private HtmlPrinterUtils() {
    }

    public static boolean printCommandMessage(HtmlPrinter hp, @Nullable CommandMessage commandMessage, String doneClasses, String errorClasses) {
        if (commandMessage == null) {
            return false;
        }
        String classes = commandMessage.isErrorMessage() ? errorClasses : doneClasses;
        HtmlPrinterUtils.printCommandMessage(hp, commandMessage, classes);
        return true;
    }

    public static boolean printCommandMessage(HtmlPrinter hp, @Nullable CommandMessage commandMessage, HtmlAttributes doneAttributes, HtmlAttributes errorAttributes) {
        if (commandMessage == null) {
            return false;
        }
        HtmlAttributes spanAttr = doneAttributes;
        if (commandMessage.isErrorMessage()) {
            spanAttr = errorAttributes;
        }
        HtmlPrinterUtils.printCommandMessage(hp, commandMessage, spanAttr);
        return true;
    }

    private static boolean printCommandMessage(HtmlPrinter hp, CommandMessage commandMessage, HtmlAttributes attributes) {
        hp.P().SPAN(attributes).__localize(commandMessage)._SPAN();
        if (commandMessage.hasMultiError()) {
            hp.SPAN(attributes).SMALL();
            for (Message message : commandMessage.getMultiErrorList()) {
                HtmlPrinterUtils.printSubMessage(hp, message);
            }
            hp._SMALL()._SPAN();
        } else if (commandMessage.hasLog()) {
            hp.BR().PRE().__escape(LogUtils.toString(commandMessage.getMessageLog()), true)._PRE();
        }
        hp._P();
        return true;
    }

    private static boolean printSubMessage(HtmlPrinter hp, Message message) {
        hp.BR();
        if (message instanceof LineMessage) {
            hp.__append(((LineMessage)message).getLineNumber()).__escape(": ");
        }
        hp.__localize(message);
        return true;
    }

    private static boolean printCommandMessage(HtmlPrinter hp, CommandMessage commandMessage, String classes) {
        hp.P().SPAN(classes).__localize(commandMessage)._SPAN();
        if (commandMessage.hasMultiError()) {
            hp.SPAN(classes).SMALL();
            for (Message message : commandMessage.getMultiErrorList()) {
                HtmlPrinterUtils.printSubMessage(hp, message);
            }
            hp._SMALL()._SPAN();
        } else if (commandMessage.hasLog()) {
            hp.BR().PRE().__escape(LogUtils.toString(commandMessage.getMessageLog()), true)._PRE();
        }
        hp._P();
        return true;
    }
}

