/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.format;

import java.math.BigDecimal;
import java.text.ParseException;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.money.MoneyUtils;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.text.StringUtils;

public class SumEngine {
    private SumEngine() {
    }

    public static String compute(String s, short sumCastType) {
        switch (sumCastType) {
            case 2: 
            case 5: {
                return SumEngine.computeDecimal(s);
            }
            case 1: {
                return SumEngine.computeInteger(s);
            }
            case 4: {
                return SumEngine.computeMoney(s);
            }
        }
        return s;
    }

    private static String computeDecimal(String s) {
        String[] tokens = StringUtils.getTechnicalTokens(s, ';', false);
        int length = tokens.length;
        if (length == 0) {
            return "";
        }
        BigDecimal result = new BigDecimal(0);
        for (int i = 0; i < length; ++i) {
            SignedToken token = SumEngine.checkToken(tokens[i]);
            try {
                BigDecimal bigDecimal = StringUtils.parseBigDecimal(token.token);
                if (!token.positive) {
                    bigDecimal = bigDecimal.negate();
                }
                result = result.add(bigDecimal);
                continue;
            }
            catch (NumberFormatException nfe) {
                return "#Not number: " + tokens[i];
            }
        }
        return result.toString();
    }

    private static String computeMoney(String s) {
        String[] tokens = StringUtils.getTechnicalTokens(s, ';', false);
        int length = tokens.length;
        if (length == 0) {
            return "";
        }
        ExtendedCurrency currency = null;
        BigDecimal result = new BigDecimal(0);
        for (String token : tokens) {
            ExtendedCurrency currentCurrency;
            String[] money = MoneyUtils.splitMoney(token);
            if (money == null) {
                return "#Not money: " + token;
            }
            try {
                currentCurrency = ExtendedCurrency.parse(money[1]);
            }
            catch (ParseException pe) {
                return "#Invalid currency: " + money[1];
            }
            if (currency == null) {
                currency = currentCurrency;
            } else if (!currentCurrency.equals(currency)) {
                return "#Different currencies: " + currency.getCurrencyCode() + " / " + currentCurrency.getCurrencyCode();
            }
            SignedToken signedToken = SumEngine.checkToken(money[0]);
            try {
                BigDecimal bigDecimal = StringUtils.parseBigDecimal(signedToken.token);
                if (!signedToken.positive) {
                    bigDecimal = bigDecimal.negate();
                }
                result = result.add(bigDecimal);
            }
            catch (NumberFormatException nfe) {
                return "#ERROR: " + token;
            }
        }
        return result.toString() + " " + currency.getCurrencyCode();
    }

    private static String computeInteger(String s) {
        String[] tokens = StringUtils.getTechnicalTokens(s, ';', false);
        int length = tokens.length;
        if (length == 0) {
            return "";
        }
        long result = 0L;
        for (int i = 0; i < length; ++i) {
            SignedToken token = SumEngine.checkToken(tokens[i]);
            try {
                Decimal decimal = StringUtils.parseDecimal(token.token);
                long l = decimal.getPartieEntiere();
                if (!token.positive) {
                    l = -l;
                }
                result += l;
                continue;
            }
            catch (NumberFormatException nfe) {
                return "#Not number: " + tokens[i];
            }
        }
        return String.valueOf(result);
    }

    private static SignedToken checkToken(String token) {
        int length = token.length();
        int lastIndex = -1;
        boolean positive = true;
        for (int i = 0; i < length; ++i) {
            char carac = token.charAt(i);
            if (carac == '-') {
                positive = !positive;
                continue;
            }
            if (carac == ' ') continue;
            lastIndex = i;
            break;
        }
        if (lastIndex > 0) {
            token = token.substring(lastIndex).trim();
        }
        return new SignedToken(positive, token);
    }

    private static class SignedToken {
        private final boolean positive;
        private final String token;

        private SignedToken(boolean positive, String token) {
            this.positive = positive;
            this.token = token;
        }
    }
}

