/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.format;

import java.util.List;
import net.mapeadores.util.format.Calcul;
import net.mapeadores.util.format.FormatDef;

public final class FormatUtils {
    private FormatUtils() {
    }

    public static boolean getBoolean(FormatDef formatDef, String key) {
        return FormatUtils.toBoolean(formatDef.getParameterValue(key));
    }

    public static boolean getBoolean(FormatDef formatDef, String key, boolean defaultValue) {
        return FormatUtils.toBoolean(formatDef.getParameterValue(key), defaultValue);
    }

    public static boolean toBoolean(Object value) {
        return FormatUtils.toBoolean(value, false);
    }

    public static boolean toBoolean(Object value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return (Boolean)value;
        }
        catch (ClassCastException cce) {
            return defaultValue;
        }
    }

    public static Calcul getCalcul(FormatDef formatDef, String key) {
        return FormatUtils.toCalcul(formatDef.getParameterValue(key));
    }

    public static Calcul toCalcul(Object value) {
        if (value == null) {
            return null;
        }
        try {
            return (Calcul)value;
        }
        catch (ClassCastException cce) {
            return null;
        }
    }

    public static int getInt(FormatDef formatDef, String key) {
        return FormatUtils.toInt(formatDef.getParameterValue(key));
    }

    public static int toInt(Object value) {
        if (value == null) {
            return -1;
        }
        try {
            int itg = (Integer)value;
            if (itg < 0) {
                return -1;
            }
            return itg;
        }
        catch (ClassCastException cce) {
            return -1;
        }
    }

    public static String getString(FormatDef formatDef, String key) {
        return FormatUtils.toString(formatDef.getParameterValue(key));
    }

    public static String toString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static char getChar(FormatDef formatDef, String key) {
        return FormatUtils.toChar(formatDef.getParameterValue(key));
    }

    public static char toChar(Object value) {
        if (value == null) {
            return ' ';
        }
        try {
            return ((Character)value).charValue();
        }
        catch (ClassCastException cce) {
            return ' ';
        }
    }

    public short getCastType(FormatDef formatDef) {
        if (FormatUtils.getBoolean(formatDef, "jsonarray")) {
            return 6;
        }
        Short castType = (Short)formatDef.getParameterValue("cast");
        if (castType == null) {
            return 0;
        }
        return castType;
    }

    public static String getPrefix(FormatDef formatDef) {
        if (FormatUtils.getBoolean(formatDef, "jsonarray")) {
            return "[";
        }
        return FormatUtils.getString(formatDef, "prefix");
    }

    public static String getSuffix(FormatDef formatDef) {
        if (FormatUtils.getBoolean(formatDef, "jsonarray")) {
            return "]";
        }
        return FormatUtils.getString(formatDef, "suffix");
    }

    public static String getInnerSeparator(FormatDef formatDef, int sourceIndex, String defaultSeparator) {
        String forced = FormatUtils.forceSeparator(formatDef);
        if (forced != null) {
            return forced;
        }
        FormatDef.InnerSeparator sep = FormatUtils.getInnerSeparatorObject(formatDef, sourceIndex);
        if (sep != null) {
            return sep.getSeparator();
        }
        Object value = formatDef.getParameterValue("sep");
        if (value != null) {
            return (String)value;
        }
        return defaultSeparator;
    }

    public static String getSourceSeparator(FormatDef formatDef, int sourceIndex1, int sourceIndex2, String defaultSeparator) {
        String forced = FormatUtils.forceSeparator(formatDef);
        if (forced != null) {
            return forced;
        }
        FormatDef.SourceSeparator sep = FormatUtils.getSourceSeparatorObject(formatDef, sourceIndex1, sourceIndex2);
        if (sep != null) {
            return sep.getSeparator();
        }
        Object value = formatDef.getParameterValue("sep");
        if (value != null) {
            return (String)value;
        }
        return defaultSeparator;
    }

    private static String forceSeparator(FormatDef formatDef) {
        if (FormatUtils.getBoolean(formatDef, "jsonarray")) {
            return ",";
        }
        if (formatDef.getParameterValue("sum") != null) {
            return ";";
        }
        return null;
    }

    private static FormatDef.InnerSeparator getInnerSeparatorObject(FormatDef formatDef, int sourceIndex) {
        List<FormatDef.InnerSeparator> innerSeparatorList = formatDef.getInnerSeparatorList();
        if (innerSeparatorList.isEmpty()) {
            return null;
        }
        for (FormatDef.InnerSeparator innerSeparator : innerSeparatorList) {
            if (innerSeparator.getSourceIndex() != sourceIndex) continue;
            return innerSeparator;
        }
        return null;
    }

    private static FormatDef.SourceSeparator getSourceSeparatorObject(FormatDef formatDef, int sourceIndex1, int sourceIndex2) {
        List<FormatDef.SourceSeparator> sourceSeparatorList = formatDef.getSourceSeparatorList();
        if (sourceSeparatorList.isEmpty()) {
            return null;
        }
        if (sourceIndex1 > sourceIndex2) {
            int tmp = sourceIndex1;
            sourceIndex1 = sourceIndex2;
            sourceIndex2 = tmp;
        }
        FormatDef.SourceSeparator nearestSourceSeparator = null;
        for (FormatDef.SourceSeparator sourceSeparator : sourceSeparatorList) {
            if (sourceSeparator.getSourceIndex1() != sourceIndex1) continue;
            int si2 = sourceSeparator.getSourceIndex2();
            if (si2 == sourceIndex2) {
                return sourceSeparator;
            }
            if (si2 > sourceIndex2 || nearestSourceSeparator != null && nearestSourceSeparator.getSourceIndex2() >= si2) continue;
            nearestSourceSeparator = sourceSeparator;
        }
        if (nearestSourceSeparator != null) {
            return nearestSourceSeparator;
        }
        return null;
    }

    public static short castTypeToShort(String s) {
        switch (s) {
            case "integer": 
            case "int": {
                return 1;
            }
            case "decimal": 
            case "double": 
            case "float": {
                return 2;
            }
            case "date": {
                return 3;
            }
            case "money": {
                return 4;
            }
            case "percentage": {
                return 5;
            }
            case "json": {
                return 6;
            }
        }
        throw new IllegalArgumentException("Unknown cast type : " + s);
    }

    public static String castTypeToString(short castType) {
        switch (castType) {
            case 1: {
                return "integer";
            }
            case 2: {
                return "decimal";
            }
            case 3: {
                return "date";
            }
            case 4: {
                return "money";
            }
            case 5: {
                return "percentage";
            }
            case 6: {
                return "json";
            }
        }
        throw new IllegalArgumentException("Unknown cast type : " + castType);
    }
}

