/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.exec;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.mapeadores.util.exec.ArgsUtils;
import net.mapeadores.util.exec.CommandDef;

public class CommandDefBuilder {
    private final String name;
    private final Map<Character, InternalUsedParameter> usedParameterMap = new LinkedHashMap<Character, InternalUsedParameter>();
    private String titleLocKey;

    public CommandDefBuilder(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
    }

    public CommandDefBuilder addUsedParameter(char letter, boolean mandatory) {
        this.usedParameterMap.put(Character.valueOf(letter), new InternalUsedParameter(letter, mandatory));
        return this;
    }

    public CommandDefBuilder setTitleLocKey(String titleLocKey) {
        this.titleLocKey = titleLocKey;
        return this;
    }

    public CommandDef toCommandDef() {
        String finalTitleLocKey = this.titleLocKey;
        if (finalTitleLocKey == null || finalTitleLocKey.isEmpty()) {
            finalTitleLocKey = this.name;
        }
        List<CommandDef.UsedParameter> usedParameterList = ArgsUtils.wrap(this.usedParameterMap.values().toArray(new CommandDef.UsedParameter[this.usedParameterMap.size()]));
        return new InternalCommandDef(this.name, finalTitleLocKey, usedParameterList);
    }

    public static CommandDefBuilder init(String name) {
        return new CommandDefBuilder(name);
    }

    private static class InternalUsedParameter
    implements CommandDef.UsedParameter {
        private final char letter;
        private final boolean mandatory;

        private InternalUsedParameter(char letter, boolean mandatory) {
            this.letter = letter;
            this.mandatory = mandatory;
        }

        @Override
        public char getLetter() {
            return this.letter;
        }

        @Override
        public boolean isMandatory() {
            return this.mandatory;
        }
    }

    private static class InternalCommandDef
    implements CommandDef {
        private final String name;
        private final String titleLocKey;
        private final List<CommandDef.UsedParameter> usedParameterList;

        public InternalCommandDef(String name, String titleLocKey, List<CommandDef.UsedParameter> usedParameterList) {
            this.name = name;
            this.titleLocKey = titleLocKey;
            this.usedParameterList = usedParameterList;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getTitleLocKey() {
            return this.titleLocKey;
        }

        @Override
        public List<CommandDef.UsedParameter> getUsedParameterList() {
            return this.usedParameterList;
        }
    }
}

